#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Instance/Check/Finalize/ExtLVCCons.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#

package SAPDB::Install::Instance::Check::Finalize::ExtLVCCons;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Common'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Common';

#
# the only thing we have to do is to set a flag the
# the livecache should be initialized 
#
sub finalizecheck {
	my ($self) = @_; 

	$self->set_errorstate ('ERROR');
	$self->msgbegin
	("running finalize check for EXTERNAL_LIVECACHE_CONSISTENCE");
	$self->msg1
	("running finalize check for EXTERNAL_LIVECACHE_CONSISTENCE...\n");

	$self->set_errorstate ('INIT_FOR_REPORT_REQUIRED');
	$self->msgend ();
	return 0
}

1;

