#!/usr/bin/perl
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/SAPDB/Install/Instance/Check/Finalize/Generic.pm#2 $
# $DateTime: 2002/01/21 13:49:16 $
# $Change: 14297 $
#

package SAPDB::Install::Instance::Check::Finalize::ConData;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Common',
		'Instance::Check::DomainUser'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Common',
	'SAPDB::Install::Instance::Check::DomainUser';

#
# finalize check for migration strategy CONSISTENT_DATA
#
sub finalizecheck {
	my ($self) = @_; 

	$self->set_errorstate ('ERROR');
	$self->msgbegin
	("running finalize check for CONSISTENT_DATA");
	$self->msg1
	("running finalize check for CONSISTENT_DATA...\n");

	my $rc = $self->domainuser ();
	unless (defined $rc && $rc == 0) {
		$self->set_errorstate ('ERROR');
		$self->msgend ();
		return undef;
	}

	$self->set_errorstate ('EXEC_MIGRATE_DATABASE_REQUIRED');
	$self->msgend ();
	return 0;
}

1;

