#!/usr/bin/perl
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/SAPDB/Install/Instance/Check/DataCons/OLTP.pm#5 $
# $DateTime: 2002/02/27 11:03:24 $
# $Change: 17183 $
#

package SAPDB::Install::Instance::Check::DataCons::OLTP;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Common',
		'Instance::Check::DataCons::ConData'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}

		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Common';

#
# datacons ()
# check if data are consistent for migration
# if instance type is 'OLTP' instance must be restartable without log
#
sub datacons {
	my ($self) = @_;
	my $dbm = $self->{dbm};

	$self->set_errorstate ('ERROR');
	$self->msgbegin ("checking data consistency");
	$self->msg0 ("checking data consistency for database migration...\n");

	$self->{instancetypename} = 'database';

	#
	# make sure that we know our mirgation strategy
	#
	my $migration_strategy = $self->get_migrationstrategy ();
	unless (defined $migration_strategy) {
		$self->msgend ();
		return -1;
	}

	if ($migration_strategy =~ /^COMPATIBLE_LOG/) {

		$self->set_errorstate ('OK');
		$self->msgend ();
		return 0;

	} elsif ($migration_strategy =~ /^CONSISTENT_DATA/) {

		# save prev class before setting new class 
		my ($prev) = ref ($self);

		my $class =
		'SAPDB::Install::Instance::Check::DataCons::ConData';

		bless ($self, $class);

		my $rc = $self->datacons ();

		# restore prev class before returning
		bless ($self, $prev);
		return $rc;
	}

	$self->msgend ();
	return -1;
}

1;
