#!/usr/bin/perl
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/SAPDB/Install/Instance/Check/DataCons.pm#2 $
# $DateTime: 2001/12/19 09:11:46 $
# $Change: 12995 $
#

package SAPDB::Install::Instance::Check::DataCons;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Conditions',
		'Instance::Check::DataCons::OLTP',
		'Instance::Check::DataCons::LVC'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA,
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Conditions';

#
# datacons ()
# check if data are consistent for migration
# if instance type is 'OLTP' instance must be restartable without log
# if instance type is 'LVC' and the migration is from 72 to 74
# the present log page must match with the highest log page of the 
# last cold backup with checkpoint 
#
sub datacons {
	my ($self) = @_; 
	my $dbm = $self->{dbm};

	#
	# find out instance type if not already known
	#
	unless (defined $self->{'instancetype'}) {
		my $rc = $self->conditions ();
		return (-1) unless (defined $rc && $rc == 0);
	}

	#
	# run required check method
	#
	my $package = 'SAPDB::Install::Instance::Check::DataCons';
	my $instancetype = $self->{'instancetype'};

	if ($instancetype =~ /^OLTP|^LVC/) {
		# save prev class before setting new class 
		my ($prev) = ref ($self);

		my $class = $package.'::'.$instancetype;
		bless ($self, $class);
		my $rc = $self->datacons ();

		# restore prev class before returning
		bless ($self, $prev);
		return $rc;
	}

	return (-1);
}

1;
