#!/usr/bin/perl
#
# SAPDB::Install::Instance.pm
#

package SAPDB::Install::Instance;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Check',
		'Instance::Operate',
		'Instance::Upgrade'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Check',
	'SAPDB::Install::Instance::Operate',
	'SAPDB::Install::Instance::Upgrade';

1;

