#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/InstInfo.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#

package SAPDB::Install::InstInfo;

sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);

	bootstrap SAPDB::Install::InstInfo;
}

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Exporter'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		import ("SAPDB::Install::$package"); 
	}
}

sub AUTOLOAD {
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::InstInfo;
}

#
# main
#
sub main {
	return (SAPDB::Install::InstInfo::Test::main (@_));
}

package SAPDB::Install::InstInfo::Test;

$DEBUG = 0;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Getopt::Long'
	);

	foreach my $package (@neededPackages) {
		unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

sub main {
	my $info = SAPDB::Install::InstInfo::new (shift);

	while (my ($key, $val) = each (%$info)) {
		next if (ref ($val) eq "HASH");
		print $key." => ".$val."\n";
	}

	while (my ($key, $val) = each (%$info)) {
		next unless (ref ($val) eq "HASH");

		print $key."\n";
		foreach my $key (sort (keys (%$val))) {
			my $val = $val->{$key};

			print "  ".$key."\n";
			foreach my $key (sort (keys (%$val))) {
				print "    ".$key." => ".$val->{$key}."\n";
			}
		}
	}

	return 0;
}

1;

