#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/History.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 

package SAPDB::Install::History;

$VERSION = 1.01;

sub BEGIN {
      @ISA = ('SAPDB::Install::Exporter');
      @EXPORT = ('setHistoryPath');
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'StdIO'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}


# package for store and read history data
#ascii  file in this format:
#   "date" "version" "dep" "instance" "pre" "install" "post" 	
#   
#   	date - time stamp
#	version - database version incl. patchlevel 	
#	dep - installation directory
#	instance - database instance, can be "-" for none
#	pre - state of instance restart check, "ok" if successful else "-"
#	install state - state of software installation, "ok" if successful else "-" 
#	post state - state of trying db_warm db instance, "ok" if successful else "-" 
#

my $historyfilename='SAPDB_history'; # filename of file containing history data

# hash containing data of current installation
%currentData = (
	'date' => SAPDB::Install::StdIO::timeStamp(),
	'version' => $SAPDB::Install::release,
	'dep' => '-',
	'instance' => '-',
	'pre' => '-',
	'install' => '-',
	'post' => '-');
	

$enable=0;

my $historyfile;

sub setHistoryPath{
	my ($path)=@_;
	-d $path or $SAPDB::Install::StartInstall::log->SetMsg("WRN: history path \"$path\" not found\n");
	$historyfile="$path/$historyfilename";
} 

sub readHistory{
	my @returnvalue; # array of hashes - lines of historyfile in hashes
	open(FD,$historyfile) or  print2stderr("readHistory(): cannot open history file \"$historyfile\"\n") and return 0;
	while(my $line=<FD>){
		chomp($line);
		if($line=~/^"([^"]*)"\t"([^"]*)"\t"([^"]*)"\t"([^"]*)"\t"([^"]*)"\t"([^"]*)"\t"([^"]*)"$/){
			 my %hash=(
				'date' => $1, 
        			'version' => $2,
        			'dep' => $3,
        			'instance' => $4,
        			'pre' => $5,
        			'install' => $6,
        			'post' => $7);
			push(@returnvalue,\%hash);
		
		}
		else{
 			$SAPDB::Install::StartInstall::log->SetMsg("WRN: line in history file has wrong format\n");
		}
	}
	close(FD);
	return @returnvalue;

}

sub writeHistory{
	unless($enable){
		return 0;
	}
	
	open(FD,">>$historyfile") or print2stderr("writeHistory(): cannot create/open historyfile \"$historyfile\"\n") and return 0;
	print FD "\"".timeStamp()."\"\t\"$currentData{'version'}\"\t\"$currentData{'dep'}\"\t\"$currentData{'instance'}\"\t\"$currentData{'pre'}\"\t\"$currentData{'install'}\"\t\"$currentData{'post'}\"\n";
	close(FD);
	return 1;
}

1;