#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/GetParam.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
#  Desc: 
#

package SAPDB::Install::GetParam;

sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);
	bootstrap SAPDB::Install::GetParam;
}

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Exporter'
	);
	foreach my $package (@neededPackages){
		unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
        }
		import ("SAPDB::Install::$package"); 
	}
}

sub AUTOLOAD {
	#print "$AUTOLOAD\n";
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::GetParam;
}

#
# main
#
sub main {
	return (SAPDB::Install::GetParam::Test::main (@_));
}

package SAPDB::Install::GetParam::Test;

$DEBUG = 0;

sub main {
	my ($dbname) = @_;

	return 0 unless (defined $dbname && $dbname ne '');

	print "dbname = ".$dbname."\n";

	my $param = SAPDB::Install::GetParam::GetParam ($dbname);
	print "type = ".$param->{'type'}."\n";
	print "\n";

	my $data = $param->{'data'};
	while (my ($key, $val) = each (%$data)) {
		print $key." => ".$val."\n";
	}

	return 0;
}

1;
