#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Exporter.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::Exporter;

sub BEGIN {
        $ExportLevel = 0;
		my $repo = SAPDB::Install::Repository::GetCurrent ();
		my @neededPackages=(
			'Trace'
		);
		foreach my $package (@neededPackages){
	  		unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
			}
			SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
		}
}



sub import {
    my $pkg = shift;
    my $callpkg = caller ($ExportLevel);
    my ($cPack,$cScript,$cLine)=caller;
    TraceMsg("start importing symbols from $pkg into $cPack\n",4,\$DEBUG,2);			
    local @exports = @{"${pkg}::EXPORT"};
    foreach (@exports) {
		s/^(\W)// and $type = $1 or $type='&';
		TraceMsg("import symbol $type$_\n",5,\$DEBUG,2);
	    *{"${callpkg}::$_"} = 
        $type eq '&' ? \&{"${pkg}::$_"} :
        $type eq '$' ? \${"${pkg}::$_"} :
        $type eq '@' ? \@{"${pkg}::$_"} :
        $type eq '%' ? \%{"${pkg}::$_"} :
        $type eq '*' ? \*{"${pkg}::$_"} :
        undef;
    }
}

1;