#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Diagnose/InstallRegistry.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: show content of install registry


package SAPDB::Install::Diagnose::InstallRegistry;

$VERSION = 1.01;

sub BEGIN {
      my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'System',
		'Registry',
		'StdIO',
		'InstallRegistry',
		'Version',
		'Values',
		'MD5Sum',
		'SetDebug',
		'Log',
		'Tools',
		'Cwd',
		'Getopt::Long',
		'Misc',
		'Cleaner'
	);
	@EXPORT=('main');
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
}


$DEBUG=0;



sub printFileList{
	my ($hrRegistryData,$packname,$path) = @_;
	print "\n\n";
	my $string="FILELIST FOR \"$packname\" ".${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Version'}." IN \"$path\"";
	my $stringlen=length($string);
	print "$string\n";
	print '_' x $stringlen."\n";
	exists ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'FileList'} or print "\t\t\tNO FILELIST\n" and return;
	foreach my $file (sort(keys(%{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'FileList'}}))){
		print "$path/$file\n";
	}
	print "\n\n\n";
}

sub printScript{
	my ($hrRegistryData,$packname,$path) = @_;
	print "\n\n";
	my $string="SCRIPT FOR \"$packname\" ".${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Version'}." IN \"$path\"";
	my $stringlen=length($string);
	print "$string\n";
	print '_' x $stringlen."\n";
	exists ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Script'} or print "\t\t\tNO SCRIPT\n" and return;
	my $line_count=1;
	foreach my $line (split("\n",${${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Script'}})){
		print "$line_count:\t$line\n";
		$line_count++;
	}
	print "\n\n\n";	
}


sub printDetails{
	my ($hrRegistryData,$packname,$path) = @_;
	
	my $table = [
			['PACKAGE DIRECTORY:',$path],
			['SOFTWARE VERSION:',${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Version'}],
			['PACKAGE VERSION:',${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'PackageVersion'}],
			['VALID:',${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Valid'} ? 'YES' : 'NO'],
			${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Mode'} =~ /\S/ ? ['MODE:',${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Mode'}.' bit'] : undef,
			$^O =~ /mswin/i ? undef : ['FILE OWNER:',${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'User'}],
			$^O =~ /mswin/i ? undef : ['FILE GROUP:',${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Group'}],
			['MODIFICATION DATE:',${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Date'}],
			['REQUIRE:',join(',',@{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Require'}})],
			['FILELIST:', exists ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'FileList'} ? 'YES' : 'NO'],
			['HAS DISPLAY NAME:', exists ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'DispName'} ? 'YES' : 'NO'],
			['SCRIPT:', exists ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Script'} ? 'YES' : 'NO'],
			['TEST FILE:', ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'TestFile'} =~ /\S/ ? ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'TestFile'} : 'NO'],
			['IS SUBPACKAGE:', ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'IsSubPackage'} ? 'YES' : 'NO'],
			${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'IsSubPackage'} ? ['PARENT PACKAGE:', (join(' in ',@{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'ParentPackage'}}))] : undef,
		
		];		

	local *realTable = $table;
	
	if( defined ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'SubPackages'} and ref(${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'SubPackages'}) eq 'ARRAY'){
			my @subs = @{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'SubPackages'}};
			foreach my $sub (@subs){
				if(ref($sub) eq 'ARRAY'){
					push @realTable, ['SUBPACKAGE:',join(' in ',@$sub)];
				}
			}
	}
	
	
	my @pathes = @{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Pathes'}};
	foreach my $path (@pathes){
		my $pathname=${%$path}{'name'};
		$pathname=~tr/[a-z]/[A-Z]/;
		push @realTable, ["$pathname:",${%$path}{'value'}];
	}


	if( defined ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Extra'} and ref(${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Extra'}) eq 'HASH'){
			my %extra = %{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'Extra'}};
			foreach my $key (keys(%extra)){
				my $name = $key;
				$name =~ tr/[a-z]/[A-Z]/;				
				push @realTable, [$name.':',$extra{$key}];
				
			}
	}
	
	removeUndefinedFromList($table);
		
	print2stdout("\n\n\n");

	printTable($table,' ' x 4);
		
}


sub printInstanceData{
	my ($hrRegistryData) = @_;
	defined $hrRegistryData or print2stderr("no instance data found\n") and return undef;
	print2stdout("\n\n\n");
	foreach my $name (keys(%$hrRegistryData)){
		my @table = (['INSTANCE:',$name]);
		foreach my $key (keys (%{${%$hrRegistryData}{$name}})){
			if($key =~ /OK$/){
				push @table, [$key.':', ${%{${%$hrRegistryData}{$name}}}{$key} ? 'YES' : (defined ${%{${%$hrRegistryData}{$name}}}{$key} ? 'NO' : 'UNKNOWN')];
			}
			elsif($key =~ /^ADDITIONAL$/){
				my $data = ${%{${%$hrRegistryData}{$name}}}{$key};
				if(ref($data) eq 'HASH'){
					foreach my $subkey (keys(%$data)){
						push @table,[$key.':',$subkey.' = '.$data->{$subkey}];						
					}	
				}
				else{
					push @table,[$key.':',defined ${%{${%$hrRegistryData}{$name}}}{$key} ? 'YES' : 'NO']
				}
			}
			else{
				push @table, [$key.':', (${%{${%$hrRegistryData}{$name}}}{$key} =~ /\S/ ? ${%{${%$hrRegistryData}{$name}}}{$key} : 'NO')];
			}
		}
		printTable(\@table,' ' x 4);
		print2stdout("\n\n\n");
	}
	return 1;
}



sub getPackageByFile{
	my ($args) = @_;
	my $file = $args->{file};
	$file = genAbsPath($file);
	-f $file or print2stderr("file $args->{file} not found\n");
	
	unless($^O =~ /mwsin/i){
		my $resolved = resolveLinks($file,10);
		defined $resolved and $file = $resolved;		
	}
	local $instregistry = ${$args->{registry}};
	$instregistry->RefreshAllFilesList();	
	my %files = %{$instregistry->AllFiles};
	
	unless($^O =~ /mswin/i){
		my %tmp_files;
        foreach my $file (keys(%files)){
			my $resolved = resolveLinks($file,10);
            if(defined $resolved){
				$tmp_files{$resolved} = $files{$file};
            }
            else{
				$tmp_files{$file} = $files{$file};
            }
		}
        %files = %tmp_files;
	}
	
	if(exists $files{$file}){
		return (@{$files{$file}},$file);
	}
	else{
		print2stderr("no such file in install registry found\n");
		return undef;
	}
}


# main symbol is called directly

sub main {
 	local @ARGV=@_;
	SetDebug(\@ARGV);
	printVersion(\@ARGV);
 	%opt_ctrl=(
		'h' => \$opt_help,
		'help' => \$opt_help,
		'l' => \$opt_list,
		'list' => \$opt_list,
		'f' => \$opt_filelist,
		'filelist' => \$opt_filelist,
		'F=s' => \$opt_file,
		'file=s' => \$opt_file,
		's' => \$opt_script,
		'script' => \$opt_script,
		'package=s' => \$opt_package,
		'valid'   => \$opt_valid,
		'invalid' => \$opt_invalid,
		'instancedata' => \$opt_instancedata
	);	
	
	my $usage= " [-h|--help] [-v|--version] [-l|--list] [-f|--filelist]\n".
				"\t[-F <file>|--file <file>] [-s|--script]\n".
				"\t[-package <packagename>] [-valid|-invalid] [-instancedata]";
	my $usage_desc =	"\t\t-h --help\t\t\tshow this\n".
						"\t\t-v --version\t\t\tshow version\n".
						"\t\t-l --list\t\t\tshort list of all installed packages\n".
						"\t\t-f --filelist\t\t\tlist all installed files\n".
						"\t\t-F --file <file>\t\tshow package info of installed <file>\n".
						"\t\t-s --script\t\t\tshow registered package scripts\n".
						"\t\t-package <packagename>\t\tselect only packages with this packagename\n".
						"\t\t-valid\t\t\t\tshow valid packages only\n".
						"\t\t-invalid\t\t\tshow invalid packages only\n".
						"\t\t-instancedata\t\tshow instance data left by unfinished instance update\n";	
	
	SAPDB::Install::Getopt::Long::Configure ('no_pass_through','no_ignore_case');
	if(!GetOptions(%opt_ctrl) || $opt_help){
		print ("\n\nusage: ".$SAPDB::Install::Config{'ProgramName'}."$usage \n\n $usage_desc\n\n\n");
		die("\n\n\n");
	}

	$SAPDB::Install::Values::diemsg = 'MaxDB install registry viewer exited abnormally';

	local $log = SAPDB::Install::Log->new();
	$SAPDB::Install::Values::log=$log;
	local $cleaner = SAPDB::Install::Cleaner->new();
	$cleaner->SetRef(\$SAPDB::Install::Values::log);
	$log->LogOff(1); # write no logfile
	my ($data_path,$prog_path)=readIndepPath();
 	-d $data_path || print2stderr("no data path found\n") && diesoft($diemsg);
 	-d "$data_path/config/install" || print2stderr("path \"$data_path/config/install\" not found\n") && diesoft($diemsg);
 	my $instRegistry=SAPDB::Install::InstallRegistry->new("$data_path/config/install",0,$log);
 	defined $instRegistry || print2stderr("cannot find install registry\n") && diesoft($diemsg); 	
 	
	if($opt_file){
		my ($packname,$path) = (getPackageByFile({'file' => $opt_file, 'registry' => \$instRegistry}));	
		defined $packname or exit -1;
		my $hrRegistryData=${%{$instRegistry->RegData}}{'HashRef_Packages'};
		my $dispname = $hrRegistryData->{$packname}->{$path}->{DispName};
		$dispname = $packname unless $dispname =~ /\S/;
		my $caption = "package \"$dispname\":";
		my $strlen=length($caption);		
		print2stdout ("\n$caption\n");
		print2stdout("-"x$strlen."\n");
		printDetails($hrRegistryData,$packname,$path);
		exit 0;
	}
		
	if($opt_list){
		$instRegistry->printPackageList($opt_package);
		exit 0;
	}
	
	if($opt_instancedata){
		my $hrRegistryData=${%{$instRegistry->RegData}}{'InstanceData'};			
		printInstanceData($hrRegistryData);
		exit(0);
	}	

	my %dispNameTable = $instRegistry->getDisplayNameTable();


	# use low level access to registry data -> faster
	my $hrRegistryData=${%{$instRegistry->RegData}}{'HashRef_Packages'};
	
	my @packages;
	if($opt_package){
		unless(exists ${%$hrRegistryData}{$opt_package}){
			if(exists $dispNameTable{$opt_package}){
				push @packages,$dispNameTable{$opt_package};	
			}
			else{
				print "\n\n\nno package \"$opt_package\" installed\n";
				die("\n\n\n");
			}
		}	
		push @packages,$opt_package; 
	}
	else{
		#select all installed packages
		@packages=$instRegistry->getPackageNames
	}
	
		

	foreach my $packname (@packages){
		
		my @allpathes;
		my %invalid_releases;
		my %valid_releases;
		unless($opt_valid and not ($opt_valid and $opt_invalid)){
			%invalid_releases = $instRegistry->getInstallPathes($packname,2);
			push @allpathes, keys(%invalid_releases);
		}
		unless($opt_invalid and not ($opt_valid and $opt_invalid)){
			%valid_releases = $instRegistry->getInstallPathes($packname,1);
			push @allpathes, keys(%valid_releases);	
		}
		$#allpathes == -1 and next;
		my %allreleases = addHashes(\%valid_releases,\%invalid_releases);
		defined %allreleases or print2stderr("unexpected error occured: cannot add invalid and valid releases\n");
		
		my %DispNames;
		
		foreach my $path (keys(%{${%$hrRegistryData}{$packname}})){
			if(exists ${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'DispName'}){
				if(exists $DispNames{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'DispName'}}){
					local *list = $DispNames{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'DispName'}};
					push @list,$path;
				}
				else{
					$DispNames{${%{${%{${%$hrRegistryData}{$packname}}}{$path}}}{'DispName'}} = [$path];
				}	
			}
			else{
				if(exists $DispNames{$packname}){
					local *list = $DispNames{$packname};
					push @list,$path;
				}
				else{
					$DispNames{$packname} = [$path];
				}	
			}			
		}
						
		
		foreach my $dispname (keys(%DispNames)){


			my $caption = "package \"$dispname\":";
			my $strlen=length($caption);
			print2stdout ("\n\n$caption\n");
			print2stdout("-"x$strlen."\n\n");
			foreach my $path (@{$DispNames{$dispname}}){
				if($opt_filelist || $opt_script){
					if($opt_filelist){
						printFileList($hrRegistryData,$packname,$path);
					}
					if($opt_script){
						printScript($hrRegistryData,$packname,$path);	
					}
				}
				else{
					printDetails($hrRegistryData,$packname,$path);
				}
			}	
		}
		print "\n\n\n";
	}
}	 	

1;