#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/DataDumper.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::DataDumper;

sub BEGIN {
        @ISA = ('SAPDB::Install::Exporter');
        @EXPORT = ('readDump','dumpit','struct2string','string2struct');
		my $repo = SAPDB::Install::Repository::GetCurrent ();
		my @neededPackages=(
			'StdIO',
			'Trace'
		);
		foreach my $package (@neededPackages) {
		  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
		            print join ("\n", $repo->GetErr)."\n";
		            die;
		    	}
			SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
		} 
}


sub mask{

        # mask data values before dumping it; dump ascii file
        my ($string_ref)=@_;
        my $ret_val=0;
        *real_string=$string_ref;
        #$real_string=~s/\\/\\\\/g and $ret_val=1; # \ -> \\     
        $real_string=~s/\(/\\\(/g and $ret_val=1; # ( -> \(     delimiter for struct types ARRAY/HASH/REF/SCALAR
        $real_string=~s/\)/\\\)/g and $ret_val=1; # ) -> \)     delimiter for struct types ARRAY/HASH/REF/SCALAR
        $real_string=~s/"/\\"/g and $ret_val=1;   # " -> \"     delimiter for values (scalars) and hash keys ""         
        $real_string=~s/;/\\;/g and $ret_val=1;   # ; -> \;     seperator for array and hash elements ";;" 
        return $ret_val;
}



sub demask{
        # demask values read from dump -> restore original values
        my ($string_ref)=@_;
        my $ret_val=0;
        *real_string=$string_ref;
        $real_string=~s/\\;/;/g and $ret_val=1;    # \; -> ;
		$real_string=~s/\\"/"/g and $ret_val=1;    # \" -> "
		$real_string=~s/\\\)/\)/g and $ret_val=1;  # \) -> )
		$real_string=~s/\\\(/\(/g and $ret_val=1;  # \( -> (
        #$real_string=~s/\\\\/\\/g and $ret_val=1;  # \\ -> \
        return $ret_val;
}


sub struct2string{
        my ($struct_ref)=@_;
		my $string;
		if(ref($struct_ref) eq 'REF'){
                TraceMsg("element is a reference\n",5,\$DEBUG);
				$string = 'REF(';
				my $substring = struct2string($$struct_ref);
				defined $substring or return undef; 
                $string .= '('.$substring.')';
        }
        elsif(ref($struct_ref) eq 'HASH'){
				TraceMsg("element is a hash\n",5,\$DEBUG);
                $string = 'HASH(';
				my $first=1;
                foreach my $key (keys(%$struct_ref)){
                        if($first){
                                $first=0;
                        }
                        else{
                                $string .= ';;';
         				}
                        my $writekey=$key;
                        TraceMsg("key is $writekey\n",5,\$DEBUG);
						mask(\$writekey);
                        $string .= "\"\"$writekey\"\" => ";
						my $substring = struct2string(${%$struct_ref}{$key});
						defined $substring or return undef;
						$string .= $substring;
				}
                $string .= ')';
		}
        elsif(ref($struct_ref) eq 'ARRAY'){
				TraceMsg("element is an array\n",5,\$DEBUG);
                $string = 'ARRAY(';
                my $first=1;
                foreach my $element (@$struct_ref){
                        if($first){
                                $first=0;
                        }
                        else{
                            $string .= ';;';
        				}
						my $substring = struct2string($element);
						defined $substring or return undef;
						$string .= $substring;
                }
                $string .= ')';
        }
        elsif(ref($struct_ref) eq 'SCALAR'){
				TraceMsg("element is a scalar\n",5,\$DEBUG);
                $string = 'SCALAR(';
                my $substring = struct2string($$struct_ref);
				defined $substring or return undef;
				$string .= $substring;
				$string .= ')';
        }
        elsif(!ref($struct_ref)){
				if(defined $struct_ref){
					TraceMsg("value is $struct_ref\n",5,\$DEBUG);
					mask(\$struct_ref);
					$string .= '""'.$struct_ref.'""';
				}
				else{
					TraceMsg("value is undefined\n",5,\$DEBUG);
					$string .= 'undef';
				}	
        }
        else{
		    TraceMsg("value is ".ref($struct_ref)."\n",5,\$DEBUG);
			$string .= ref($struct_ref);
		}
		return $string;	
}


sub dumpElement{
        # recursive sub dump struct elements
        my ($struct_ref,$fd)=@_;
		my $dumplen=0;	 	
        if(ref($struct_ref) eq 'REF'){
                TraceMsg("element is a reference\n",5,\$DEBUG);
				print $fd 'REF(';
                $dumplen=dumpElement($$struct_ref,$fd);
                print $fd ')';
        		$dumplen += 5;
		}
        elsif(ref($struct_ref) eq 'HASH'){
				TraceMsg("element is a hash\n",5,\$DEBUG);
                print $fd 'HASH(';
                $dumplen += 5;
				my $first=1;
                foreach my $key (keys(%$struct_ref)){
                        if($first){
                                $first=0;
                        }
                        else{
                                print $fd ';;';
                        	$dumplen += 2;
						}
                        my $writekey=$key;
                        TraceMsg("key is $writekey\n",5,\$DEBUG);
						mask(\$writekey);
                        print $fd "\"\"$writekey\"\" => ";
                        $dumplen += length($writekey) + 8; 
						$dumplen += dumpElement(${%$struct_ref}{$key},$fd);
                }
                print $fd ')';
				$dumplen++;	
        }
        elsif(ref($struct_ref) eq 'ARRAY'){
				TraceMsg("element is an array\n",5,\$DEBUG);
                print $fd 'ARRAY(';
                my $first=1;
                foreach my $element (@$struct_ref){
                        if($first){
                                $first=0;
                        }
                        else{
                            print $fd ';;';
                        	$dumplen += 2;
						}
                        $dumplen += dumpElement($element,$fd);
                }
                print $fd ')';
        	$dumplen++;
		}
        elsif(ref($struct_ref) eq 'SCALAR'){
				TraceMsg("element is a scalar\n",5,\$DEBUG);
                print $fd 'SCALAR(';
                $dumplen += dumpElement($$struct_ref,$fd);
                print $fd ')';
        	$dumplen += 8; 
		}
        elsif(!ref($struct_ref)){
				if(defined $struct_ref){
					TraceMsg("value is $struct_ref\n",5,\$DEBUG);
					mask(\$struct_ref);
					print $fd '""'.$struct_ref.'""';
					$dumplen += length($struct_ref) + 4;
				}
				else{
					TraceMsg("value is undefined\n",5,\$DEBUG);
					print $fd "undef";
					$dumplen += 5;
				}	
        }
        else{
		    TraceMsg("value is ".ref($struct_ref)."\n",5,\$DEBUG);
			print $fd ref($struct_ref);
			$dumplen += length(ref($struct_ref)); 	
        }
		return $dumplen;	
}



sub dumpit{
        # this sub create dump file; call recursive dump function
		# return number of written bytes
        my ($struct_ref,$file_ref,$truncate)=@_;  #file_ref -> reference to file handle or file name
        my $len=0;
		if(ref($file_ref) eq 'SCALAR'){
			TraceMsg("got file name\n",4,\$DEBUG);
			open(dumpFD,">$$file_ref") or print2stderr("ERR: DataDumper::dumpit(): data dump error - cannot create file \"$$file_ref\"\n") and return(0);
			$len=dumpElement($struct_ref,\*dumpFD);
			close(dumpFD);
		}
		elsif(ref($file_ref) eq 'GLOB'){
			TraceMsg("got file descriptor\n",4,\$DEBUG);
			fileno($file_ref) or print2stderr("dumpit(): no valid file handle\n") and return 0;
			seek($file_ref,0,0) or print2stderr("cannot seek to BOF: $!\n") and return 0;
			$len = dumpElement($struct_ref,$file_ref);
			$len=tell($file_ref);
			if($truncate){
				truncate($file_ref, $len) or print2stderr("dumpit(): cannot truncate file\n") and return 0;
			}
		}
		else{
			print2stderr("dumpit(): param error - no filename or file handle\n");
			return 0;
		}
		return($len);
}






sub splitParseString{
        # sub is used by getElement; split current struct into substructs 
        my ($parse_string)=@_;
        my @returnlist;
        my @tmp_array=split(';;',$1);
        my $cons;
        my $cnt1=0; # number of "("
        my $cnt2=0; # number of ")"
        foreach my $element (@tmp_array){
                $cnt1+=$element=~s/\(/\(/g; # count "("
                $cnt2+=$element=~s/\)/\)/g; # count ")"
                $cnt1-=$element=~s/(\\\()/$1/g; # minus masked "("
                $cnt2-=$element=~s/(\\\))/$1/g; # minus masked ")"
                my $sep;
                if($cons eq ''){
                        $sep='';
                }
                else{
                       $sep=';;';
                }
                $cons.="$sep$element";
                if($cnt1==$cnt2){
                        push @returnlist,$cons;
                        $cons='';
                        $cnt1=0;
                        $cnt2=0;
                }
        }
        if($cons){
                $SAPDB::Install::Values::log->SetMsg("ERR: DataDumper::splitParseString(): cannot restore data from dump - error parsing dump string - REST: \"$cons\" - \"(\": $cnt1 - \")\": $cnt2\n");
				return undef;
        }
		TraceMsg("parse ok\n",5,\$DEBUG);	
        return @returnlist;
}


sub getElement{
        # sub parse dumpstring and create struct elements in memory
        my ($dump_string)=@_;
        $_=$dump_string;
        if(/^ARRAY\((.*)\)$/s){
                TraceMsg("element is an array\n",5,\$DEBUG);
				my @emptyArray;
				$1 eq '' and return \@emptyArray;
				my @array=splitParseString($1);
                my @returnvalue;
                foreach my $element (@array){
                        my $anything=getElement($element);
                        push @returnvalue,$anything;
                }
                return \@returnvalue;
        }
        elsif(/^HASH\((.*)\)$/s){
				TraceMsg("element is a hash\n",5,\$DEBUG);
                my %emptyHash;
				$1 eq '' and return \%emptyHash;
				my @array=splitParseString($1);
                my %returnhash;
				foreach my $element (@array){
                        $_=$element;
                        /^""(.*?)""\s*=>\s*(\S.*)$/s or $SAPDB::Install::Values::log->SetMsg("ERR: DataDumper::getElement(): error parsing dump file - wrong hash format\n") and return undef;
                        my $key=$1;
						demask(\$key);
						TraceMsg("key is $key\n",5,\$DEBUG);
						my $anything=getElement($2);
                        $returnhash{$key}=$anything;
				}
                return \%returnhash;
        }
        elsif(/^REF\((.*)\)$/s){
				TraceMsg("element is a reference\n",5,\$DEBUG);
                my $anything=getElement($1);
                return \$anything;
        }
        elsif(/^SCALAR\(""(.*)""\)$/s){
                TraceMsg("element is a scalar\n",5,\$DEBUG);
				my $scalar_value=$1;
                demask(\$scalar_value);
				TraceMsg("value is $scalar_value\n",5,\$DEBUG);
				#$scalar_value=~s/\\"/\\\\"/g;
				#$scalar_value=~/::ind.*longfile/si and print ${\$scalar_value}."\n";
				return \$scalar_value;
        }
        elsif(/^""(.*)""$/s){
                my $value=$1;
				demask(\$value);
				TraceMsg("value is $value\n",5,\$DEBUG);
				return $value;
        }
        elsif(/^undef$/g){
			TraceMsg("value is undefined\n",5,\$DEBUG);	
			return undef;
		}
		else{
			TraceMsg("element type is unknown\n",5,\$DEBUG);		
            $SAPDB::Install::Values::log->SetMsg("ERR: DataDumper::getElement(): error parsing dump file - unkown member \"$_\"\n");
        }
}


*string2struct = \&getElement;



sub readDump{
		# sub return
		my ($file_ref)=@_; #file_ref -> reference to file handle or file name
		my $dump_string;
        my $pos;
		if(ref($file_ref) eq 'SCALAR'){
			# got a file name
			TraceMsg("got file name\n",4,\$DEBUG);
			open(dumpFD,$$file_ref) or $SAPDB::Install::Values::log->SetMsg("MSG: DataDumper::readDump(): cannot read dump: cannot open file \"$$file_ref\"\n") and return undef;
			while(<dumpFD>){
				$dump_string.=$_;
			}	
			close(dumpFD);
		}
		elsif(ref($file_ref) eq 'GLOB'){
			# got an opened	 file descriptor
			TraceMsg("got file decriptor\n",4,\$DEBUG);
			fileno($file_ref) or print2stderr("readDump(): no valid file handle\n") and return 0;
			seek($file_ref,0,0) or print2stderr("readDump(): cannot seek to position 0: $!\n") and return 0;
			while(<$file_ref>){
				$dump_string .= $_;
			}
			$pos = tell($file_ref);
			TraceMsg("current file offset: $pos\n",3,\$DEBUG);
			my $count_0s;
			$dump_string =~ s/(0*$)//s and $count_0s = length($1) and TraceMsg("remove '0's at end of string\n",4,\$DEBUG); # remove 0s at the end of string -> 0s are placeholders for reserving space on disk
			if($count_0s){
				$pos -= $count_0s; # detect end of data position
				TraceMsg("end of data position: $pos\n",3,\$DEBUG);
			}
		}
		else{
			print2stderr("readDump(): param error - no filename or file handle\n");
			return 0;
		}
		my $struct_ref=getElement($dump_string);
		return $struct_ref,$pos;
}

1;