#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Cleaner.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 

package SAPDB::Install::Cleaner;

# here you can set references of global vars containing objects which should cleaned up
# it works with scalars, arrays and hashes only

$VERSION = 1.01;

sub BEGIN {
      my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Base',
		'Trace'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

@ISA=qw(SAPDB::Install::Base);

$DEBUG = 0;


# members of class 
my %members=(
	VARREFS => \@tmp
);

sub new{
	my ($type,$path,$log) = @_;
	my $self= SAPDB::Install::Base->new;
	foreach my $key (keys(%members)){
		$self->{$key}=$members{$key};
	}
	$self = bless $self,$type;
	return $self;
}


sub SetRef{
	my ($self,$ref)=@_;
	local *reflist=$self->VARREFS;
	push @reflist,$ref;
	1;
}


sub DESTROY{
	my $self=shift;
	foreach my $ref (@{$self->VARREFS}){
		*deref=$ref;
		if(ref($ref) eq 'SCALAR'){
			TraceMsg("unset scalar\n",4,\$DEBUG);
			$deref=undef;
			next;
		}
		elsif(ref($ref) eq 'HASH'){
			 foreach my $key (keys(%deref)){
				TraceMsg("unset hash key $key\n",4,\$DEBUG);
				$deref{$key}=undef;	
			 }
			  next; 
		}
		elsif(ref($ref) eq 'ARRAY'){
			my $count=$#deref+1;
			for (my $i = 0;$i<$count;$i++){
				TraceMsg("unset array index $i\n",4,\$DEBUG);
				$deref[$i]=undef;
			}	
			next; 
		}
		elsif(ref($ref)=~/SAPDB::Install/){
			TraceMsg("unset object instance\n",4,\$DEBUG);
			$defef=undef;
		}
		elsif(ref($ref) eq 'REF'){
             TraceMsg("unset reference to a ".ref($deref)."\n",4,\$DEBUG);
			 $deref=undef;
		}
		else{
			print2stderr("Cleaner: this member is no scalar, hash, array or object reference\n");
		} 
	}
	$self->SAPDB::Install::Base::DESTROY;
}

1;