#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Base.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::Base;

#base class for all SAPDB::Install - Classes

sub BEGIN {
    @ISA=(SAPDB::Install::Exporter);
	@EXPORT=('main');
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'StdIO',
		'Trace'
	);
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
	
}


my %members=();


sub new{
	my $that = shift;
	my $class = ref($that) || $that;
	my $self ={
		%members,
	};
	my ($package,$file,$line) = caller;
	TraceMsg("create new object of class $package [in $file line $line]\n",4,\$DEBUG,3);
	bless $self,$class;
	return $self;
}

sub AUTOLOAD{
	my $self = shift;
	local *hash=$self;
	my $type = ref($self) || print2stderr("FATAL ERROR: \"$self\" is not an object \n") && diesoft($SAPDB::Install::Values::diemsg);
	my $name = $AUTOLOAD;
	my ($package,$file,$line) = caller;
	$name =~ s/.*://;
	$name =~ /destroy/i or exists $hash{$name} or print2stderr("FATAL ERROR: cannot access member \"$name\" of class \"$type\"\n") and diesoft($SAPDB::Install::Values::diemsg);
	if(@_){
		my $value = shift;
		if(exists $self->{'dirty'}){
			TraceMsg("dirty flag found in object\n",5,\$DEBUG,2);
			if(ref($value)){
				$value == $hash{$name} or $hash{'dirty'} = 1 and TraceMsg("set object dirty\n",5,\$DEBUG,2);
			}
			else{
				$value eq $hash{$name} or $hash{'dirty'} = 1 and TraceMsg("set object dirty\n",5,\$DEBUG,2);
			} 
		}
		exists $hash{'ID'} and my $id="(ID = ".$hash{'ID'}.")";
		TraceMsg("set $type$id->$name to $value [in $file line $line]\n",5,\$DEBUG,2);
		return $hash{$name} = $value;
	}
	else{
		exists $hash{'ID'} and my $id="(ID = ".$hash{'ID'}.")";
		TraceMsg("read $type$id->$name - value = ".$hash{$name}." [in $file line $line]\n",5,\$DEBUG,2);
		return $hash{$name};
	}
}

sub DESTROY{
	my ($self)=@_;
	my ($package,$file,$line) = caller;
	exists ${%$self}{'ID'} and my $id="(ID = ".${%$self}{'ID'}.")";
	TraceMsg("destroy an object of class $package $id\n",4,\$DEBUG,2);
}


1;