/**
 * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1
 * GENERATED AT Tuesday, February 15, 2005 12:15:22 AM CET
 **/
package org.omg.cwm.management.warehouseprocess;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;

import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefFeatured;


import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IMMRAssociation;


/**
 * The Warehouse Process package documents the process flows used to execute 
 * transformations. These process flows may be documented at the level of 
 * a complete TransformationActivity or its individual TransformationSteps. 
 * A WarehouseProcess object associates a transformation with a set of events 
 * which will be used to trigger the execution of the transformation.
 * 
 * 
 * 
 * The 
 * Warehouse Process package depends on the following packages:
 * 
 * 
 * 
 *     org.omg::CWM::ObjectModel::Core
 * 
 *  
 *    org.omg::CWM::ObjectModel::Behavioral
 * 
 *     org.omg::CWM::Analysis::Transformation
 * 
 * 
 * 
 * A 
 * WarehouseProcess object represents the processing of a transformation. 
 * It is instantiated as one of its subtypes WarehouseActivity or WarehouseStep, 
 * depending on whether it represents the processing of a TransformationActivity 
 * or a Transformation Step.
 * 
 * 
 * 
 * A WarehouseProcess may be associated with 
 * one or more WarehouseEvents, each identifying events that cause the processing 
 * to be initiated. It may also be associated with one or more internal events 
 * that will be triggered when processing terminates. A ProcessPackage may 
 * be used to group together related WarehouseActivities.
 * 
 * 
 * 
 * WarehouseEvents 
 * are divided into three categories: scheduled, external and internal. Scheduled 
 * events can either be defined as a point in time (each Wednesday at 2 pm) 
 * or be defined by intervals (every five minutes). A point in time event 
 * can be defined as a custom calendar which contains a set of calendar dates. 
 * This allows a series of dates to be reused across several WarehouseProcesses.
 * 
 * 
 * 
 * External 
 * events are triggered by something happening outside the data warehouse, 
 * for example by a batch process which is not described as a WarehouseProcess. 
 * Internal events are triggered by the termination of a WarehouseProcess. 
 * They can be either retry events or cascade events. Retry events normally 
 * trigger a rerun of the same WarehouseProcess, whereas cascade events normally 
 * trigger a different WarehouseProcess. An internal event may define a condition 
 * that determines whether or not the event is triggered. This condition can 
 * use details of the execution of the triggering WarehouseProcess recorded 
 * in the relevant ActivityExecution and StepExecution objects.
 * 
 * 
 * 
 * OCL Representation 
 * of Warehouse Process Constraints
 * 
 * 
 * 
 * [C-1] month must be specified when 
 * recurringType is everyYear.
 * 
 * context RecurringPointInTimeEvent inv:
 * 
 * self.recurringType=everyYear 
 * implies self.month->notEmpty
 * 
 * 
 * 
 * [C-2] month must be between 1 and 12 (inclusive) 
 * when specified.
 * 
 * context RecurringPointInTimeEvent inv:
 * 
 * self.month->notEmpty 
 * implies 1 <= self.month <= 12
 * 
 * 
 * 
 * [C-3] dayOfMonth must be specified when 
 * recurringType is everyYear or
 * 
 * everyMonth.
 * 
 * context RecurringPointInTimeEvent 
 * inv:
 * 
 * self.recurringType=everyYear or self.recurringType=everyMonth
 * 
 * implies 
 * self.dayOfMonth->notEmpty
 * 
 * 
 * 
 * [C-4] dayOfMonth must be between 1 and 31 
 * (inclusive) when specified.
 * 
 * context RecurringPointInTimeEvent inv:
 * 
 * self.dayOfMonth->notEmpty 
 * implies 1 <= self.dayOfMonth <= 31
 * 
 * 
 * 
 * [C-5] dayOfWeek must be specified 
 * when recurringType is everyWeek.
 * 
 * context RecurringPointInTimeEvent inv:
 * 
 * self.recurringType=everyWeek 
 * implies self.dayOfWeek->notEmpty
 * 
 * 
 * 
 * [C-6] hour must be specified when recurringType 
 * is everyYear or everyMonth or
 * 
 * everyWeek or everyDay.
 * 
 * context RecurringPointInTimeEvent 
 * inv:
 * 
 * self.recurringType=everyYear or self.recurringType=everyMonth or
 * 
 * self.recurringType=everyWeek 
 * or self.recurringType=everyDay
 * 
 * implies self.hour->notEmpty
 * 
 * 
 * 
 * [C-7] hour 
 * must be between 0 and 23 (inclusive) when specified.
 * 
 * context RecurringPointInTimeEvent 
 * inv:
 * 
 * self.hour->notEmpty implies 0 <= hour <= 23
 * 
 * 
 * 
 * [C-8] minute must 
 * be specified when recurringType is not everyMinute.
 * 
 * context RecurringPointInTimeEvent 
 * inv:
 * 
 * self.recurringType<>everyMinute implies self.minute->notEmpty
 * 
 * 
 * 
 * [C-9] 
 * minute must be between 0 and 59 (inclusive) when specified.
 * 
 * context RecurringPointInTimeEvent 
 * inv:
 * 
 * self.minute->notEmpty implies 0 <= self.minute <= 59
 * 
 * 
 * 
 * [C-10] second 
 * must be between 0 and 59 (inclusive).
 * 
 * context RecurringPointInTimeEvent 
 * inv:
 * 
 * 0 <= self.second <= 59
 */
public interface WarehouseProcessPackage extends javax.jmi.reflect.RefPackage  {
// each imported package where:
//   isClustered and
//   Import.visibility == public_vis and
//   importedNamespace.visibility == public_vis
public org.omg.cwm.objectmodel.core.CorePackage getCore();
public org.omg.cwm.analysis.transformation.TransformationPackage getTransformation();
public org.omg.cwm.objectmodel.behavioral.BehavioralPackage getBehavioral();

// each contained package where visibility = public_vis
public org.omg.cwm.management.warehouseprocess.datatype.DataTypePackage getDataType();
public org.omg.cwm.management.warehouseprocess.events.EventsPackage getEvents();

// each directly contained class with visibility = public_vis
public org.omg.cwm.management.warehouseprocess.WarehouseProcessClass getWarehouseProcess();
public org.omg.cwm.management.warehouseprocess.WarehouseStepClass getWarehouseStep();
public org.omg.cwm.management.warehouseprocess.ProcessPackageClass getProcessPackage();
public org.omg.cwm.management.warehouseprocess.WarehouseActivityClass getWarehouseActivity();

// each directly contained association with visibility = public_vis
public org.omg.cwm.management.warehouseprocess.EventUsesCustomCalendar getEventUsesCustomCalendar();
public org.omg.cwm.management.warehouseprocess.Event getEvent();
public org.omg.cwm.management.warehouseprocess.TriggeringProcess getTriggeringProcess();
public org.omg.cwm.management.warehouseprocess.WarehouseStepRunsTransformationStep getWarehouseStepRunsTransformationStep();
public org.omg.cwm.management.warehouseprocess.WarehouseActivityStep getWarehouseActivityStep();
public org.omg.cwm.management.warehouseprocess.WarehouseActivityRunsTransformationActivity getWarehouseActivityRunsTransformationActivity();

// each directly contained StructType with visibility = public_vis

// each directly contained EnumType with visibility = public_vis


}
