/**
 * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1
 * GENERATED AT Tuesday, February 15, 2005 12:15:22 AM CET
 **/
package org.omg.cwm.management.warehouseoperation;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;

import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefFeatured;


import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IMMRAssociation;


/**
 * The Warehouse Operation package contains classes recording the day-to-day 
 * operation of the warehouse processes.
 * 
 * 
 * 
 * The package covers three separate 
 * areas:
 * 
 * 
 * 
 *     Transformation Executions
 * 
 *     Measurements
 * 
 *     Change Requests
 * 
 * 
 * 
 * Details 
 * of the most recent executions of transformations can be recorded, identifying 
 * when they ran and whether they completed successfully. This can be used 
 * to determine how complete and up-to-date specific information in the data 
 * warehouse is.
 * 
 * 
 * 
 * An ActivityExecution represents an execution of a whole 
 * TransformationActivity, and a StepExecution object represents an execution 
 * of an individual TransformationStep. If a TransformationStep involves the 
 * use of an Operation , an associated StepExecution may reference a CallAction 
 * that records the actual arguments passed to the Operation. These classes 
 * allow the lineage of data in a data warehouse to be preserved, by recording 
 * when and how it was derived, and where it came from.
 * 
 * 
 * 
 * Measurement objects 
 * allow metrics to be held for any ModelElement. For example, they may be 
 * used to hold actual, estimated or planned values for the size of a table.
 * 
 * 
 * 
 * ChangeRequests 
 * allow details of proposed changes affecting any ModelElement to be recorded. 
 * They may also be used to keep a historical record of changes implemented 
 * or rejected. 
 * 
 * 
 * 
 * The Warehouse Operation package depends on the following 
 * packages:
 * 
 * 
 * 
 *     org.omg::CWM::ObjectModel::Core
 * 
 *     org.omg::CWM::ObjectModel::Behavioral
 * 
 *  
 *    org.omg::CWM::Analysis::Transformation
 * 
 * 
 * 
 * Separate model diagrams are 
 * shown below for each of the three main areas supported by the package.
 * 
 * 
 * 
 * OCL 
 * Representation of Warehouse Operation Constraints
 * 
 * 
 * 
 * [C-1] A ChangeRequest 
 * instance must not apply to itself.
 * 
 * context ChangeRequest
 * 
 * inv: self.modelElement 
 * -> forAll (element | element <> self)
 * 
 * 
 * 
 * [C-2] A completionDate may only 
 * be provided for a completed ChangeRequest.
 * 
 * context ChangeRequest
 * 
 * inv: 
 * self.completionDate->notEmpty implies self.completed
 * 
 * 
 * 
 * [C-3] A Measurement 
 * instance must not apply to itself.
 * 
 * context Measurement
 * 
 * inv: self.modelElement 
 * <> self
 * 
 * 
 * 
 * [C-4] If the TransformationExecution is not inProgress, the 
 * successful, status and endDate attributes must be present, and endDate 
 * must not be earlier than startDate.
 * 
 * context TransformationExecution
 * 
 * inv: 
 * self.inProgress=false implies (self.successful->notEmpty and
 * 
 * self.status->notEmpty 
 * and self.endDate->notEmpty and
 * 
 * self.endDate >= self.startDate)
 * 
 */
public interface WarehouseOperationPackage extends javax.jmi.reflect.RefPackage  {
// each imported package where:
//   isClustered and
//   Import.visibility == public_vis and
//   importedNamespace.visibility == public_vis
public org.omg.cwm.objectmodel.core.CorePackage getCore();
public org.omg.cwm.analysis.transformation.TransformationPackage getTransformation();
public org.omg.cwm.objectmodel.behavioral.BehavioralPackage getBehavioral();

// each contained package where visibility = public_vis

// each directly contained class with visibility = public_vis
public org.omg.cwm.management.warehouseoperation.MeasurementClass getMeasurement();
public org.omg.cwm.management.warehouseoperation.ChangeRequestClass getChangeRequest();
public org.omg.cwm.management.warehouseoperation.TransformationExecutionClass getTransformationExecution();
public org.omg.cwm.management.warehouseoperation.ActivityExecutionClass getActivityExecution();
public org.omg.cwm.management.warehouseoperation.StepExecutionClass getStepExecution();

// each directly contained association with visibility = public_vis
public org.omg.cwm.management.warehouseoperation.TransformationStepExecutions getTransformationStepExecutions();
public org.omg.cwm.management.warehouseoperation.TransformationActivityExecutions getTransformationActivityExecutions();
public org.omg.cwm.management.warehouseoperation.ActivityStepExecutions getActivityStepExecutions();
public org.omg.cwm.management.warehouseoperation.ModelElementMeasurement getModelElementMeasurement();
public org.omg.cwm.management.warehouseoperation.ModelElementChangeRequest getModelElementChangeRequest();
public org.omg.cwm.management.warehouseoperation.StepExecutionCallAction getStepExecutionCallAction();

// each directly contained StructType with visibility = public_vis

// each directly contained EnumType with visibility = public_vis


}
