/**
 * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1
 * GENERATED AT Tuesday, February 15, 2005 12:15:31 AM CET
 **/
package org.omg.cwm.analysis.transformation;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;

import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefFeatured;


import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IMMRAssociation;


/**
 * A key aspect of data warehousing is to extract, transform, and load data 
 * from
 * 
 * operational resources to a data warehouse or data mart for analysis. 
 * Extraction,
 * 
 * transformation, and loading can all be characterized as transformations. 
 * In fact,
 * 
 * whenever data needs to be converted from one form to another 
 * in data warehousing,
 * 
 * whether for storage, retrieval, or presentation purposes, 
 * transformations are involved.
 * 
 * Transformation, therefore, is central to 
 * data warehousing.
 * 
 * The Transformation package contains classes and associations 
 * that represent common
 * 
 * transformation metadata used in data warehousing. 
 * It covers basic transformations
 * 
 * among all types of data sources and targets: 
 * object-oriented, relational, record,
 * 
 * multidimensional, XML, OLAP, and 
 * data mining.
 * 
 * The Transformation package is designed to enable interchange 
 * of common metadata about transformation tools and activities. Specifically 
 * it is designed to: 
 * 
 * 
 * 
 * 1. Relate a transformation with its data sources 
 * and targets. These data sources and targets can be of any type (e&#46;g&#46;, 
 * object-oriented, relational) or granularity (e&#46;g&#46;, class, attribute, 
 * table, column). They can be persistent (e&#46;g&#46;, stored in a relational 
 * database) or transient.
 * 
 * 
 * 
 * 2. Accommodate both "black box" and "white box" 
 * transformations. In the case of "black box" transformations, data sources 
 * and targets are related to a transformation and to each other at a coarse-grain 
 * level. We know the data sources and targets are related through the transformation, 
 * but we don?t know how a specific piece of a data source is related to a 
 * specific piece of a data target. In the case of "white box" transformations, 
 * however, data sources and targets are related to a transformation and to 
 * each other at a fine-grain level. We know exactly how a specific piece 
 * of a data source is related to a specific piece of a data target through 
 * a specific part of the transformation.
 * 
 * 
 * 
 * 3. Allow grouping of transformations 
 * into logical units. At the functional level, a logical unit defines a single 
 * unit of work, within which all transformations must be executed and completed 
 * together. At the execution level, logical units can be used to define the 
 * execution grouping and sequencing (either explicitly through precedence 
 * constraints or implicitly through data dependencies). A key consideration 
 * here is that both parallel and sequential executions (or a combination 
 * of both) can be accommodated.
 * 
 * 
 * 
 * The Transformation package assumes the 
 * existence of the following packages that represent types of potential data 
 * sources or targets: ObjectModel (object-oriented), Relational, Record, 
 * Multidimensional, XML, OLAP, and Data Mining. The Transformation package 
 * is an integral part of the following packages: OLAP, Data Mining, Warehouse 
 * Process, and Warehouse Operation. In particular, the Transformation and 
 * Warehouse Process packages together provide metamodel constructs that facilitate 
 * scheduling and execution in data warehousing, and the Transformation and 
 * Warehouse Operation packages together provide metamodel constructs that 
 * enable data lineage in data  warehousing.
 * 
 * 
 * 
 * This section provides a description 
 * of the main features of the Transformation package,
 * 
 * as illustrated in 
 * Figure 13-1 (see specification document for figure).
 * 
 * 
 * 
 * A transformation 
 * transforms a set of source objects into a set of target objects. The elements 
 * of a data object set can be any ObjectModel model elements, but typically 
 * are tables, columns, or model elements that represent transient, in memory, 
 * objects. Data object sets can be both sources and targets for different 
 * transformations. In particular, a given data object set can be the target 
 * of one transformation and the source of one or more transformations within 
 * the same logical unit. This is often the case with transformation that 
 * produce and consume temporary objects. 
 * 
 * 
 * 
 * Transformations allow a wide 
 * range of types (and granularity) to be defined for their data sources and 
 * targets. For example, the source type of a transformation can be an XML 
 * schema while the target type is a column, if the transformation deals with 
 * storing an XML document in a column of a relational database. More typically, 
 * the source types of a transformation are classes and attributes while the 
 * target types are tables and columns, or vice versa, if the transformation 
 * deals with converting object data into relational data, or vice versa.
 * 
 * 
 * 
 * Existing 
 * programs, queries, or rules (in fact, any ObjectModel operations) can be 
 * used to perform a transformation by associating them with the transformation 
 * using the transformation use dependency.
 * 
 * 
 * 
 * Transformations can be grouped 
 * into logical units. At the functional level, they are grouped into transformation 
 * tasks, each of which defines a set of transformations that must be executed 
 * and completed together - a logical unit of work. At the execution level, 
 * transformation steps are used to coordinate the flow of control between 
 * transformation tasks, with each transformation step executing a single 
 * transformation task. The transformation steps are further grouped into 
 * transformation activities.
 * 
 * Within each transformation activity, the execution 
 * sequence of its transformation steps are defined either explicitly by using 
 * the step precedence dependency or precedence constraint, or implicitly 
 * through data dependency.
 * 
 * 
 * 
 * There are certain "white-box" transformations 
 * which are commonly used and which can relate data sources and targets to 
 * a transformation and to each other at a detailed level. These transformations 
 * are convenient to use and they provide data lineage at a fine-grain level. 
 * One such transformation is the transformation map which consists of a set 
 * of classifier maps that in turn consists of a set of feature maps or classifier-feature 
 * maps. The other is the transformation tree, which represents a transformation 
 * as an unary or binary expression tree. For an example usage of the transformation 
 * map, please see Figure 13-4.
 * 
 * 
 * 
 * The Transformation package depends on the 
 * following packages: 
 * 
 * 
 * 
 *     omg.org::CWM::ObjectModel::Behavioral
 * 
 *     
 * omg.org::CWM::ObjectModel::Core
 * 
 *     omg.org::CWM::Foundation::Expressions
 * 
 *  
 *    omg.org::CWM::Foundation::SoftwareDeployment
 * 
 * 
 * 
 * The CWM uses packages 
 * to control complexity and create groupings of logically interrelated classes 
 * and associations. The Transformation package is one such package. Within 
 * the Transformation package itself, however, the definition of subpackages 
 * is purposefully left out to reduce the length and complexity of the fully 
 * qualified names of Transformation classes and associations. There are, 
 * however, several groupings of classes and associations that form related 
 * sets of functionality within the Transformation package. Although separate 
 * subpackages have not been created for these functional areas, their identification 
 * improves the understandability of the Transformation package.
 * 
 * 
 * 
 * The Transformation 
 * package contains metamodel elements that support the following functions:
 * 
 * 
 * 
 * 1. 
 * Transformation and data lineage. These classes and associations deal with 
 * transformations and their sources, targets, constraints, and operations.
 * 
 * 
 * 
 * 2. 
 * Transformation grouping and execution. These classes and associations deal 
 * with grouping of transformations to form logical units and to define execution 
 * sequences.
 * 
 * 
 * 
 * 3. Specialized transformations. These classes and associations 
 * define specialized, "white box", transformations that are commonly used 
 * in data warehousing. The specific Transformation classes and associations 
 * supporting each functional area are delineated in Table 13-1 (see specification 
 * document for table).
 * 
 * 
 * 
 * The metamodel diagram for the Transformation package 
 * is split into four parts. The first two diagrams show the Transformation 
 * classes and associations, while the last two show the inheritance hierarchy.
 * 
 * 
 * 
 * 13.5 
 * OCL Representation of Transformation Constraints
 * 
 * 
 * 
 * [C-1] The preceding 
 * step and succeeding step of StepPrecedence must not be the same.
 * 
 * context 
 * StepPrecedence
 * 
 * inv: self.precedingStep->forAll( p | self.succeedingStep->forAll( 
 * q | p <> q ) )
 * 
 * 
 * 
 * [C-2] A TransformationTask may not be its own inverse 
 * task.
 * 
 * Identifies the Transformation
 * 
 * context TransformationTask
 * 
 * inv: 
 * self.inverseTask->forAll( p | p <> self )
 * 
 * 
 * 
 * [C-3] A TransformationTask 
 * may not be its own original task.
 * 
 * context TransformationTask
 * 
 * inv: self.originalTask->forAll( 
 * p | p <> self )
 * 
 * 
 * 
 * [C-4] The ClassifierMapToCFMap association is derived 
 * from the Namespace-ModelElement association. All ownedElement ends of the 
 * association must be ClassifierFeatureMaps.
 * 
 * context ClassifierMapToCFMap
 * 
 * inv 
 * Namespace-ModelElement.allInstances.select( ownedElement.oclIsKindOf(
 * 
 * ClassifierFeatureMap 
 * ) )
 * 
 * 
 * 
 * [C-5] The ClassifierMapToFeatureMap association is derived from 
 * the Namespace-ModelElement association. All ownedElement ends of the association 
 * must be FeatureMaps.
 * 
 * context ClassifierMapToFeatureMap
 * 
 * inv Namespace-ModelElement.allInstances.select( 
 * ownedElement.oclIsKindOf(
 * 
 * FeatureMap ) )
 */
public class TransformationPackageImpl implements com.sap.ip.mmr.m1layer.IMMRObject, org.omg.cwm.analysis.transformation.TransformationPackage {

// Java serialized version UID
static final long serialVersionUID = -1433903971L;



	protected static final com.sap.tc.logging.Location ___location = com.sap.ip.mmr.foundation.Utilities.getUtilities().getLocation(javax.jmi.reflect.RefBaseObject.class);

// variables
protected java.lang.String ___mofId;
	
transient protected com.sap.ip.mmr.StateEnum ___state = com.sap.ip.mmr.StateEnum.STATE_NEW;
final protected java.lang.String ___generatorVersion = "1.1.1";
transient protected com.sap.ip.mmr.IRepository ___repository;
transient protected javax.jmi.reflect.RefObject ___metaObject;
transient protected javax.jmi.reflect.RefFeatured ___composite = null;

transient protected com.sap.ip.mmr.m1layer.IMMRObject ___instantiator;

protected java.lang.String ___createdAt;
protected java.lang.String ___createdBy;
protected java.lang.String ___lastChangedAt;
protected java.lang.String ___lastChangedBy;
protected java.lang.String ___release;
protected int ___deprecated;


protected java.lang.String ___qualifiedName;
protected java.lang.String ___qualifiedNameImmediatePackage;
transient protected javax.jmi.reflect.RefPackage ___immediatePackage = null;


// constructors
public TransformationPackageImpl() {
}
public TransformationPackageImpl(IRepository repository) {
  ___repository = repository;
  ___mofId = com.sap.ip.mmr.Repository.createMofId();
}



// each imported package where:
//   isClustered and
//   Import.visibility == public_vis and
//   importedNamespace.visibility == public_vis
public org.omg.cwm.objectmodel.core.CorePackage getCore() { return (org.omg.cwm.objectmodel.core.CorePackage) refPackage("Core"); } 
public org.omg.cwm.foundation.expressions.ExpressionsPackage getExpressions() { return (org.omg.cwm.foundation.expressions.ExpressionsPackage) refPackage("Expressions"); } 
public org.omg.cwm.foundation.softwaredeployment.SoftwareDeploymentPackage getSoftwareDeployment() { return (org.omg.cwm.foundation.softwaredeployment.SoftwareDeploymentPackage) refPackage("SoftwareDeployment"); } 

// each contained package where visibility = public_vis

// each directly contained class with visibility = public_vis
public org.omg.cwm.analysis.transformation.TransformationClass getTransformation() { return (org.omg.cwm.analysis.transformation.TransformationClass) refClass("Transformation"); } 
public org.omg.cwm.analysis.transformation.DataObjectSetClass getDataObjectSet() { return (org.omg.cwm.analysis.transformation.DataObjectSetClass) refClass("DataObjectSet"); } 
public org.omg.cwm.analysis.transformation.TransformationTaskClass getTransformationTask() { return (org.omg.cwm.analysis.transformation.TransformationTaskClass) refClass("TransformationTask"); } 
public org.omg.cwm.analysis.transformation.TransformationStepClass getTransformationStep() { return (org.omg.cwm.analysis.transformation.TransformationStepClass) refClass("TransformationStep"); } 
public org.omg.cwm.analysis.transformation.TransformationActivityClass getTransformationActivity() { return (org.omg.cwm.analysis.transformation.TransformationActivityClass) refClass("TransformationActivity"); } 
public org.omg.cwm.analysis.transformation.PrecedenceConstraintClass getPrecedenceConstraint() { return (org.omg.cwm.analysis.transformation.PrecedenceConstraintClass) refClass("PrecedenceConstraint"); } 
public org.omg.cwm.analysis.transformation.TransformationUseClass getTransformationUse() { return (org.omg.cwm.analysis.transformation.TransformationUseClass) refClass("TransformationUse"); } 
public org.omg.cwm.analysis.transformation.TransformationMapClass getTransformationMap() { return (org.omg.cwm.analysis.transformation.TransformationMapClass) refClass("TransformationMap"); } 
public org.omg.cwm.analysis.transformation.TransformationTreeClass getTransformationTree() { return (org.omg.cwm.analysis.transformation.TransformationTreeClass) refClass("TransformationTree"); } 
public org.omg.cwm.analysis.transformation.ClassifierMapClass getClassifierMap() { return (org.omg.cwm.analysis.transformation.ClassifierMapClass) refClass("ClassifierMap"); } 
public org.omg.cwm.analysis.transformation.FeatureMapClass getFeatureMap() { return (org.omg.cwm.analysis.transformation.FeatureMapClass) refClass("FeatureMap"); } 
public org.omg.cwm.analysis.transformation.StepPrecedenceClass getStepPrecedence() { return (org.omg.cwm.analysis.transformation.StepPrecedenceClass) refClass("StepPrecedence"); } 
public org.omg.cwm.analysis.transformation.ClassifierFeatureMapClass getClassifierFeatureMap() { return (org.omg.cwm.analysis.transformation.ClassifierFeatureMapClass) refClass("ClassifierFeatureMap"); } 

// each directly contained association with visibility = public_vis
public org.omg.cwm.analysis.transformation.TransformationSource getTransformationSource() { return (org.omg.cwm.analysis.transformation.TransformationSource) refAssociation("TransformationSource"); } 
public org.omg.cwm.analysis.transformation.TransformationTarget getTransformationTarget() { return (org.omg.cwm.analysis.transformation.TransformationTarget) refAssociation("TransformationTarget"); } 
public org.omg.cwm.analysis.transformation.TransformationStepTask getTransformationStepTask() { return (org.omg.cwm.analysis.transformation.TransformationStepTask) refAssociation("TransformationStepTask"); } 
public org.omg.cwm.analysis.transformation.InverseTransformationTask getInverseTransformationTask() { return (org.omg.cwm.analysis.transformation.InverseTransformationTask) refAssociation("InverseTransformationTask"); } 
public org.omg.cwm.analysis.transformation.DataObjectSetElement getDataObjectSetElement() { return (org.omg.cwm.analysis.transformation.DataObjectSetElement) refAssociation("DataObjectSetElement"); } 
public org.omg.cwm.analysis.transformation.TransformationTaskElement getTransformationTaskElement() { return (org.omg.cwm.analysis.transformation.TransformationTaskElement) refAssociation("TransformationTaskElement"); } 
public org.omg.cwm.analysis.transformation.ClassifierMapToFeatureMap getClassifierMapToFeatureMap() { return (org.omg.cwm.analysis.transformation.ClassifierMapToFeatureMap) refAssociation("ClassifierMapToFeatureMap"); } 
public org.omg.cwm.analysis.transformation.ClassifierMapToCfmap getClassifierMapToCfmap() { return (org.omg.cwm.analysis.transformation.ClassifierMapToCfmap) refAssociation("ClassifierMapToCFMap"); } 
public org.omg.cwm.analysis.transformation.ClassifierMapSource getClassifierMapSource() { return (org.omg.cwm.analysis.transformation.ClassifierMapSource) refAssociation("ClassifierMapSource"); } 
public org.omg.cwm.analysis.transformation.ClassifierMapTarget getClassifierMapTarget() { return (org.omg.cwm.analysis.transformation.ClassifierMapTarget) refAssociation("ClassifierMapTarget"); } 
public org.omg.cwm.analysis.transformation.FeatureMapTarget getFeatureMapTarget() { return (org.omg.cwm.analysis.transformation.FeatureMapTarget) refAssociation("FeatureMapTarget"); } 
public org.omg.cwm.analysis.transformation.FeatureMapSource getFeatureMapSource() { return (org.omg.cwm.analysis.transformation.FeatureMapSource) refAssociation("FeatureMapSource"); } 
public org.omg.cwm.analysis.transformation.CfmapClassifier getCfmapClassifier() { return (org.omg.cwm.analysis.transformation.CfmapClassifier) refAssociation("CFMapClassifier"); } 
public org.omg.cwm.analysis.transformation.CfmapFeature getCfmapFeature() { return (org.omg.cwm.analysis.transformation.CfmapFeature) refAssociation("CFMapFeature"); } 

// each directly contained StructType with visibility = public_vis

// each directly contained EnumType with visibility = public_vis
public org.omg.cwm.analysis.transformation.TreeType createTreeType(java.lang.String value) { return (org.omg.cwm.analysis.transformation.TreeType) refGetEnum("org.omg.cwm.analysis.transformation.TreeType",value); } 

// return main object properties as String
public String toString() {
  	return ___qualifiedName + "::" + ___mofId + " (" + super.toString() + ") ";

}

// Meta object
public javax.jmi.reflect.RefObject refMetaObject() {
    return ___repository.selectM2ByName("org.omg.cwm.analysis.Transformation", false);

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refImmediatePackage()
 */
public javax.jmi.reflect.RefPackage refImmediatePackage() {
  		if (___immediatePackage != null) {
  			if (com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT.equals(((IMMRObject) ___immediatePackage).get___QualifiedName())) {
  				return null;
  			}
  	    } else {
  		  if (___qualifiedNameImmediatePackage != null && ___qualifiedNameImmediatePackage.compareTo(com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT) != 0) {
  		 	// set the package
  			___immediatePackage = ___repository.getTopLevelPackageM1().refPackage(___qualifiedNameImmediatePackage);
  		  }
  	    }
  	    return ___immediatePackage;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refOutermostPackage()
 */
public javax.jmi.reflect.RefPackage refOutermostPackage() {
  		javax.jmi.reflect.RefPackage rp = refImmediatePackage();
  		if (rp == null) {
  			return (javax.jmi.reflect.RefPackage) this;
  		} else {
  			if (com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT.equals(((IMMRObject) rp).get___QualifiedName())) {
  				return (javax.jmi.reflect.RefPackage) this;
  			}
  		}
  		if (rp != null && !(rp.equals(this))) {
  			javax.jmi.reflect.RefPackage rp_ = rp.refOutermostPackage();
  			if (rp_ != null) {
  				rp = rp_;
  			}
  		}
  		return rp;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refMofId()
 */
public String refMofId() {
  	return ___mofId;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refVerifyConstraints(boolean)
 */
public Collection refVerifyConstraints(boolean deepVerify) {
  		com.sap.ip.mmr.m1layer.Verifyer v = com.sap.ip.mmr.m1layer.Verifyer.createVerifyer();
  		return v.refVerifyConstraints(this,deepVerify);

}

/**
 * @see com.sap.ip.mmr.m1layer.IMMRObject#get___Repository()
 */
public IRepository get___Repository() {
  	return ___repository;

}

/**
 * @see com.sap.ip.mmr.m1layer.IMMRObject#set___Repository(IRepository)
 */
public void set___Repository(IRepository repository) {
  	___repository = repository;

}

// equality of two (IMMRObject) objects 
public boolean equals(java.lang.Object other) {
      java.lang.String otherMofId = null;
  	if (other instanceof javax.jmi.reflect.RefBaseObject) {
          otherMofId = ((javax.jmi.reflect.RefBaseObject)other).refMofId();
  	} else if (other instanceof java.lang.String) {
          otherMofId = (java.lang.String)other;
      }
      return ___mofId.equals(otherMofId);

}

// computes the hasCode of this object
public int hashCode() {
  	return ___mofId.hashCode();

}

// Was this object changed?
public boolean is___Changed() {
  	return ___state == com.sap.ip.mmr.StateEnum.STATE_CHANGED;

}

// Is the instance new or from persistence layer?
public boolean is___New() {
  	return ___state == com.sap.ip.mmr.StateEnum.STATE_NEW;

}

/*
 * @see com.sap.ip.mmr.m1layer.IMMRObject#get___State()
*/
public com.sap.ip.mmr.StateEnum get___State() {
  	return ___state;

}

/*
 * @see com.sap.ip.mmr.m1layer.IMMRObject#set___State()
*/
public void set___State(com.sap.ip.mmr.StateEnum state) {
  	___state = com.sap.ip.mmr.StateEnum.changeState(___state,state);

}

public java.lang.String get___GeneratorVersion() {
  	return ___generatorVersion;

}

public void set___CreatedAt(String createdAt) {
  	this.___createdAt = createdAt;

}

public java.lang.String get___CreatedAt() {
  	return ___createdAt;

}

public void set___CreatedBy(String createdBy) {
  	this.___createdBy = createdBy;

}

public java.lang.String get___CreatedBy() {
  	return ___createdBy;

}

public void set___LastChangedAt(String lastChangedAt) {
  	this.___lastChangedAt = lastChangedAt;

}

public java.lang.String get___LastChangedAt() {
  	return ___lastChangedAt;

}

public void set___LastChangedBy(String lastChangedBy) {
  	this.___lastChangedBy = lastChangedBy;

}

public java.lang.String get___LastChangedBy() {
  	return ___lastChangedBy;

}

public void set___Release(String release) {
  	this.___release = release;

}

public java.lang.String get___Release() {
  	return ___release;

}

public void set___Deprecated(int deprecated) {
  	this.___deprecated = deprecated;

}

public int get___Deprecated() {
  	return ___deprecated;

}

public void set___ImmediateComposite(javax.jmi.reflect.RefFeatured feature) {
  	___composite = feature;

}

// copy the attributes of another instance to this instance
public void ___copy(com.sap.ip.mmr.m1layer.IMMRObject o) {
  this.___mofId = o.get___MofId();
  this.___repository = o.get___Repository();
  this.___qualifiedName = o.get___QualifiedName();
  this.___qualifiedNameImmediatePackage = o.get___QualifiedNameImmediatePackage();
  this.___immediatePackage = o.get___ImmediatePackage();
  this.___composite = null;
  this.___createdAt = o.get___CreatedAt();
  this.___createdBy = o.get___CreatedBy();
  this.___lastChangedAt = o.get___LastChangedAt();
  this.___lastChangedBy = o.get___LastChangedBy();
  this.___release = o.get___Release();
  this.___deprecated = o.get___Deprecated();

}

// returns the MOF Id
public String get___MofId() {
  return ___mofId;

}

// set the MOF Id !!! TO BE USED BY MMR ONLY !!!
public void set___MofId(String mofId) {
  this.___mofId = mofId;

}

// returns the qualified name of this class
public java.lang.String get___QualifiedName() {
  return ___qualifiedName;

}

// returns the qualified name of the immediate package of this class
public java.lang.String get___QualifiedNameImmediatePackage() {
  return ___qualifiedNameImmediatePackage;

}

// returns the immediate package
public javax.jmi.reflect.RefPackage get___ImmediatePackage() {
  return ___immediatePackage;

}

// set the qualified name of this class
public void set___QualifiedName(String qualifiedName) {
  ___qualifiedName = qualifiedName;

}

// set the qualified name of the immediate package this class
public void set___QualifiedNameImmediatePackage(String qualifiedNameImmediatePackage) {
  ___qualifiedNameImmediatePackage = qualifiedNameImmediatePackage;

}

// set the immediate package
public void set___ImmediatePackage(javax.jmi.reflect.RefPackage immediatePackage) {
  		if (immediatePackage != null
  			&& ((com.sap.ip.mmr.m1layer.IMMRObject) immediatePackage).get___QualifiedName().equals(
  				com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT)) {
  			___immediatePackage = null;
  		} else {
  			___immediatePackage = immediatePackage;
  		}

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public List get___ListOfInstantiators() {
  		ArrayList list = new ArrayList(1);
  		IMMRObject parent = get___Instantiator();
  		while (parent != null) {
  			if (list.size() == 0) {
  				list.add(parent);
  			} else {
  				list.add(0, parent);
  			}
  			parent = parent.get___Instantiator();
  		}
  		return list;

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public IMMRObject get___Instantiator() {
  return ___instantiator;

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public void set___Instantiator(IMMRObject instantiator) {
  ___instantiator = instantiator;

}

/**
* @see com.sap.ip.mmr.m1layer.IMMRObject#throwsConstraintViolations()
*/
public boolean throwsConstraintViolations() {
  return true;

}

/**
 * @see javax.jmi.reflect.RefPackage#refGetEnum(String, String)
 */
public RefEnum refGetEnum(String enumName, String name) {
     RefEnum re = null;
     if (enumName.compareTo("TreeType") == 0) {
        if (name.compareTo("tfm_unary") == 0) {
           re = org.omg.cwm.analysis.transformation.TreeTypeEnum.TFM_UNARY;
        }
        else if (name.compareTo("tfm_binary") == 0) {
           re = org.omg.cwm.analysis.transformation.TreeTypeEnum.TFM_BINARY;
        }
     }
     return re;

}

/**
 * Initialize the refPackage, refClass and refAssociation information
 */
private void initialize() {
    if (___refPackages == null) {
    	___refPackages = new java.util.LinkedList();
  	___refPackages.add(new RefPackageAndName("Core","org.omg.cwm.objectmodel.Core",true,null));
  	___refPackages.add(new RefPackageAndName("Expressions","org.omg.cwm.foundation.Expressions",true,null));
  	___refPackages.add(new RefPackageAndName("SoftwareDeployment","org.omg.cwm.foundation.SoftwareDeployment",true,null));
    }
    if (___refClasses == null) {
    	___refClasses = new java.util.LinkedList();
  	___refClasses.add(new RefClassAndName("Transformation","org.omg.cwm.analysis.Transformation.Transformation",null));
  	___refClasses.add(new RefClassAndName("DataObjectSet","org.omg.cwm.analysis.Transformation.DataObjectSet",null));
  	___refClasses.add(new RefClassAndName("TransformationTask","org.omg.cwm.analysis.Transformation.TransformationTask",null));
  	___refClasses.add(new RefClassAndName("TransformationStep","org.omg.cwm.analysis.Transformation.TransformationStep",null));
  	___refClasses.add(new RefClassAndName("TransformationActivity","org.omg.cwm.analysis.Transformation.TransformationActivity",null));
  	___refClasses.add(new RefClassAndName("PrecedenceConstraint","org.omg.cwm.analysis.Transformation.PrecedenceConstraint",null));
  	___refClasses.add(new RefClassAndName("TransformationUse","org.omg.cwm.analysis.Transformation.TransformationUse",null));
  	___refClasses.add(new RefClassAndName("TransformationMap","org.omg.cwm.analysis.Transformation.TransformationMap",null));
  	___refClasses.add(new RefClassAndName("TransformationTree","org.omg.cwm.analysis.Transformation.TransformationTree",null));
  	___refClasses.add(new RefClassAndName("ClassifierMap","org.omg.cwm.analysis.Transformation.ClassifierMap",null));
  	___refClasses.add(new RefClassAndName("FeatureMap","org.omg.cwm.analysis.Transformation.FeatureMap",null));
  	___refClasses.add(new RefClassAndName("StepPrecedence","org.omg.cwm.analysis.Transformation.StepPrecedence",null));
  	___refClasses.add(new RefClassAndName("ClassifierFeatureMap","org.omg.cwm.analysis.Transformation.ClassifierFeatureMap",null));
    }
    if (___refAssociations == null) {
    	___refAssociations = new java.util.LinkedList();
  	___refAssociations.add(new RefAssociationAndName("TransformationSource","org.omg.cwm.analysis.Transformation.TransformationSource",null));
  	___refAssociations.add(new RefAssociationAndName("TransformationTarget","org.omg.cwm.analysis.Transformation.TransformationTarget",null));
  	___refAssociations.add(new RefAssociationAndName("TransformationStepTask","org.omg.cwm.analysis.Transformation.TransformationStepTask",null));
  	___refAssociations.add(new RefAssociationAndName("InverseTransformationTask","org.omg.cwm.analysis.Transformation.InverseTransformationTask",null));
  	___refAssociations.add(new RefAssociationAndName("DataObjectSetElement","org.omg.cwm.analysis.Transformation.DataObjectSetElement",null));
  	___refAssociations.add(new RefAssociationAndName("TransformationTaskElement","org.omg.cwm.analysis.Transformation.TransformationTaskElement",null));
  	___refAssociations.add(new RefAssociationAndName("ClassifierMapToFeatureMap","org.omg.cwm.analysis.Transformation.ClassifierMapToFeatureMap",null));
  	___refAssociations.add(new RefAssociationAndName("ClassifierMapToCFMap","org.omg.cwm.analysis.Transformation.ClassifierMapToCFMap",null));
  	___refAssociations.add(new RefAssociationAndName("ClassifierMapSource","org.omg.cwm.analysis.Transformation.ClassifierMapSource",null));
  	___refAssociations.add(new RefAssociationAndName("ClassifierMapTarget","org.omg.cwm.analysis.Transformation.ClassifierMapTarget",null));
  	___refAssociations.add(new RefAssociationAndName("FeatureMapTarget","org.omg.cwm.analysis.Transformation.FeatureMapTarget",null));
  	___refAssociations.add(new RefAssociationAndName("FeatureMapSource","org.omg.cwm.analysis.Transformation.FeatureMapSource",null));
  	___refAssociations.add(new RefAssociationAndName("CFMapClassifier","org.omg.cwm.analysis.Transformation.CFMapClassifier",null));
  	___refAssociations.add(new RefAssociationAndName("CFMapFeature","org.omg.cwm.analysis.Transformation.CFMapFeature",null));
    }

}




	private class RefPackageAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public boolean imported = false;
		public javax.jmi.reflect.RefPackage refPackage = null;
		public RefPackageAndName(java.lang.String name, java.lang.String qualifiedName, boolean imported, javax.jmi.reflect.RefPackage refPackage) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.imported = imported;
			this.refPackage = refPackage;
		}
	}

	private class RefClassAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public javax.jmi.reflect.RefClass refClass = null;
		public RefClassAndName(java.lang.String name, java.lang.String qualifiedName, javax.jmi.reflect.RefClass refClass) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.refClass = refClass;
		}
	}

	private class RefAssociationAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public javax.jmi.reflect.RefAssociation refAssociation = null;
		public RefAssociationAndName(
			java.lang.String name,
			java.lang.String qualifiedName,
			javax.jmi.reflect.RefAssociation refAssociation) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.refAssociation = refAssociation;
		}
	}

	transient private java.util.List ___refPackages= null;
	transient private java.util.List ___refClasses = null;
	transient private java.util.List ___refAssociations = null;


	/**
	 * @see javax.jmi.reflect.RefPackage#refClass(RefObject)
	 */
	public RefClass refClass(RefObject type) {
		if (type instanceof javax.jmi.model.Classifier) {
			return refClass(((javax.jmi.model.Classifier) type).getName());
		} else {
			throw new javax.jmi.reflect.InvalidCallException(type,null,"refClass()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refClass(String)
	 */
	public RefClass refClass(String typeName) {
		initialize();
		if (typeName == null) {
			throw new javax.jmi.reflect.InvalidCallException(typeName, null, "refClass()");
		}
		RefClass rc = null;
		RefClassAndName rcan = null;
		if (typeName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refClasses.iterator();
			while (i.hasNext() && rcan == null) {
				RefClassAndName rcanTemp = (RefClassAndName) i.next();
				if (typeName.equals(rcanTemp.qualifiedName)) {
					rcan = rcanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refClasses.iterator();
			while (i.hasNext() && rcan == null) {
				RefClassAndName rcanTemp = (RefClassAndName) i.next();
				if (typeName.equals(rcanTemp.name)) {
					rcan = rcanTemp;
				}
			}
		}
		if (rcan != null) {
			if (rcan.refClass == null) {
				rcan.refClass = ___repository.refClassM1(rcan.qualifiedName);
				if (rcan.refClass != null) {
					initInstance(rcan.refClass, rcan.qualifiedName);
				}
			}
			rc = rcan.refClass;
		}
		// not found -> search in packages below in case of qualified name
		if (rc == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rc == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (typeName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefClass rcTemp = rpanTemp.refPackage.refClass(typeName);
					if (rcTemp != null) {
						rc = rcTemp;
					}
				}
			}
		}	


		if (rc == null) {
			throw new javax.jmi.reflect.InvalidNameException(typeName, null);
		}
		return rc;
 	}

	private void initInstance(java.lang.Object instance, String qualifiedName) {
		if (instance != null && instance instanceof com.sap.ip.mmr.m1layer.IMMRObject) {
			com.sap.ip.mmr.m1layer.IMMRObject mmro = (com.sap.ip.mmr.m1layer.IMMRObject) instance;
			mmro.set___ImmediatePackage(this);
			mmro.set___QualifiedNameImmediatePackage(___qualifiedName);
			mmro.set___QualifiedName(qualifiedName);
			mmro.set___Instantiator(this);
			mmro.set___Repository(___repository);
			mmro.set___State(com.sap.ip.mmr.StateEnum.STATE_NEW);
		}
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refPackage(RefObject)
	 */
	public javax.jmi.reflect.RefPackage refPackage(RefObject ro) {
		final String method = "refPackage(RefObject ro)"; //$NON-NLS-1$
		javax.jmi.reflect.RefPackage rp = null;
		if (ro instanceof javax.jmi.model.ModelElement) {
			rp =
				refPackage(
					com.sap.ip.mmr.foundation.Utilities.getUtilities().encodeQualifiedName(
						((javax.jmi.model.ModelElement) ro).getQualifiedName()));
		} else {
			com.sap.ip.mmr.Repository.getCategory().errorT(___location, method, com.sap.ip.mmr.foundation.MMRResourceAccessor.getInstance().getMessageText(___repository.getConnection(), "0000")); //$NON-NLS-1$
			throw new javax.jmi.reflect.InvalidCallException(ro,null,"refPackage()");
		}
		return rp;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refPackage(String)
	 */
	public javax.jmi.reflect.RefPackage refPackage(String packageName) {
		initialize();
		if (packageName == null) {
			throw new javax.jmi.reflect.InvalidCallException(packageName, null, "refPackage()");
		}

		javax.jmi.reflect.RefPackage rp = null;


		// search for match
		RefPackageAndName rpan = null;
		if (packageName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rpan == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.equals(rpanTemp.qualifiedName)) {
					rpan = rpanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rpan == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.equals(rpanTemp.name)) {
					rpan = rpanTemp;
				}
			}
		}
		if (rpan != null) {
			rp = getRefPackage(rpan);
		}

		// not found -> search in packages below in case of qualified name
		if (rp == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rp == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefPackage rpTemp = rpanTemp.refPackage.refPackage(packageName);
					if (rpTemp != null) {
						rp = rpTemp;
					}
				}
			}
		}

        // check top level package
        if (rp == null && packageName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0 && this != ___repository.getTopLevelPackageM1()) {
        	rp = ___repository.getTopLevelPackageM1().refPackage(packageName);
        }

		// THIS CODING IN RefPackageImpl ONLY !!!!
		if (rp == null) {
			// not generated package
			rp = new com.sap.ip.mmr.m1layer.RefPackageImpl(___repository);
			((com.sap.ip.mmr.m1layer.RefPackageImpl) rp).set___QualifiedName(packageName);
			javax.jmi.reflect.RefPackage ip = null;
			javax.jmi.model.MofPackage mp = (javax.jmi.model.MofPackage) refMetaObject();
			if (mp != null) {
				javax.jmi.model.Namespace container = mp.getContainer();
				if (container == null || container.equals(___repository.getMofPackageRootM2())) {
					ip = null;
				} else {
					ip = this;
				}
			}
			((com.sap.ip.mmr.m1layer.RefPackageImpl) rp).set___ImmediatePackage(ip);
		}

		if (rp == null) {
			throw new javax.jmi.reflect.InvalidNameException(packageName, null);
		}
		return rp;
	}

	private javax.jmi.reflect.RefPackage getRefPackage(RefPackageAndName rpan) {
		if (rpan.refPackage == null) {
			if (rpan.imported) {
				//rpan.refPackage = ___repository.getTopLevelPackageM1().refPackage(rpan.qualifiedName);
				rpan.refPackage = ___repository.refPackageM1(rpan.qualifiedName);
				initInstance(rpan.refPackage, rpan.qualifiedName);
			} else {
				// create new one
				rpan.refPackage = ___repository.refPackageM1(rpan.qualifiedName);
				initInstance(rpan.refPackage, rpan.qualifiedName);
			}
		}
		return rpan.refPackage;
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refAssociation(RefObject)
	 */
	public RefAssociation refAssociation(RefObject association) {
		if (association instanceof javax.jmi.model.Association) {
			return refAssociation(((javax.jmi.model.Association) association).getName());
		} else {
			throw new javax.jmi.reflect.InvalidCallException(association, null, "refAssociation()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAssociation(String)
	 */
	public RefAssociation refAssociation(String associationName) {
		initialize();
		if (associationName == null) {
			throw new javax.jmi.reflect.InvalidCallException(associationName, null, "refAssociation()");
		}
		RefAssociation ra = null;
		RefAssociationAndName raan = null;
		if (associationName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refAssociations.iterator();
			while (i.hasNext() && raan == null) {
				RefAssociationAndName raanTemp = (RefAssociationAndName) i.next();
				if (associationName.equals(raanTemp.qualifiedName)) {
					raan = raanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refAssociations.iterator();
			while (i.hasNext() && raan == null) {
				RefAssociationAndName raanTemp = (RefAssociationAndName) i.next();
				if (associationName.equals(raanTemp.name)) {
					raan = raanTemp;
				}
			}
		}
		if (raan != null) {
			if (raan.refAssociation == null) {
				raan.refAssociation = ___repository.refAssociationM1(raan.qualifiedName);
				if (raan.refAssociation != null) {
					initInstance(raan.refAssociation, raan.qualifiedName);
				}
			}
   		    ra = raan.refAssociation;

			// set the association
			if (raan.refAssociation instanceof IMMRAssociation) {
				((IMMRAssociation) raan.refAssociation).setAssociationImpl(get___AssociationsContainer());
			}
			// must be set AFTER the qualified name
			if (raan.refAssociation instanceof com.sap.ip.mmr.m2layer.model.RefAssociationImpl) {
				((com.sap.ip.mmr.m2layer.model.RefAssociationImpl) raan.refAssociation).setAssociationImpl(
					get___AssociationsContainer());
			}
		}
		// not found -> search in packages below in case of qualified name
		if (ra == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && ra == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (associationName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefAssociation raTemp = rpanTemp.refPackage.refAssociation(associationName);
					if (raTemp != null) {
						ra = raTemp;
					}
				}
			}
		}	
		if (ra == null) {
			throw new javax.jmi.reflect.InvalidNameException(associationName, null);
		}
		return ra;
	}

	public com.sap.ip.mmr.foundation.AssociationsContainer get___AssociationsContainer() {
		return ((IMMRObject)(___repository
			.getTopLevelPackageM1()))
			.get___AssociationsContainer();
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllPackages()
	 */
	public Collection refAllPackages() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refPackages.iterator();
		while (i.hasNext()) {
			RefPackageAndName rpan = (RefPackageAndName) i.next();
			javax.jmi.reflect.RefPackage rp = rpan.refPackage;
			if (rp == null) {
				rp = refPackage(rpan.name);
			}
			list.add(rp);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllClasses()
	 */
	public Collection refAllClasses() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refClasses.iterator();
		while (i.hasNext()) {
			RefClassAndName rcan = (RefClassAndName) i.next();
			javax.jmi.reflect.RefClass rc = rcan.refClass;
			if (rc == null) {
				rc = refClass(rcan.name);
			}
			list.add(rc);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllAssociations()
	 */
	public Collection refAllAssociations() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refAssociations.iterator();
		while (i.hasNext()) {
			RefAssociationAndName raan = (RefAssociationAndName) i.next();
			javax.jmi.reflect.RefAssociation ra = raan.refAssociation;
			if (ra == null) {
				ra = refAssociation(raan.name);
			}
			list.add(ra);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refCreateStruct(RefObject, List)
	 */
	public RefStruct refCreateStruct(RefObject struct, List params) throws javax.jmi.reflect.TypeMismatchException {
		if (struct instanceof javax.jmi.model.Classifier) {
			return refCreateStruct(((javax.jmi.model.Classifier) struct).getName(), params);
		} else {
			throw new javax.jmi.reflect.InvalidCallException(struct, null, "refCreateStruct()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refCreateStruct(String, List)
	 */
	public RefStruct refCreateStruct(String structName, List params) throws javax.jmi.reflect.TypeMismatchException {
		String sn = structName;
		// create a new instance and run the appropriate constructor
		if (structName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			sn = structName;
		} else {
			sn = ___qualifiedName + IRepositoryConst.M2PackageDelimiter + structName;
		}
		return ___repository.refCreateStructM1(sn, params);
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refGetEnum(RefObject, String)
	 */
	public RefEnum refGetEnum(RefObject enum, String name) {
		if (enum instanceof javax.jmi.model.EnumerationType) {
			return refGetEnum(((javax.jmi.model.EnumerationType) enum).getName(), name);
		} else {
			RefObject mo = enum.refMetaObject();
			if (mo != null && mo instanceof javax.jmi.model.ModelElement) {
				String nameEnum = ((javax.jmi.model.ModelElement) mo).getName();
				return refGetEnum(nameEnum, name);
			}
		}
		return null;
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refDelete()
	 */
	public void refDelete() {
		___repository.refDeleteM1(this);
		___refPackages.clear();
		___refClasses.clear();
		___refAssociations.clear();
	}



}
