/**
 * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1
 * GENERATED AT Tuesday, February 15, 2005 12:15:24 AM CET
 **/
package org.omg.cwm.analysis.transformation;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;

import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefFeatured;


import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IMMRAssociation;


/**
 * A key aspect of data warehousing is to extract, transform, and load data 
 * from
 * 
 * operational resources to a data warehouse or data mart for analysis. 
 * Extraction,
 * 
 * transformation, and loading can all be characterized as transformations. 
 * In fact,
 * 
 * whenever data needs to be converted from one form to another 
 * in data warehousing,
 * 
 * whether for storage, retrieval, or presentation purposes, 
 * transformations are involved.
 * 
 * Transformation, therefore, is central to 
 * data warehousing.
 * 
 * The Transformation package contains classes and associations 
 * that represent common
 * 
 * transformation metadata used in data warehousing. 
 * It covers basic transformations
 * 
 * among all types of data sources and targets: 
 * object-oriented, relational, record,
 * 
 * multidimensional, XML, OLAP, and 
 * data mining.
 * 
 * The Transformation package is designed to enable interchange 
 * of common metadata about transformation tools and activities. Specifically 
 * it is designed to: 
 * 
 * 
 * 
 * 1. Relate a transformation with its data sources 
 * and targets. These data sources and targets can be of any type (e&#46;g&#46;, 
 * object-oriented, relational) or granularity (e&#46;g&#46;, class, attribute, 
 * table, column). They can be persistent (e&#46;g&#46;, stored in a relational 
 * database) or transient.
 * 
 * 
 * 
 * 2. Accommodate both "black box" and "white box" 
 * transformations. In the case of "black box" transformations, data sources 
 * and targets are related to a transformation and to each other at a coarse-grain 
 * level. We know the data sources and targets are related through the transformation, 
 * but we don?t know how a specific piece of a data source is related to a 
 * specific piece of a data target. In the case of "white box" transformations, 
 * however, data sources and targets are related to a transformation and to 
 * each other at a fine-grain level. We know exactly how a specific piece 
 * of a data source is related to a specific piece of a data target through 
 * a specific part of the transformation.
 * 
 * 
 * 
 * 3. Allow grouping of transformations 
 * into logical units. At the functional level, a logical unit defines a single 
 * unit of work, within which all transformations must be executed and completed 
 * together. At the execution level, logical units can be used to define the 
 * execution grouping and sequencing (either explicitly through precedence 
 * constraints or implicitly through data dependencies). A key consideration 
 * here is that both parallel and sequential executions (or a combination 
 * of both) can be accommodated.
 * 
 * 
 * 
 * The Transformation package assumes the 
 * existence of the following packages that represent types of potential data 
 * sources or targets: ObjectModel (object-oriented), Relational, Record, 
 * Multidimensional, XML, OLAP, and Data Mining. The Transformation package 
 * is an integral part of the following packages: OLAP, Data Mining, Warehouse 
 * Process, and Warehouse Operation. In particular, the Transformation and 
 * Warehouse Process packages together provide metamodel constructs that facilitate 
 * scheduling and execution in data warehousing, and the Transformation and 
 * Warehouse Operation packages together provide metamodel constructs that 
 * enable data lineage in data  warehousing.
 * 
 * 
 * 
 * This section provides a description 
 * of the main features of the Transformation package,
 * 
 * as illustrated in 
 * Figure 13-1 (see specification document for figure).
 * 
 * 
 * 
 * A transformation 
 * transforms a set of source objects into a set of target objects. The elements 
 * of a data object set can be any ObjectModel model elements, but typically 
 * are tables, columns, or model elements that represent transient, in memory, 
 * objects. Data object sets can be both sources and targets for different 
 * transformations. In particular, a given data object set can be the target 
 * of one transformation and the source of one or more transformations within 
 * the same logical unit. This is often the case with transformation that 
 * produce and consume temporary objects. 
 * 
 * 
 * 
 * Transformations allow a wide 
 * range of types (and granularity) to be defined for their data sources and 
 * targets. For example, the source type of a transformation can be an XML 
 * schema while the target type is a column, if the transformation deals with 
 * storing an XML document in a column of a relational database. More typically, 
 * the source types of a transformation are classes and attributes while the 
 * target types are tables and columns, or vice versa, if the transformation 
 * deals with converting object data into relational data, or vice versa.
 * 
 * 
 * 
 * Existing 
 * programs, queries, or rules (in fact, any ObjectModel operations) can be 
 * used to perform a transformation by associating them with the transformation 
 * using the transformation use dependency.
 * 
 * 
 * 
 * Transformations can be grouped 
 * into logical units. At the functional level, they are grouped into transformation 
 * tasks, each of which defines a set of transformations that must be executed 
 * and completed together - a logical unit of work. At the execution level, 
 * transformation steps are used to coordinate the flow of control between 
 * transformation tasks, with each transformation step executing a single 
 * transformation task. The transformation steps are further grouped into 
 * transformation activities.
 * 
 * Within each transformation activity, the execution 
 * sequence of its transformation steps are defined either explicitly by using 
 * the step precedence dependency or precedence constraint, or implicitly 
 * through data dependency.
 * 
 * 
 * 
 * There are certain "white-box" transformations 
 * which are commonly used and which can relate data sources and targets to 
 * a transformation and to each other at a detailed level. These transformations 
 * are convenient to use and they provide data lineage at a fine-grain level. 
 * One such transformation is the transformation map which consists of a set 
 * of classifier maps that in turn consists of a set of feature maps or classifier-feature 
 * maps. The other is the transformation tree, which represents a transformation 
 * as an unary or binary expression tree. For an example usage of the transformation 
 * map, please see Figure 13-4.
 * 
 * 
 * 
 * The Transformation package depends on the 
 * following packages: 
 * 
 * 
 * 
 *     omg.org::CWM::ObjectModel::Behavioral
 * 
 *     
 * omg.org::CWM::ObjectModel::Core
 * 
 *     omg.org::CWM::Foundation::Expressions
 * 
 *  
 *    omg.org::CWM::Foundation::SoftwareDeployment
 * 
 * 
 * 
 * The CWM uses packages 
 * to control complexity and create groupings of logically interrelated classes 
 * and associations. The Transformation package is one such package. Within 
 * the Transformation package itself, however, the definition of subpackages 
 * is purposefully left out to reduce the length and complexity of the fully 
 * qualified names of Transformation classes and associations. There are, 
 * however, several groupings of classes and associations that form related 
 * sets of functionality within the Transformation package. Although separate 
 * subpackages have not been created for these functional areas, their identification 
 * improves the understandability of the Transformation package.
 * 
 * 
 * 
 * The Transformation 
 * package contains metamodel elements that support the following functions:
 * 
 * 
 * 
 * 1. 
 * Transformation and data lineage. These classes and associations deal with 
 * transformations and their sources, targets, constraints, and operations.
 * 
 * 
 * 
 * 2. 
 * Transformation grouping and execution. These classes and associations deal 
 * with grouping of transformations to form logical units and to define execution 
 * sequences.
 * 
 * 
 * 
 * 3. Specialized transformations. These classes and associations 
 * define specialized, "white box", transformations that are commonly used 
 * in data warehousing. The specific Transformation classes and associations 
 * supporting each functional area are delineated in Table 13-1 (see specification 
 * document for table).
 * 
 * 
 * 
 * The metamodel diagram for the Transformation package 
 * is split into four parts. The first two diagrams show the Transformation 
 * classes and associations, while the last two show the inheritance hierarchy.
 * 
 * 
 * 
 * 13.5 
 * OCL Representation of Transformation Constraints
 * 
 * 
 * 
 * [C-1] The preceding 
 * step and succeeding step of StepPrecedence must not be the same.
 * 
 * context 
 * StepPrecedence
 * 
 * inv: self.precedingStep->forAll( p | self.succeedingStep->forAll( 
 * q | p <> q ) )
 * 
 * 
 * 
 * [C-2] A TransformationTask may not be its own inverse 
 * task.
 * 
 * Identifies the Transformation
 * 
 * context TransformationTask
 * 
 * inv: 
 * self.inverseTask->forAll( p | p <> self )
 * 
 * 
 * 
 * [C-3] A TransformationTask 
 * may not be its own original task.
 * 
 * context TransformationTask
 * 
 * inv: self.originalTask->forAll( 
 * p | p <> self )
 * 
 * 
 * 
 * [C-4] The ClassifierMapToCFMap association is derived 
 * from the Namespace-ModelElement association. All ownedElement ends of the 
 * association must be ClassifierFeatureMaps.
 * 
 * context ClassifierMapToCFMap
 * 
 * inv 
 * Namespace-ModelElement.allInstances.select( ownedElement.oclIsKindOf(
 * 
 * ClassifierFeatureMap 
 * ) )
 * 
 * 
 * 
 * [C-5] The ClassifierMapToFeatureMap association is derived from 
 * the Namespace-ModelElement association. All ownedElement ends of the association 
 * must be FeatureMaps.
 * 
 * context ClassifierMapToFeatureMap
 * 
 * inv Namespace-ModelElement.allInstances.select( 
 * ownedElement.oclIsKindOf(
 * 
 * FeatureMap ) )
 */
public interface TransformationPackage extends javax.jmi.reflect.RefPackage  {
// each imported package where:
//   isClustered and
//   Import.visibility == public_vis and
//   importedNamespace.visibility == public_vis
public org.omg.cwm.objectmodel.core.CorePackage getCore();
public org.omg.cwm.foundation.expressions.ExpressionsPackage getExpressions();
public org.omg.cwm.foundation.softwaredeployment.SoftwareDeploymentPackage getSoftwareDeployment();

// each contained package where visibility = public_vis

// each directly contained class with visibility = public_vis
public org.omg.cwm.analysis.transformation.TransformationClass getTransformation();
public org.omg.cwm.analysis.transformation.DataObjectSetClass getDataObjectSet();
public org.omg.cwm.analysis.transformation.TransformationTaskClass getTransformationTask();
public org.omg.cwm.analysis.transformation.TransformationStepClass getTransformationStep();
public org.omg.cwm.analysis.transformation.TransformationActivityClass getTransformationActivity();
public org.omg.cwm.analysis.transformation.PrecedenceConstraintClass getPrecedenceConstraint();
public org.omg.cwm.analysis.transformation.TransformationUseClass getTransformationUse();
public org.omg.cwm.analysis.transformation.TransformationMapClass getTransformationMap();
public org.omg.cwm.analysis.transformation.TransformationTreeClass getTransformationTree();
public org.omg.cwm.analysis.transformation.ClassifierMapClass getClassifierMap();
public org.omg.cwm.analysis.transformation.FeatureMapClass getFeatureMap();
public org.omg.cwm.analysis.transformation.StepPrecedenceClass getStepPrecedence();
public org.omg.cwm.analysis.transformation.ClassifierFeatureMapClass getClassifierFeatureMap();

// each directly contained association with visibility = public_vis
public org.omg.cwm.analysis.transformation.TransformationSource getTransformationSource();
public org.omg.cwm.analysis.transformation.TransformationTarget getTransformationTarget();
public org.omg.cwm.analysis.transformation.TransformationStepTask getTransformationStepTask();
public org.omg.cwm.analysis.transformation.InverseTransformationTask getInverseTransformationTask();
public org.omg.cwm.analysis.transformation.DataObjectSetElement getDataObjectSetElement();
public org.omg.cwm.analysis.transformation.TransformationTaskElement getTransformationTaskElement();
public org.omg.cwm.analysis.transformation.ClassifierMapToFeatureMap getClassifierMapToFeatureMap();
public org.omg.cwm.analysis.transformation.ClassifierMapToCfmap getClassifierMapToCfmap();
public org.omg.cwm.analysis.transformation.ClassifierMapSource getClassifierMapSource();
public org.omg.cwm.analysis.transformation.ClassifierMapTarget getClassifierMapTarget();
public org.omg.cwm.analysis.transformation.FeatureMapTarget getFeatureMapTarget();
public org.omg.cwm.analysis.transformation.FeatureMapSource getFeatureMapSource();
public org.omg.cwm.analysis.transformation.CfmapClassifier getCfmapClassifier();
public org.omg.cwm.analysis.transformation.CfmapFeature getCfmapFeature();

// each directly contained StructType with visibility = public_vis

// each directly contained EnumType with visibility = public_vis
public org.omg.cwm.analysis.transformation.TreeType createTreeType(java.lang.String value) throws javax.jmi.reflect.JmiException;


}
