/**
 * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1
 * GENERATED AT Tuesday, February 15, 2005 12:15:29 AM CET
 **/
package org.omg.cwm.analysis.olap;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;

import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefFeatured;


import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IMMRAssociation;


/**
 * Online Analytical Processing (OLAP) is a class of analytic application software 
 * that exposes business data in a multidimensional format. This multidimensional 
 * format usually includes the consolidation of data drawn from multiple and 
 * diverse information sources. Unlike more traditionally structured representations 
 * (e&#46;g&#46;, the tabular format of a relational database), the multidimensional 
 * orientation is a more natural expression of the way business enterprises 
 * view their strategic data. For example, an analyst might use an OLAP application 
 * to examine total sales revenue by product and geographic region over time, 
 * or, perhaps, compare sales margins for the same fiscal periods of two consecutive 
 * years. The ultimate objective of OLAP is the efficient construction of 
 * analytical models that transform raw business data into strategic business 
 * insight.
 * 
 * 
 * 
 * There are many ways to implement OLAP. Most OLAP systems are 
 * constructed using OLAP server tools that enable logical OLAP structures 
 * to be built on top of a variety of physical database systems, such as relational 
 * or native multidimensional databases.
 * 
 * 
 * 
 * The following features are generally 
 * found in most OLAP systems:
 * 
 * 
 * 
 *     Multidimensional representation of business 
 * data.
 * 
 *     Upward consolidation of multidimensional data in a hierarchical 
 * manner, possibly with the application of specialized processing rules.
 * 
 *  
 *    The ability to navigate a hierarchy from a consolidated value to the 
 * lower level values forming it.
 * 
 *     Support for time-series analysis; i&#46;e&#46;, 
 * OLAP users are generally concerned with data and consolidations at specific 
 * points in time -- By date, week, quarter, etc.
 * 
 *     Support for modeling 
 * and scenario analysis -- A user should be able to apply arbitrary "what-if" 
 * analyses to a result set without affecting the stored information.
 * 
 *    
 *  Consistent response times, regardless of how queries are formulated -- 
 * This is critical for effective analysis and modeling.
 * 
 * 
 * 
 * OLAP applications 
 * integrate well into the data warehousing environment, because a data warehouse 
 * provides relatively clean and stable data stores to drive the OLAP application. 
 * These data stores are usually maintained in relational tables that can 
 * be read directly by OLAP tools or loaded into OLAP servers. These relational 
 * tables are often structured in a manner that reveals the inherent dimensionality 
 * of the data (such as the ubiquitous Star and Snowflake schemas). Also, 
 * the data transformation and mapping services provided by a data warehouse 
 * can be used to supply OLAP systems with both metadata and data. Transformation-related 
 * metadata can be used to track the
 * 
 * lineage of consolidated OLAP data back 
 * to its various sources.
 * 
 * 
 * 
 * The primary objectives of the CWM OLAP package 
 * are:
 * 
 * 
 * 
 *     Define a metamodel of essential OLAP concepts common to most 
 * OLAP systems.
 * 
 *     Provide a facility whereby instances of the OLAP metamodel 
 * are mapped to deployment-capable structures (i&#46;e&#46;, models of physical 
 * data resources, such as the CWM Relational and Multidimensional packages).
 * 
 *  
 *    Ensure that navigation through the logical OLAP model hierarchy and 
 * its various resource models is always performed in a uniform manner (i&#46;e&#46;, 
 * by defining a standard usage of the CWM Transformation package as a means 
 * of implementing these mappings).
 * 
 *     Leverage services provided by other 
 * CWM packages, where appropriate (e&#46;g&#46;, use the CWM Foundation 
 * package to supply a standard representation of expressions).
 * 
 * 
 * 
 * The OLAP 
 * package depends on the following packages:
 * 
 * 
 * 
 *    org.omg::CWM::ObjectModel::Core
 * 
 *  
 *   org.omg::CWM::Foundation::Expressions
 * 
 *    org.omg::CWM::Analysis::Transformation
 * 
 * 
 * 
 * The 
 * major classes and associations of the OLAP metamodel are shown in Figure 
 * 14-1.  Schema is the logical container of all elements comprising an OLAP 
 * model. It is the root element of the model hierarchy and marks the entry 
 * point for navigating OLAP models.
 * 
 * 
 * 
 * A Schema contains Dimensions and Cubes. 
 * A Dimension is an ordinate within a multidimensional structure and consists 
 * of a list of unique values (i&#46;e&#46;, members) that share a common 
 * semantic meaning within the domain being modeled. Each member designates 
 * a unique position along its ordinate.
 * 
 * 
 * 
 * A Cube is a collection of analytic 
 * values (i&#46;e&#46;, measures) that share the same dimensionality. This 
 * dimensionality is specified by a set of unique Dimensions from the Schema. 
 * Each unique combination of members in the Cartesian product of the Cube?s 
 * Dimensions identifies precisely one data cell within a multidimensional 
 * structure.
 * 
 * 
 * 
 * CubeDimensionAssociation relates a Cube to its defining Dimensions. 
 * Features relevant to Cube-Dimension relationships (e&#46;g&#46;, calcHierarchy) 
 * are exposed by this class.
 * 
 * 
 * 
 * A Dimension has zero or more Hierarchies. 
 * A Hierarchy is an organizational structure that describes a traversal pattern 
 * through a Dimension, based on parent/child relationships between members 
 * of a Dimension. Hierarchies are used to define both navigational and consolidation/computational 
 * paths through the Dimension (i&#46;e&#46;, a value associated with a child 
 * member is aggregated by one or more parents). For example, a Time Dimension 
 * with a base periodicity of days might have a Hierarchy
 * 
 * specifying the 
 * consolidation of days into weeks, weeks into months, months into quarters, 
 * and quarters into years.
 * 
 * 
 * 
 * A specific Hierarchy may be designated as the 
 * default Hierarchy for display purposes (e&#46;g&#46;, a user interface 
 * that displays the Dimension as a hierarchical tree of members).  CubeDimensionAssociation 
 * can also identify a particular Hierarchy as the default Hierarchy for consolidation 
 * calculations performed on the Cube.
 * 
 * 
 * 
 * MemberSelection models mechanisms 
 * capable of partitioning a Dimension?s collection of members. For example, 
 * consider a Geography Dimension with members representing cities, states, 
 * and regions. An OLAP client interested specifically in cities might define 
 * an instance of MemberSelection that extracts the city members.
 * 
 * 
 * 
 * CubeRegion 
 * models a sub-unit of a Cube that is of the same dimensionality as the Cube 
 * itself. Each "dimension" of a CubeRegion is represented by a MemberSelection 
 * of the corresponding Dimension  of the Cube. Each MemberSelection may define 
 * some subset of its Dimension?s members.
 * 
 * 
 * 
 * CubeRegions are used to implement 
 * Cubes. A Cube may be realized by a set of CubeRegions that map portions 
 * of the logical Cube to physical data sources. The MemberSelections defining 
 * CubeRegions can also be grouped together via MemberSelectionGroups, enabling 
 * the definition of CubeRegions with specific semantics. For example, one 
 * can specify a CubeRegion containing only the "input level" data cells of 
 * a Cube.
 * 
 * 
 * 
 * A CubeRegion may own any number of CubeDeployments. CubeDeployment 
 * is a metaclass that represents an implementation strategy for a multidimensional 
 * structure. The ordering of the CubeDeployment classes may optionally be 
 * given some implementation-specific meaning (e&#46;g&#46;, desired order 
 * of selection of several possible deployment strategies, based on optimization 
 * considerations).
 * 
 * 
 * 
 * The OLAP metamodel defines two special types of Dimension: 
 * Time and Measure. A Time Dimension provides a means of representing time-series 
 * data within a multidimensional structure. The members of a Time Dimension 
 * usually define some base periodicity (e&#46;g&#46;, days of the week). 
 * The implementation of a Time Dimension might provide support for advanced 
 * "time-intelligent" functionality, such as the ability to automatically 
 * convert between different periodicities and calendars.
 * 
 * 
 * 
 * The members of 
 * a Measure Dimension describe the meaning of the analytic values stored 
 * in each data cell of a multidimensional structure. For example, an OLAP 
 * application may define Sales, Quantity and Weight as its measures. In this 
 * case, each data cell within the Cube stores three values, with each value 
 * corresponding to one of the three measures. A measure may have an associated 
 * data type. For example, Sales might be of a monetary type, Quantity an 
 * integer, and Weight a real number.
 * 
 * 
 * 
 * The OLAP metamodel specifies two 
 * subclasses of Hierarchy: LevelBasedHierarchy and ValueBasedHierarchy.
 * 
 * 
 * 
 * LevelBasedHierarchy 
 * describes hierarchical relationships between specific levels of a Dimension. 
 * LevelBasedHierarchy is used to model both "pure level" hierarchies (e&#46;g&#46;, 
 * dimension-level tables) and "mixed" hierarchies (i&#46;e&#46;, levels 
 * plus linked nodes). Dimensional levels are modeled by the Level class, 
 * a subclass of MemberSelection that partitions a Dimension?s members into 
 * disjoint subsets, each representing a distinct level.
 * 
 * 
 * 
 * For example, the 
 * Geography Dimension cited earlier contains members representing cities, 
 * states, and regions, such as "Stamford", "Connecticut", and "NorthEast". 
 * It might also contain a single member called "USA" representing all regions 
 * of the United States. Therefore, the Geography Dimension could have four 
 * Levels named "City", "State", 'Region", and "ALL", respectively. Each Level 
 * specifies the subset of members belonging to it: All cities belong to the 
 * "City" Level, all states belong to the "State" Level, all regions belong 
 * to the "Region" Level, and the single "USA" member belongs to the "ALL" 
 * Level.
 * 
 * 
 * 
 * When used in the definition of a consolidation path, the meaning 
 * of "level" is quite clear: Members occupying a given Level consolidate 
 * into the next higher Level (e&#46;g&#46;, City rolls up into State, State 
 * into Region, and Region into ALL).
 * 
 * 
 * 
 * LevelBasedHierarchy contains an ordered 
 * collection of HierarchyLevelAssocations that defines the natural hierarchy 
 * of the Dimension. The ordering defines the hierarchical structure in top-down 
 * fashion (i&#46;e&#46;, the "first" HierarchyLevelAssociation in the ordered 
 * collection represents the upper-most level of the dimensional hierarchy).
 * 
 * 
 * 
 * A 
 * HierarchyLevelAssociation may own any number of DimensionDeployments. DimensionDeployment 
 * is a metaclass that represents an implementation strategy for hierarchical 
 * Dimensions. The ordering of the DimensionDeployment classes may optionally 
 * be given an implementation-specific meaning (e&#46;g&#46;, desired order 
 * of selection of several possible deployment strategies, based on optimization
 * 
 * considerations).
 * 
 * 
 * 
 * A 
 * ValueBasedHierarchy defines a hierarchical ordering of members in which 
 * the concept of level has little or no significance. Instead, the topological 
 * structure of the hierarchy conveys meaning. ValueBasedHierarchies are often 
 * used to model situations where members are classified or ranked according 
 * to their distance from a common root member (e&#46;g&#46;, an organizational 
 * chart of a corporation). In this case, each member of the hierarchy has 
 * some specific "metric" or "value" associated it with it. ValueBasedHierarchy 
 * can be used to model pure "linked node" hierarchies (e&#46;g&#46;,
 * 
 * asymmetric 
 * hierarchical graphs or parent-child tables). 
 * 
 * 
 * 
 * As with LevelBasedHierarchy, 
 * ValueBasedHierarchy also has an ordered collection of dimensionDeployments, 
 * where the ordering semantics are left to implementations to define.
 * 
 * 
 * 
 * Figure 
 * 14-3 illustrates how classes of the OLAP metamodel inherit from the CWM
 * 
 * Object 
 * Model. Two classes requiring further explanation are:
 * 
 * 
 * 
 *     Measure: A 
 * subclass of Attribute that describes the meaning of values stored in the 
 * data cells of a multidimensional structure. Different OLAP models often 
 * give different interpretations to the term "measure". In a relational Star 
 * Schema, individual measures might be represented by non-key columns of 
 * a Fact table (e&#46;g&#46;, "Sales" and "Quantity" columns). In this case, 
 * measure may be an attribute of a Cube or CubeRegion that models the Fact 
 * table. On the other hand, measures can
 * 
 * also be represented by members 
 * of a Measure Dimension. A Fact table supporting this representation has 
 * a single Measure column with column values consisting of the members "Sales" 
 * and "Quantity", and a single "value" column (i&#46;e&#46;, an implicit 
 * data dimension) storing the corresponding measure values. A similar notion 
 * of Measure Dimension is used in modeling pure hypercube representations 
 * of
 * 
 * multidimensional servers. Thus, the concept of measure can be represented 
 * either as a Dimenson or as an Attribute, depending on the type of OLAP 
 * system being modeled.
 * 
 * 
 * 
 *     Coded Level: A subclass of Level that assigns 
 * a unique encoding, or label, to each of its members. CodedLevel is not 
 * essential to the OLAP metamodel, but is provided as a helper class for 
 * certain applications that might benefit from the ability of OLAP systems 
 * to structure data hierarchically. For example, CodedLevel could be used 
 * to model systems of nomenclature or classification.
 * 
 * 
 * 
 * The CWM OLAP metamodel 
 * describes logical models of OLAP systems, but does not directly specify 
 * how an OLAP system is physically deployed. Modeling the deployment of an 
 * OLAP system requires mapping instances of OLAP metaclasses to instances 
 * of other CWM metaclasses representing physical resources (e&#46;g&#46;, 
 * mapping an OLAP Dimension to a Relational Table). This approach offers 
 * several advantages:
 * 
 * 
 * 
 *     The status of the OLAP metamodel as a conceptual 
 * model is preserved by this level of indirection. When using OLAP, a client 
 * may perceive to be working directly with OLAP objects, but the actual implementation 
 * of those objects is hidden from the client. For example, a client may view 
 * a member as a value of a Dimension, but whether that member value comes 
 * from a row of a relational table, or from a cell in a multidimensional 
 * database, is usually not obvious to the client. On the other hand, if a 
 * client needs to determine how a logical OLAP structure is physically realized, 
 * the metadata describing this mapping is fully available (assuming that 
 * the implementation allows the client to drill-down through the metadata).
 * 
 * 
 * 
 *  
 *    The possibility of defining mappings based on expressions means that 
 * the amount of metadata required to describe large models (e&#46;g&#46;, 
 * Dimensions containing large collections of members) can be kept within 
 * reasonable bounds. It is generally more efficient to provide expressions 
 * that specify where large metadata sets reside, how to connect to them, 
 * and how to map their contents, rather than representing them directly as 
 * part of the metadata content.
 * 
 * 
 * 
 * All of the OLAP metaclasses are potential 
 * candidates for such deployment mappings. In addition, some OLAP models 
 * may also define mappings between several OLAP metaclass instances, forming 
 * a natural hierarchy of logical objects (e&#46;g&#46;, Dimension Attributes 
 * are mapped to Level Attributes which, in turn, are mapped to Table Columns).
 * 
 * 
 * 
 * The 
 * CWM Transformation package is used as the primary means of describing these 
 * mappings. A modeler constructing an OLAP model based on CWM will generally 
 * define instances of the TransformationMap metaclass to link logical OLAP 
 * objects together, and to link those logical objects to other objects representing 
 * their physical data sources.
 * 
 * 
 * 
 * StructureMap is a subclass of TransformationMap 
 * that models structure-oriented transformation mappings (i&#46;e&#46;, 
 * member identity and hierarchical structure). This type of transformation 
 * mapping needs to be connected to the OLAP metamodel in a very specific 
 * way (according to Level and Hierarchy), so the StructureMap subclass is 
 * defined to make these associations explicit. Two specific usages of StructureMap 
 * are defined: ListOfValues, which maps attributes identifying members residing 
 * at a specific Level, or at a specific Level within a particular Hierarchy, 
 * and ImmediateParent, which maps attributes identifying the hierarchical 
 * parent(s) of the members.
 * 
 * 
 * 
 * On the other hand, relatively simple TransformationMaps 
 * can be defined within any OLAP model to represent attribute-oriented transformations 
 * (e&#46;g&#46;, mapping Dimension Attributes to Table Columns that store 
 * attribute values).
 * 
 * 
 * 
 * ContentMap is a subclass of TransformationMap that 
 * models content-oriented transformaton mappings (i&#46;e&#46;, cell data 
 * or measure values). For example, an instance of ContentMap might be used 
 * to map each of a CubeRegion?s Measures to Columns of an underlying Fact 
 * Table.
 * 
 * 
 * 
 * Note that, in either case (structural mapping or content mapping), 
 * the traversal patterns used by any CWM OLAP implementation are always the 
 * same, since both deployment mappings are based on the same usage of CWM 
 * TransformationMaps. In addition to representing structural mappings, instances 
 * of TransformationMap and its subclasses are also capable of storing implementation-dependent 
 * functions or procedures that yield the instance values associated with 
 * mapped model elements. For example, a "list of values" StructureMap might 
 * store an SQL statement such as "select memberName from Product where productFamily 
 * = ?consumerElectronics? ", as the value of its formula attribute.
 * 
 * 
 * 
 * Figure 
 * 14-4 illustrates the CWM metaclasses and associations that describe deployment 
 * mappings between logical OLAP models and physical resource models. Note 
 * that it is possible to combine both Cube (content) and Dimension (structure) 
 * deployments together within the context of a single OLAP Schema (via the 
 * DeploymentGroup metaclass). Thus, an OLAP Schema can have several possible 
 * deployments that users may select based on implementation-specific considerations 
 * (e&#46;g&#46;, physical optimizations).
 * 
 * 
 * 
 * OCL Representation of OLAP 
 * Constraints
 * 
 * 
 * 
 * [C-1] Ensure that the Dimensions defining a Cube are unique.
 * 
 * context 
 * Cube inv:
 * 
 * self.cubeDimensionAssociation->forAll( c1, c2 | c1 <> c2 implies
 * 
 * c1.dimension 
 * <> c2.dimension )
 * 
 * 
 * 
 * [C-2] A Cube without CubeRegions cannot be mapped 
 * to a deployment structure (i&#46;e&#46;, physical source of data).
 * 
 * context 
 * Cube inv:
 * 
 * self.cubeRegion->isEmpty implies self.isVirtual = true
 * 
 * 
 * 
 * [C-3] 
 * If a calcHierarchy is defined, it must be a Hierarchy owned by the Dimension 
 * referenced by the CubeDimensionAssociation.
 * 
 * context CubeDimensionAssociation 
 * inv:
 * 
 * self.calcHierarchy->notEmpty implies self.calcHierarchy.dimension 
 * = self.dimension
 * 
 * 
 * 
 * [C-4] A "fully realized" CubeRegion has no MemberSelectionGroups 
 * (and hence, no MemberSelections).
 * 
 * context CubeRegion inv:
 * 
 * self.isFullyRealized 
 * implies self.memberSelectionGroup->isEmpty
 * 
 * 
 * 
 * [C-5] A CubeRegion defined 
 * by MemberSelections must have, for each Dimension of its owning Cube, a 
 * corresponding MemberSelection within each of its
 * 
 * MemberSelectionGroups.
 * 
 * context 
 * CubeRegion inv:
 * 
 * self.memberSelectionGroup->notEmpty implies
 * 
 * self.cube.cubeDimensionAssociation->forAll( 
 * d |
 * 
 * self.memberSelectionGroup->forAll( g |
 * 
 * g.memberSelection->exists( 
 * m | m.dimension = d.dimension ) ) )
 * 
 * 
 * 
 * [C-6] A CubeRegion defined by MemberSelections 
 * must have, within each MemberSelectionGroup, a MemberSelection corresponding 
 * to each Dimension of its
 * 
 * owning Cube.
 * 
 * context CubeRegion inv:
 * 
 * self.memberSelectionGroup->notEmpty 
 * implies
 * 
 * self.memberSelectionGroup->forAll( g |
 * 
 * g.memberSelection->forAll( 
 * m |
 * 
 * self.cube.cubeDimensionAssociation->exists( d | d.dimension = m.dimension 
 * ) ) )
 * 
 * 
 * 
 * [C-7] A Dimension may be a Time Dimension, a Measure Dimension, 
 * or neither, but never both types at the same time.
 * 
 * context Dimension inv:
 * 
 * not 
 * ( self.isTime and self.isMeasure )
 * 
 * 
 * 
 * [C-8] The default display Hierarchy 
 * (if defined) must be one of the Hierarchies owned by the Dimension.
 * 
 * context 
 * Dimension inv:
 * 
 * self.displayDefault->notEmpty implies self.hierarchy->includes( 
 * self.displayDefault )
 * 
 * 
 * 
 * [C-9] An instance of DimensionDeployment must 
 * be referenced exclusively by either a HierarchyLevelAssociation or a ValueBasedHierarchy.
 * 
 * context 
 * DimensionDeployment inv:
 * 
 * self.hierarchyLevelAssociation->isEmpty xor self.valueBasedHierarchy->isEmpty
 * 
 * 
 * 
 * [C-10] 
 * Within a DimensionDeployment, an "immediate parent" StructureMap must always 
 * have an associated and distinct "list of values" StructureMap.
 * 
 * context 
 * DimensionDeployment inv:
 * 
 * self.immediateParent->notEmpty implies
 * 
 * ( self.listOfValues->notEmpty 
 * and self.listOfValues <> self.immediateParent )
 * 
 * 
 * 
 * [C-11] A StructureMap 
 * referenced as a "list of values" StructureMap must not reside outside of 
 * the DimensionDeployment?s collection of StructureMaps.
 * 
 * context DimensionDeployment 
 * inv:
 * 
 * self.listOfValues->notEmpty implies self.structureMap->includes( 
 * self.listOfValues )
 * 
 * 
 * 
 * [C-12] A StructureMap referenced as an "immediate 
 * parent" StructureMap must not reside outside of the DimensionDeployment?s 
 * collection of StructureMaps.
 * 
 * context DimensionDeployment inv:
 * 
 * self.immediateParent->notEmpty 
 * implies
 * 
 * self.structureMap->includes( self.immediateParent )
 * 
 * 
 * 
 * [C-13] 
 * The currentLevel of each HierarchyLevelAssociation must refer to a Level 
 * owned by the Dimension of the LevelBasedHierarchy containing the HierarchyLevelAssociation.
 * 
 * context 
 * LevelBasedHierarchy inv:
 * 
 * self.hierarchyLevelAssociation->notEmpty implies
 * 
 * self.hierarchyLevelAssociation->forAll( 
 * h |
 * 
 * self.dimension.memberSelection
 * 
 * ->select( oclType = Olap::Level )->includes( 
 * h.currentLevel ) )
 * 
 * 
 * 
 * [C-14] No two HierarchyLevelAssociations may designate 
 * the same Level instance as their "current level".
 * 
 * context LevelBasedHierarchy 
 * inv:
 * 
 * self.hierarchyLevelAssociation->forAll( h1, h2 | h1 <> h2 implies
 * 
 * h1.currentLevel 
 * <> h2.currentLevel )
 */
public class OlapPackageImpl implements com.sap.ip.mmr.m1layer.IMMRObject, org.omg.cwm.analysis.olap.OlapPackage {

// Java serialized version UID
static final long serialVersionUID = 1530317050L;



	protected static final com.sap.tc.logging.Location ___location = com.sap.ip.mmr.foundation.Utilities.getUtilities().getLocation(javax.jmi.reflect.RefBaseObject.class);

// variables
protected java.lang.String ___mofId;
	
transient protected com.sap.ip.mmr.StateEnum ___state = com.sap.ip.mmr.StateEnum.STATE_NEW;
final protected java.lang.String ___generatorVersion = "1.1.1";
transient protected com.sap.ip.mmr.IRepository ___repository;
transient protected javax.jmi.reflect.RefObject ___metaObject;
transient protected javax.jmi.reflect.RefFeatured ___composite = null;

transient protected com.sap.ip.mmr.m1layer.IMMRObject ___instantiator;

protected java.lang.String ___createdAt;
protected java.lang.String ___createdBy;
protected java.lang.String ___lastChangedAt;
protected java.lang.String ___lastChangedBy;
protected java.lang.String ___release;
protected int ___deprecated;


protected java.lang.String ___qualifiedName;
protected java.lang.String ___qualifiedNameImmediatePackage;
transient protected javax.jmi.reflect.RefPackage ___immediatePackage = null;


// constructors
public OlapPackageImpl() {
}
public OlapPackageImpl(IRepository repository) {
  ___repository = repository;
  ___mofId = com.sap.ip.mmr.Repository.createMofId();
}



// each imported package where:
//   isClustered and
//   Import.visibility == public_vis and
//   importedNamespace.visibility == public_vis
public org.omg.cwm.objectmodel.core.CorePackage getCore() { return (org.omg.cwm.objectmodel.core.CorePackage) refPackage("Core"); } 
public org.omg.cwm.foundation.expressions.ExpressionsPackage getExpressions() { return (org.omg.cwm.foundation.expressions.ExpressionsPackage) refPackage("Expressions"); } 
public org.omg.cwm.analysis.transformation.TransformationPackage getTransformation() { return (org.omg.cwm.analysis.transformation.TransformationPackage) refPackage("Transformation"); } 

// each contained package where visibility = public_vis

// each directly contained class with visibility = public_vis
public org.omg.cwm.analysis.olap.ContentMapClass getContentMap() { return (org.omg.cwm.analysis.olap.ContentMapClass) refClass("ContentMap"); } 
public org.omg.cwm.analysis.olap.CubeClass getCube() { return (org.omg.cwm.analysis.olap.CubeClass) refClass("Cube"); } 
public org.omg.cwm.analysis.olap.CubeDeploymentClass getCubeDeployment() { return (org.omg.cwm.analysis.olap.CubeDeploymentClass) refClass("CubeDeployment"); } 
public org.omg.cwm.analysis.olap.CubeDimensionAssociationClass getCubeDimensionAssociation() { return (org.omg.cwm.analysis.olap.CubeDimensionAssociationClass) refClass("CubeDimensionAssociation"); } 
public org.omg.cwm.analysis.olap.CubeRegionClass getCubeRegion() { return (org.omg.cwm.analysis.olap.CubeRegionClass) refClass("CubeRegion"); } 
public org.omg.cwm.analysis.olap.DeploymentGroupClass getDeploymentGroup() { return (org.omg.cwm.analysis.olap.DeploymentGroupClass) refClass("DeploymentGroup"); } 
public org.omg.cwm.analysis.olap.DimensionClass getDimension() { return (org.omg.cwm.analysis.olap.DimensionClass) refClass("Dimension"); } 
public org.omg.cwm.analysis.olap.DimensionDeploymentClass getDimensionDeployment() { return (org.omg.cwm.analysis.olap.DimensionDeploymentClass) refClass("DimensionDeployment"); } 
public org.omg.cwm.analysis.olap.HierarchyClass getHierarchy() { return (org.omg.cwm.analysis.olap.HierarchyClass) refClass("Hierarchy"); } 
public org.omg.cwm.analysis.olap.HierarchyLevelAssociationClass getHierarchyLevelAssociation() { return (org.omg.cwm.analysis.olap.HierarchyLevelAssociationClass) refClass("HierarchyLevelAssociation"); } 
public org.omg.cwm.analysis.olap.LevelBasedHierarchyClass getLevelBasedHierarchy() { return (org.omg.cwm.analysis.olap.LevelBasedHierarchyClass) refClass("LevelBasedHierarchy"); } 
public org.omg.cwm.analysis.olap.MemberSelectionGroupClass getMemberSelectionGroup() { return (org.omg.cwm.analysis.olap.MemberSelectionGroupClass) refClass("MemberSelectionGroup"); } 
public org.omg.cwm.analysis.olap.MemberSelectionClass getMemberSelection() { return (org.omg.cwm.analysis.olap.MemberSelectionClass) refClass("MemberSelection"); } 
public org.omg.cwm.analysis.olap.SchemaClass getSchema() { return (org.omg.cwm.analysis.olap.SchemaClass) refClass("Schema"); } 
public org.omg.cwm.analysis.olap.ValueBasedHierarchyClass getValueBasedHierarchy() { return (org.omg.cwm.analysis.olap.ValueBasedHierarchyClass) refClass("ValueBasedHierarchy"); } 
public org.omg.cwm.analysis.olap.LevelClass getLevel() { return (org.omg.cwm.analysis.olap.LevelClass) refClass("Level"); } 
public org.omg.cwm.analysis.olap.CodedLevelClass getCodedLevel() { return (org.omg.cwm.analysis.olap.CodedLevelClass) refClass("CodedLevel"); } 
public org.omg.cwm.analysis.olap.MeasureClass getMeasure() { return (org.omg.cwm.analysis.olap.MeasureClass) refClass("Measure"); } 
public org.omg.cwm.analysis.olap.StructureMapClass getStructureMap() { return (org.omg.cwm.analysis.olap.StructureMapClass) refClass("StructureMap"); } 

// each directly contained association with visibility = public_vis
public org.omg.cwm.analysis.olap.LevelBasedHierarchyOwnsHierarchyLevelAssociations getLevelBasedHierarchyOwnsHierarchyLevelAssociations() { return (org.omg.cwm.analysis.olap.LevelBasedHierarchyOwnsHierarchyLevelAssociations) refAssociation("LevelBasedHierarchyOwnsHierarchyLevelAssociations"); } 
public org.omg.cwm.analysis.olap.HierarchyLevelAssocsReferenceLevel getHierarchyLevelAssocsReferenceLevel() { return (org.omg.cwm.analysis.olap.HierarchyLevelAssocsReferenceLevel) refAssociation("HierarchyLevelAssocsReferenceLevel"); } 
public org.omg.cwm.analysis.olap.DimensionOwnsMemberSelections getDimensionOwnsMemberSelections() { return (org.omg.cwm.analysis.olap.DimensionOwnsMemberSelections) refAssociation("DimensionOwnsMemberSelections"); } 
public org.omg.cwm.analysis.olap.CubeOwnsCubeDimensionAssociations getCubeOwnsCubeDimensionAssociations() { return (org.omg.cwm.analysis.olap.CubeOwnsCubeDimensionAssociations) refAssociation("CubeOwnsCubeDimensionAssociations"); } 
public org.omg.cwm.analysis.olap.CubeDimensionAssociationsReferenceDimension getCubeDimensionAssociationsReferenceDimension() { return (org.omg.cwm.analysis.olap.CubeDimensionAssociationsReferenceDimension) refAssociation("CubeDimensionAssociationsReferenceDimension"); } 
public org.omg.cwm.analysis.olap.DimensionOwnsHierarchies getDimensionOwnsHierarchies() { return (org.omg.cwm.analysis.olap.DimensionOwnsHierarchies) refAssociation("DimensionOwnsHierarchies"); } 
public org.omg.cwm.analysis.olap.DimensionHasDefaultHierarchy getDimensionHasDefaultHierarchy() { return (org.omg.cwm.analysis.olap.DimensionHasDefaultHierarchy) refAssociation("DimensionHasDefaultHierarchy"); } 
public org.omg.cwm.analysis.olap.CubeDimensionAssociationsReferenceCalcHierarchy getCubeDimensionAssociationsReferenceCalcHierarchy() { return (org.omg.cwm.analysis.olap.CubeDimensionAssociationsReferenceCalcHierarchy) refAssociation("CubeDimensionAssociationsReferenceCalcHierarchy"); } 
public org.omg.cwm.analysis.olap.MemberSelectionGroupReferencesMemberSelections getMemberSelectionGroupReferencesMemberSelections() { return (org.omg.cwm.analysis.olap.MemberSelectionGroupReferencesMemberSelections) refAssociation("MemberSelectionGroupReferencesMemberSelections"); } 
public org.omg.cwm.analysis.olap.SchemaOwnsCubes getSchemaOwnsCubes() { return (org.omg.cwm.analysis.olap.SchemaOwnsCubes) refAssociation("SchemaOwnsCubes"); } 
public org.omg.cwm.analysis.olap.SchemaOwnsDimensions getSchemaOwnsDimensions() { return (org.omg.cwm.analysis.olap.SchemaOwnsDimensions) refAssociation("SchemaOwnsDimensions"); } 
public org.omg.cwm.analysis.olap.HierarchyLevelAssociationOwnsDimensionDeployments getHierarchyLevelAssociationOwnsDimensionDeployments() { return (org.omg.cwm.analysis.olap.HierarchyLevelAssociationOwnsDimensionDeployments) refAssociation("HierarchyLevelAssociationOwnsDimensionDeployments"); } 
public org.omg.cwm.analysis.olap.ValueBasedHierarchyOwnsDimensionDeployments getValueBasedHierarchyOwnsDimensionDeployments() { return (org.omg.cwm.analysis.olap.ValueBasedHierarchyOwnsDimensionDeployments) refAssociation("ValueBasedHierarchyOwnsDimensionDeployments"); } 
public org.omg.cwm.analysis.olap.DimensionDeploymentOwnsStructureMaps getDimensionDeploymentOwnsStructureMaps() { return (org.omg.cwm.analysis.olap.DimensionDeploymentOwnsStructureMaps) refAssociation("DimensionDeploymentOwnsStructureMaps"); } 
public org.omg.cwm.analysis.olap.DimensionDeploymentHasListOfValues getDimensionDeploymentHasListOfValues() { return (org.omg.cwm.analysis.olap.DimensionDeploymentHasListOfValues) refAssociation("DimensionDeploymentHasListOfValues"); } 
public org.omg.cwm.analysis.olap.DimensionDeploymentHasImmediateParent getDimensionDeploymentHasImmediateParent() { return (org.omg.cwm.analysis.olap.DimensionDeploymentHasImmediateParent) refAssociation("DimensionDeploymentHasImmediateParent"); } 
public org.omg.cwm.analysis.olap.CubeOwnsCubeRegions getCubeOwnsCubeRegions() { return (org.omg.cwm.analysis.olap.CubeOwnsCubeRegions) refAssociation("CubeOwnsCubeRegions"); } 
public org.omg.cwm.analysis.olap.CubeRegionOwnsMemberSelectionGroups getCubeRegionOwnsMemberSelectionGroups() { return (org.omg.cwm.analysis.olap.CubeRegionOwnsMemberSelectionGroups) refAssociation("CubeRegionOwnsMemberSelectionGroups"); } 
public org.omg.cwm.analysis.olap.CubeRegionOwnsCubeDeployments getCubeRegionOwnsCubeDeployments() { return (org.omg.cwm.analysis.olap.CubeRegionOwnsCubeDeployments) refAssociation("CubeRegionOwnsCubeDeployments"); } 
public org.omg.cwm.analysis.olap.SchemaOwnsDeploymentGroups getSchemaOwnsDeploymentGroups() { return (org.omg.cwm.analysis.olap.SchemaOwnsDeploymentGroups) refAssociation("SchemaOwnsDeploymentGroups"); } 
public org.omg.cwm.analysis.olap.DeploymentGroupReferencesCubeDeployments getDeploymentGroupReferencesCubeDeployments() { return (org.omg.cwm.analysis.olap.DeploymentGroupReferencesCubeDeployments) refAssociation("DeploymentGroupReferencesCubeDeployments"); } 
public org.omg.cwm.analysis.olap.DeploymentGroupReferencesDimensionDeployments getDeploymentGroupReferencesDimensionDeployments() { return (org.omg.cwm.analysis.olap.DeploymentGroupReferencesDimensionDeployments) refAssociation("DeploymentGroupReferencesDimensionDeployments"); } 
public org.omg.cwm.analysis.olap.CubeDeploymentOwnsContentMaps getCubeDeploymentOwnsContentMaps() { return (org.omg.cwm.analysis.olap.CubeDeploymentOwnsContentMaps) refAssociation("CubeDeploymentOwnsContentMaps"); } 

// each directly contained StructType with visibility = public_vis

// each directly contained EnumType with visibility = public_vis

// return main object properties as String
public String toString() {
  	return ___qualifiedName + "::" + ___mofId + " (" + super.toString() + ") ";

}

// Meta object
public javax.jmi.reflect.RefObject refMetaObject() {
    return ___repository.selectM2ByName("org.omg.cwm.analysis.Olap", false);

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refImmediatePackage()
 */
public javax.jmi.reflect.RefPackage refImmediatePackage() {
  		if (___immediatePackage != null) {
  			if (com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT.equals(((IMMRObject) ___immediatePackage).get___QualifiedName())) {
  				return null;
  			}
  	    } else {
  		  if (___qualifiedNameImmediatePackage != null && ___qualifiedNameImmediatePackage.compareTo(com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT) != 0) {
  		 	// set the package
  			___immediatePackage = ___repository.getTopLevelPackageM1().refPackage(___qualifiedNameImmediatePackage);
  		  }
  	    }
  	    return ___immediatePackage;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refOutermostPackage()
 */
public javax.jmi.reflect.RefPackage refOutermostPackage() {
  		javax.jmi.reflect.RefPackage rp = refImmediatePackage();
  		if (rp == null) {
  			return (javax.jmi.reflect.RefPackage) this;
  		} else {
  			if (com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT.equals(((IMMRObject) rp).get___QualifiedName())) {
  				return (javax.jmi.reflect.RefPackage) this;
  			}
  		}
  		if (rp != null && !(rp.equals(this))) {
  			javax.jmi.reflect.RefPackage rp_ = rp.refOutermostPackage();
  			if (rp_ != null) {
  				rp = rp_;
  			}
  		}
  		return rp;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refMofId()
 */
public String refMofId() {
  	return ___mofId;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refVerifyConstraints(boolean)
 */
public Collection refVerifyConstraints(boolean deepVerify) {
  		com.sap.ip.mmr.m1layer.Verifyer v = com.sap.ip.mmr.m1layer.Verifyer.createVerifyer();
  		return v.refVerifyConstraints(this,deepVerify);

}

/**
 * @see com.sap.ip.mmr.m1layer.IMMRObject#get___Repository()
 */
public IRepository get___Repository() {
  	return ___repository;

}

/**
 * @see com.sap.ip.mmr.m1layer.IMMRObject#set___Repository(IRepository)
 */
public void set___Repository(IRepository repository) {
  	___repository = repository;

}

// equality of two (IMMRObject) objects 
public boolean equals(java.lang.Object other) {
      java.lang.String otherMofId = null;
  	if (other instanceof javax.jmi.reflect.RefBaseObject) {
          otherMofId = ((javax.jmi.reflect.RefBaseObject)other).refMofId();
  	} else if (other instanceof java.lang.String) {
          otherMofId = (java.lang.String)other;
      }
      return ___mofId.equals(otherMofId);

}

// computes the hasCode of this object
public int hashCode() {
  	return ___mofId.hashCode();

}

// Was this object changed?
public boolean is___Changed() {
  	return ___state == com.sap.ip.mmr.StateEnum.STATE_CHANGED;

}

// Is the instance new or from persistence layer?
public boolean is___New() {
  	return ___state == com.sap.ip.mmr.StateEnum.STATE_NEW;

}

/*
 * @see com.sap.ip.mmr.m1layer.IMMRObject#get___State()
*/
public com.sap.ip.mmr.StateEnum get___State() {
  	return ___state;

}

/*
 * @see com.sap.ip.mmr.m1layer.IMMRObject#set___State()
*/
public void set___State(com.sap.ip.mmr.StateEnum state) {
  	___state = com.sap.ip.mmr.StateEnum.changeState(___state,state);

}

public java.lang.String get___GeneratorVersion() {
  	return ___generatorVersion;

}

public void set___CreatedAt(String createdAt) {
  	this.___createdAt = createdAt;

}

public java.lang.String get___CreatedAt() {
  	return ___createdAt;

}

public void set___CreatedBy(String createdBy) {
  	this.___createdBy = createdBy;

}

public java.lang.String get___CreatedBy() {
  	return ___createdBy;

}

public void set___LastChangedAt(String lastChangedAt) {
  	this.___lastChangedAt = lastChangedAt;

}

public java.lang.String get___LastChangedAt() {
  	return ___lastChangedAt;

}

public void set___LastChangedBy(String lastChangedBy) {
  	this.___lastChangedBy = lastChangedBy;

}

public java.lang.String get___LastChangedBy() {
  	return ___lastChangedBy;

}

public void set___Release(String release) {
  	this.___release = release;

}

public java.lang.String get___Release() {
  	return ___release;

}

public void set___Deprecated(int deprecated) {
  	this.___deprecated = deprecated;

}

public int get___Deprecated() {
  	return ___deprecated;

}

public void set___ImmediateComposite(javax.jmi.reflect.RefFeatured feature) {
  	___composite = feature;

}

// copy the attributes of another instance to this instance
public void ___copy(com.sap.ip.mmr.m1layer.IMMRObject o) {
  this.___mofId = o.get___MofId();
  this.___repository = o.get___Repository();
  this.___qualifiedName = o.get___QualifiedName();
  this.___qualifiedNameImmediatePackage = o.get___QualifiedNameImmediatePackage();
  this.___immediatePackage = o.get___ImmediatePackage();
  this.___composite = null;
  this.___createdAt = o.get___CreatedAt();
  this.___createdBy = o.get___CreatedBy();
  this.___lastChangedAt = o.get___LastChangedAt();
  this.___lastChangedBy = o.get___LastChangedBy();
  this.___release = o.get___Release();
  this.___deprecated = o.get___Deprecated();

}

// returns the MOF Id
public String get___MofId() {
  return ___mofId;

}

// set the MOF Id !!! TO BE USED BY MMR ONLY !!!
public void set___MofId(String mofId) {
  this.___mofId = mofId;

}

// returns the qualified name of this class
public java.lang.String get___QualifiedName() {
  return ___qualifiedName;

}

// returns the qualified name of the immediate package of this class
public java.lang.String get___QualifiedNameImmediatePackage() {
  return ___qualifiedNameImmediatePackage;

}

// returns the immediate package
public javax.jmi.reflect.RefPackage get___ImmediatePackage() {
  return ___immediatePackage;

}

// set the qualified name of this class
public void set___QualifiedName(String qualifiedName) {
  ___qualifiedName = qualifiedName;

}

// set the qualified name of the immediate package this class
public void set___QualifiedNameImmediatePackage(String qualifiedNameImmediatePackage) {
  ___qualifiedNameImmediatePackage = qualifiedNameImmediatePackage;

}

// set the immediate package
public void set___ImmediatePackage(javax.jmi.reflect.RefPackage immediatePackage) {
  		if (immediatePackage != null
  			&& ((com.sap.ip.mmr.m1layer.IMMRObject) immediatePackage).get___QualifiedName().equals(
  				com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT)) {
  			___immediatePackage = null;
  		} else {
  			___immediatePackage = immediatePackage;
  		}

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public List get___ListOfInstantiators() {
  		ArrayList list = new ArrayList(1);
  		IMMRObject parent = get___Instantiator();
  		while (parent != null) {
  			if (list.size() == 0) {
  				list.add(parent);
  			} else {
  				list.add(0, parent);
  			}
  			parent = parent.get___Instantiator();
  		}
  		return list;

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public IMMRObject get___Instantiator() {
  return ___instantiator;

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public void set___Instantiator(IMMRObject instantiator) {
  ___instantiator = instantiator;

}

/**
* @see com.sap.ip.mmr.m1layer.IMMRObject#throwsConstraintViolations()
*/
public boolean throwsConstraintViolations() {
  return true;

}

/**
 * @see javax.jmi.reflect.RefPackage#refGetEnum(String, String)
 */
public RefEnum refGetEnum(String enumName, String name) {
     RefEnum re = null;
     return re;

}

/**
 * Initialize the refPackage, refClass and refAssociation information
 */
private void initialize() {
    if (___refPackages == null) {
    	___refPackages = new java.util.LinkedList();
  	___refPackages.add(new RefPackageAndName("Core","org.omg.cwm.objectmodel.Core",true,null));
  	___refPackages.add(new RefPackageAndName("Expressions","org.omg.cwm.foundation.Expressions",true,null));
  	___refPackages.add(new RefPackageAndName("Transformation","org.omg.cwm.analysis.Transformation",true,null));
    }
    if (___refClasses == null) {
    	___refClasses = new java.util.LinkedList();
  	___refClasses.add(new RefClassAndName("ContentMap","org.omg.cwm.analysis.Olap.ContentMap",null));
  	___refClasses.add(new RefClassAndName("Cube","org.omg.cwm.analysis.Olap.Cube",null));
  	___refClasses.add(new RefClassAndName("CubeDeployment","org.omg.cwm.analysis.Olap.CubeDeployment",null));
  	___refClasses.add(new RefClassAndName("CubeDimensionAssociation","org.omg.cwm.analysis.Olap.CubeDimensionAssociation",null));
  	___refClasses.add(new RefClassAndName("CubeRegion","org.omg.cwm.analysis.Olap.CubeRegion",null));
  	___refClasses.add(new RefClassAndName("DeploymentGroup","org.omg.cwm.analysis.Olap.DeploymentGroup",null));
  	___refClasses.add(new RefClassAndName("Dimension","org.omg.cwm.analysis.Olap.Dimension",null));
  	___refClasses.add(new RefClassAndName("DimensionDeployment","org.omg.cwm.analysis.Olap.DimensionDeployment",null));
  	___refClasses.add(new RefClassAndName("Hierarchy","org.omg.cwm.analysis.Olap.Hierarchy",null));
  	___refClasses.add(new RefClassAndName("HierarchyLevelAssociation","org.omg.cwm.analysis.Olap.HierarchyLevelAssociation",null));
  	___refClasses.add(new RefClassAndName("LevelBasedHierarchy","org.omg.cwm.analysis.Olap.LevelBasedHierarchy",null));
  	___refClasses.add(new RefClassAndName("MemberSelectionGroup","org.omg.cwm.analysis.Olap.MemberSelectionGroup",null));
  	___refClasses.add(new RefClassAndName("MemberSelection","org.omg.cwm.analysis.Olap.MemberSelection",null));
  	___refClasses.add(new RefClassAndName("Schema","org.omg.cwm.analysis.Olap.Schema",null));
  	___refClasses.add(new RefClassAndName("ValueBasedHierarchy","org.omg.cwm.analysis.Olap.ValueBasedHierarchy",null));
  	___refClasses.add(new RefClassAndName("Level","org.omg.cwm.analysis.Olap.Level",null));
  	___refClasses.add(new RefClassAndName("CodedLevel","org.omg.cwm.analysis.Olap.CodedLevel",null));
  	___refClasses.add(new RefClassAndName("Measure","org.omg.cwm.analysis.Olap.Measure",null));
  	___refClasses.add(new RefClassAndName("StructureMap","org.omg.cwm.analysis.Olap.StructureMap",null));
    }
    if (___refAssociations == null) {
    	___refAssociations = new java.util.LinkedList();
  	___refAssociations.add(new RefAssociationAndName("LevelBasedHierarchyOwnsHierarchyLevelAssociations","org.omg.cwm.analysis.Olap.LevelBasedHierarchyOwnsHierarchyLevelAssociations",null));
  	___refAssociations.add(new RefAssociationAndName("HierarchyLevelAssocsReferenceLevel","org.omg.cwm.analysis.Olap.HierarchyLevelAssocsReferenceLevel",null));
  	___refAssociations.add(new RefAssociationAndName("DimensionOwnsMemberSelections","org.omg.cwm.analysis.Olap.DimensionOwnsMemberSelections",null));
  	___refAssociations.add(new RefAssociationAndName("CubeOwnsCubeDimensionAssociations","org.omg.cwm.analysis.Olap.CubeOwnsCubeDimensionAssociations",null));
  	___refAssociations.add(new RefAssociationAndName("CubeDimensionAssociationsReferenceDimension","org.omg.cwm.analysis.Olap.CubeDimensionAssociationsReferenceDimension",null));
  	___refAssociations.add(new RefAssociationAndName("DimensionOwnsHierarchies","org.omg.cwm.analysis.Olap.DimensionOwnsHierarchies",null));
  	___refAssociations.add(new RefAssociationAndName("DimensionHasDefaultHierarchy","org.omg.cwm.analysis.Olap.DimensionHasDefaultHierarchy",null));
  	___refAssociations.add(new RefAssociationAndName("CubeDimensionAssociationsReferenceCalcHierarchy","org.omg.cwm.analysis.Olap.CubeDimensionAssociationsReferenceCalcHierarchy",null));
  	___refAssociations.add(new RefAssociationAndName("MemberSelectionGroupReferencesMemberSelections","org.omg.cwm.analysis.Olap.MemberSelectionGroupReferencesMemberSelections",null));
  	___refAssociations.add(new RefAssociationAndName("SchemaOwnsCubes","org.omg.cwm.analysis.Olap.SchemaOwnsCubes",null));
  	___refAssociations.add(new RefAssociationAndName("SchemaOwnsDimensions","org.omg.cwm.analysis.Olap.SchemaOwnsDimensions",null));
  	___refAssociations.add(new RefAssociationAndName("HierarchyLevelAssociationOwnsDimensionDeployments","org.omg.cwm.analysis.Olap.HierarchyLevelAssociationOwnsDimensionDeployments",null));
  	___refAssociations.add(new RefAssociationAndName("ValueBasedHierarchyOwnsDimensionDeployments","org.omg.cwm.analysis.Olap.ValueBasedHierarchyOwnsDimensionDeployments",null));
  	___refAssociations.add(new RefAssociationAndName("DimensionDeploymentOwnsStructureMaps","org.omg.cwm.analysis.Olap.DimensionDeploymentOwnsStructureMaps",null));
  	___refAssociations.add(new RefAssociationAndName("DimensionDeploymentHasListOfValues","org.omg.cwm.analysis.Olap.DimensionDeploymentHasListOfValues",null));
  	___refAssociations.add(new RefAssociationAndName("DimensionDeploymentHasImmediateParent","org.omg.cwm.analysis.Olap.DimensionDeploymentHasImmediateParent",null));
  	___refAssociations.add(new RefAssociationAndName("CubeOwnsCubeRegions","org.omg.cwm.analysis.Olap.CubeOwnsCubeRegions",null));
  	___refAssociations.add(new RefAssociationAndName("CubeRegionOwnsMemberSelectionGroups","org.omg.cwm.analysis.Olap.CubeRegionOwnsMemberSelectionGroups",null));
  	___refAssociations.add(new RefAssociationAndName("CubeRegionOwnsCubeDeployments","org.omg.cwm.analysis.Olap.CubeRegionOwnsCubeDeployments",null));
  	___refAssociations.add(new RefAssociationAndName("SchemaOwnsDeploymentGroups","org.omg.cwm.analysis.Olap.SchemaOwnsDeploymentGroups",null));
  	___refAssociations.add(new RefAssociationAndName("DeploymentGroupReferencesCubeDeployments","org.omg.cwm.analysis.Olap.DeploymentGroupReferencesCubeDeployments",null));
  	___refAssociations.add(new RefAssociationAndName("DeploymentGroupReferencesDimensionDeployments","org.omg.cwm.analysis.Olap.DeploymentGroupReferencesDimensionDeployments",null));
  	___refAssociations.add(new RefAssociationAndName("CubeDeploymentOwnsContentMaps","org.omg.cwm.analysis.Olap.CubeDeploymentOwnsContentMaps",null));
    }

}




	private class RefPackageAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public boolean imported = false;
		public javax.jmi.reflect.RefPackage refPackage = null;
		public RefPackageAndName(java.lang.String name, java.lang.String qualifiedName, boolean imported, javax.jmi.reflect.RefPackage refPackage) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.imported = imported;
			this.refPackage = refPackage;
		}
	}

	private class RefClassAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public javax.jmi.reflect.RefClass refClass = null;
		public RefClassAndName(java.lang.String name, java.lang.String qualifiedName, javax.jmi.reflect.RefClass refClass) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.refClass = refClass;
		}
	}

	private class RefAssociationAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public javax.jmi.reflect.RefAssociation refAssociation = null;
		public RefAssociationAndName(
			java.lang.String name,
			java.lang.String qualifiedName,
			javax.jmi.reflect.RefAssociation refAssociation) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.refAssociation = refAssociation;
		}
	}

	transient private java.util.List ___refPackages= null;
	transient private java.util.List ___refClasses = null;
	transient private java.util.List ___refAssociations = null;


	/**
	 * @see javax.jmi.reflect.RefPackage#refClass(RefObject)
	 */
	public RefClass refClass(RefObject type) {
		if (type instanceof javax.jmi.model.Classifier) {
			return refClass(((javax.jmi.model.Classifier) type).getName());
		} else {
			throw new javax.jmi.reflect.InvalidCallException(type,null,"refClass()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refClass(String)
	 */
	public RefClass refClass(String typeName) {
		initialize();
		if (typeName == null) {
			throw new javax.jmi.reflect.InvalidCallException(typeName, null, "refClass()");
		}
		RefClass rc = null;
		RefClassAndName rcan = null;
		if (typeName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refClasses.iterator();
			while (i.hasNext() && rcan == null) {
				RefClassAndName rcanTemp = (RefClassAndName) i.next();
				if (typeName.equals(rcanTemp.qualifiedName)) {
					rcan = rcanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refClasses.iterator();
			while (i.hasNext() && rcan == null) {
				RefClassAndName rcanTemp = (RefClassAndName) i.next();
				if (typeName.equals(rcanTemp.name)) {
					rcan = rcanTemp;
				}
			}
		}
		if (rcan != null) {
			if (rcan.refClass == null) {
				rcan.refClass = ___repository.refClassM1(rcan.qualifiedName);
				if (rcan.refClass != null) {
					initInstance(rcan.refClass, rcan.qualifiedName);
				}
			}
			rc = rcan.refClass;
		}
		// not found -> search in packages below in case of qualified name
		if (rc == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rc == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (typeName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefClass rcTemp = rpanTemp.refPackage.refClass(typeName);
					if (rcTemp != null) {
						rc = rcTemp;
					}
				}
			}
		}	


		if (rc == null) {
			throw new javax.jmi.reflect.InvalidNameException(typeName, null);
		}
		return rc;
 	}

	private void initInstance(java.lang.Object instance, String qualifiedName) {
		if (instance != null && instance instanceof com.sap.ip.mmr.m1layer.IMMRObject) {
			com.sap.ip.mmr.m1layer.IMMRObject mmro = (com.sap.ip.mmr.m1layer.IMMRObject) instance;
			mmro.set___ImmediatePackage(this);
			mmro.set___QualifiedNameImmediatePackage(___qualifiedName);
			mmro.set___QualifiedName(qualifiedName);
			mmro.set___Instantiator(this);
			mmro.set___Repository(___repository);
			mmro.set___State(com.sap.ip.mmr.StateEnum.STATE_NEW);
		}
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refPackage(RefObject)
	 */
	public javax.jmi.reflect.RefPackage refPackage(RefObject ro) {
		final String method = "refPackage(RefObject ro)"; //$NON-NLS-1$
		javax.jmi.reflect.RefPackage rp = null;
		if (ro instanceof javax.jmi.model.ModelElement) {
			rp =
				refPackage(
					com.sap.ip.mmr.foundation.Utilities.getUtilities().encodeQualifiedName(
						((javax.jmi.model.ModelElement) ro).getQualifiedName()));
		} else {
			com.sap.ip.mmr.Repository.getCategory().errorT(___location, method, com.sap.ip.mmr.foundation.MMRResourceAccessor.getInstance().getMessageText(___repository.getConnection(), "0000")); //$NON-NLS-1$
			throw new javax.jmi.reflect.InvalidCallException(ro,null,"refPackage()");
		}
		return rp;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refPackage(String)
	 */
	public javax.jmi.reflect.RefPackage refPackage(String packageName) {
		initialize();
		if (packageName == null) {
			throw new javax.jmi.reflect.InvalidCallException(packageName, null, "refPackage()");
		}

		javax.jmi.reflect.RefPackage rp = null;


		// search for match
		RefPackageAndName rpan = null;
		if (packageName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rpan == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.equals(rpanTemp.qualifiedName)) {
					rpan = rpanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rpan == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.equals(rpanTemp.name)) {
					rpan = rpanTemp;
				}
			}
		}
		if (rpan != null) {
			rp = getRefPackage(rpan);
		}

		// not found -> search in packages below in case of qualified name
		if (rp == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rp == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefPackage rpTemp = rpanTemp.refPackage.refPackage(packageName);
					if (rpTemp != null) {
						rp = rpTemp;
					}
				}
			}
		}

        // check top level package
        if (rp == null && packageName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0 && this != ___repository.getTopLevelPackageM1()) {
        	rp = ___repository.getTopLevelPackageM1().refPackage(packageName);
        }

		// THIS CODING IN RefPackageImpl ONLY !!!!
		if (rp == null) {
			// not generated package
			rp = new com.sap.ip.mmr.m1layer.RefPackageImpl(___repository);
			((com.sap.ip.mmr.m1layer.RefPackageImpl) rp).set___QualifiedName(packageName);
			javax.jmi.reflect.RefPackage ip = null;
			javax.jmi.model.MofPackage mp = (javax.jmi.model.MofPackage) refMetaObject();
			if (mp != null) {
				javax.jmi.model.Namespace container = mp.getContainer();
				if (container == null || container.equals(___repository.getMofPackageRootM2())) {
					ip = null;
				} else {
					ip = this;
				}
			}
			((com.sap.ip.mmr.m1layer.RefPackageImpl) rp).set___ImmediatePackage(ip);
		}

		if (rp == null) {
			throw new javax.jmi.reflect.InvalidNameException(packageName, null);
		}
		return rp;
	}

	private javax.jmi.reflect.RefPackage getRefPackage(RefPackageAndName rpan) {
		if (rpan.refPackage == null) {
			if (rpan.imported) {
				//rpan.refPackage = ___repository.getTopLevelPackageM1().refPackage(rpan.qualifiedName);
				rpan.refPackage = ___repository.refPackageM1(rpan.qualifiedName);
				initInstance(rpan.refPackage, rpan.qualifiedName);
			} else {
				// create new one
				rpan.refPackage = ___repository.refPackageM1(rpan.qualifiedName);
				initInstance(rpan.refPackage, rpan.qualifiedName);
			}
		}
		return rpan.refPackage;
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refAssociation(RefObject)
	 */
	public RefAssociation refAssociation(RefObject association) {
		if (association instanceof javax.jmi.model.Association) {
			return refAssociation(((javax.jmi.model.Association) association).getName());
		} else {
			throw new javax.jmi.reflect.InvalidCallException(association, null, "refAssociation()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAssociation(String)
	 */
	public RefAssociation refAssociation(String associationName) {
		initialize();
		if (associationName == null) {
			throw new javax.jmi.reflect.InvalidCallException(associationName, null, "refAssociation()");
		}
		RefAssociation ra = null;
		RefAssociationAndName raan = null;
		if (associationName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refAssociations.iterator();
			while (i.hasNext() && raan == null) {
				RefAssociationAndName raanTemp = (RefAssociationAndName) i.next();
				if (associationName.equals(raanTemp.qualifiedName)) {
					raan = raanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refAssociations.iterator();
			while (i.hasNext() && raan == null) {
				RefAssociationAndName raanTemp = (RefAssociationAndName) i.next();
				if (associationName.equals(raanTemp.name)) {
					raan = raanTemp;
				}
			}
		}
		if (raan != null) {
			if (raan.refAssociation == null) {
				raan.refAssociation = ___repository.refAssociationM1(raan.qualifiedName);
				if (raan.refAssociation != null) {
					initInstance(raan.refAssociation, raan.qualifiedName);
				}
			}
   		    ra = raan.refAssociation;

			// set the association
			if (raan.refAssociation instanceof IMMRAssociation) {
				((IMMRAssociation) raan.refAssociation).setAssociationImpl(get___AssociationsContainer());
			}
			// must be set AFTER the qualified name
			if (raan.refAssociation instanceof com.sap.ip.mmr.m2layer.model.RefAssociationImpl) {
				((com.sap.ip.mmr.m2layer.model.RefAssociationImpl) raan.refAssociation).setAssociationImpl(
					get___AssociationsContainer());
			}
		}
		// not found -> search in packages below in case of qualified name
		if (ra == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && ra == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (associationName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefAssociation raTemp = rpanTemp.refPackage.refAssociation(associationName);
					if (raTemp != null) {
						ra = raTemp;
					}
				}
			}
		}	
		if (ra == null) {
			throw new javax.jmi.reflect.InvalidNameException(associationName, null);
		}
		return ra;
	}

	public com.sap.ip.mmr.foundation.AssociationsContainer get___AssociationsContainer() {
		return ((IMMRObject)(___repository
			.getTopLevelPackageM1()))
			.get___AssociationsContainer();
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllPackages()
	 */
	public Collection refAllPackages() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refPackages.iterator();
		while (i.hasNext()) {
			RefPackageAndName rpan = (RefPackageAndName) i.next();
			javax.jmi.reflect.RefPackage rp = rpan.refPackage;
			if (rp == null) {
				rp = refPackage(rpan.name);
			}
			list.add(rp);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllClasses()
	 */
	public Collection refAllClasses() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refClasses.iterator();
		while (i.hasNext()) {
			RefClassAndName rcan = (RefClassAndName) i.next();
			javax.jmi.reflect.RefClass rc = rcan.refClass;
			if (rc == null) {
				rc = refClass(rcan.name);
			}
			list.add(rc);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllAssociations()
	 */
	public Collection refAllAssociations() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refAssociations.iterator();
		while (i.hasNext()) {
			RefAssociationAndName raan = (RefAssociationAndName) i.next();
			javax.jmi.reflect.RefAssociation ra = raan.refAssociation;
			if (ra == null) {
				ra = refAssociation(raan.name);
			}
			list.add(ra);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refCreateStruct(RefObject, List)
	 */
	public RefStruct refCreateStruct(RefObject struct, List params) throws javax.jmi.reflect.TypeMismatchException {
		if (struct instanceof javax.jmi.model.Classifier) {
			return refCreateStruct(((javax.jmi.model.Classifier) struct).getName(), params);
		} else {
			throw new javax.jmi.reflect.InvalidCallException(struct, null, "refCreateStruct()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refCreateStruct(String, List)
	 */
	public RefStruct refCreateStruct(String structName, List params) throws javax.jmi.reflect.TypeMismatchException {
		String sn = structName;
		// create a new instance and run the appropriate constructor
		if (structName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			sn = structName;
		} else {
			sn = ___qualifiedName + IRepositoryConst.M2PackageDelimiter + structName;
		}
		return ___repository.refCreateStructM1(sn, params);
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refGetEnum(RefObject, String)
	 */
	public RefEnum refGetEnum(RefObject enum, String name) {
		if (enum instanceof javax.jmi.model.EnumerationType) {
			return refGetEnum(((javax.jmi.model.EnumerationType) enum).getName(), name);
		} else {
			RefObject mo = enum.refMetaObject();
			if (mo != null && mo instanceof javax.jmi.model.ModelElement) {
				String nameEnum = ((javax.jmi.model.ModelElement) mo).getName();
				return refGetEnum(nameEnum, name);
			}
		}
		return null;
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refDelete()
	 */
	public void refDelete() {
		___repository.refDeleteM1(this);
		___refPackages.clear();
		___refClasses.clear();
		___refAssociations.clear();
	}



}
