/**
 * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1
 * GENERATED AT Tuesday, February 15, 2005 12:15:23 AM CET
 **/
package org.omg.cwm.analysis.olap;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;

import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefFeatured;


import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IMMRAssociation;


/**
 * Online Analytical Processing (OLAP) is a class of analytic application software 
 * that exposes business data in a multidimensional format. This multidimensional 
 * format usually includes the consolidation of data drawn from multiple and 
 * diverse information sources. Unlike more traditionally structured representations 
 * (e&#46;g&#46;, the tabular format of a relational database), the multidimensional 
 * orientation is a more natural expression of the way business enterprises 
 * view their strategic data. For example, an analyst might use an OLAP application 
 * to examine total sales revenue by product and geographic region over time, 
 * or, perhaps, compare sales margins for the same fiscal periods of two consecutive 
 * years. The ultimate objective of OLAP is the efficient construction of 
 * analytical models that transform raw business data into strategic business 
 * insight.
 * 
 * 
 * 
 * There are many ways to implement OLAP. Most OLAP systems are 
 * constructed using OLAP server tools that enable logical OLAP structures 
 * to be built on top of a variety of physical database systems, such as relational 
 * or native multidimensional databases.
 * 
 * 
 * 
 * The following features are generally 
 * found in most OLAP systems:
 * 
 * 
 * 
 *     Multidimensional representation of business 
 * data.
 * 
 *     Upward consolidation of multidimensional data in a hierarchical 
 * manner, possibly with the application of specialized processing rules.
 * 
 *  
 *    The ability to navigate a hierarchy from a consolidated value to the 
 * lower level values forming it.
 * 
 *     Support for time-series analysis; i&#46;e&#46;, 
 * OLAP users are generally concerned with data and consolidations at specific 
 * points in time -- By date, week, quarter, etc.
 * 
 *     Support for modeling 
 * and scenario analysis -- A user should be able to apply arbitrary "what-if" 
 * analyses to a result set without affecting the stored information.
 * 
 *    
 *  Consistent response times, regardless of how queries are formulated -- 
 * This is critical for effective analysis and modeling.
 * 
 * 
 * 
 * OLAP applications 
 * integrate well into the data warehousing environment, because a data warehouse 
 * provides relatively clean and stable data stores to drive the OLAP application. 
 * These data stores are usually maintained in relational tables that can 
 * be read directly by OLAP tools or loaded into OLAP servers. These relational 
 * tables are often structured in a manner that reveals the inherent dimensionality 
 * of the data (such as the ubiquitous Star and Snowflake schemas). Also, 
 * the data transformation and mapping services provided by a data warehouse 
 * can be used to supply OLAP systems with both metadata and data. Transformation-related 
 * metadata can be used to track the
 * 
 * lineage of consolidated OLAP data back 
 * to its various sources.
 * 
 * 
 * 
 * The primary objectives of the CWM OLAP package 
 * are:
 * 
 * 
 * 
 *     Define a metamodel of essential OLAP concepts common to most 
 * OLAP systems.
 * 
 *     Provide a facility whereby instances of the OLAP metamodel 
 * are mapped to deployment-capable structures (i&#46;e&#46;, models of physical 
 * data resources, such as the CWM Relational and Multidimensional packages).
 * 
 *  
 *    Ensure that navigation through the logical OLAP model hierarchy and 
 * its various resource models is always performed in a uniform manner (i&#46;e&#46;, 
 * by defining a standard usage of the CWM Transformation package as a means 
 * of implementing these mappings).
 * 
 *     Leverage services provided by other 
 * CWM packages, where appropriate (e&#46;g&#46;, use the CWM Foundation 
 * package to supply a standard representation of expressions).
 * 
 * 
 * 
 * The OLAP 
 * package depends on the following packages:
 * 
 * 
 * 
 *    org.omg::CWM::ObjectModel::Core
 * 
 *  
 *   org.omg::CWM::Foundation::Expressions
 * 
 *    org.omg::CWM::Analysis::Transformation
 * 
 * 
 * 
 * The 
 * major classes and associations of the OLAP metamodel are shown in Figure 
 * 14-1.  Schema is the logical container of all elements comprising an OLAP 
 * model. It is the root element of the model hierarchy and marks the entry 
 * point for navigating OLAP models.
 * 
 * 
 * 
 * A Schema contains Dimensions and Cubes. 
 * A Dimension is an ordinate within a multidimensional structure and consists 
 * of a list of unique values (i&#46;e&#46;, members) that share a common 
 * semantic meaning within the domain being modeled. Each member designates 
 * a unique position along its ordinate.
 * 
 * 
 * 
 * A Cube is a collection of analytic 
 * values (i&#46;e&#46;, measures) that share the same dimensionality. This 
 * dimensionality is specified by a set of unique Dimensions from the Schema. 
 * Each unique combination of members in the Cartesian product of the Cube?s 
 * Dimensions identifies precisely one data cell within a multidimensional 
 * structure.
 * 
 * 
 * 
 * CubeDimensionAssociation relates a Cube to its defining Dimensions. 
 * Features relevant to Cube-Dimension relationships (e&#46;g&#46;, calcHierarchy) 
 * are exposed by this class.
 * 
 * 
 * 
 * A Dimension has zero or more Hierarchies. 
 * A Hierarchy is an organizational structure that describes a traversal pattern 
 * through a Dimension, based on parent/child relationships between members 
 * of a Dimension. Hierarchies are used to define both navigational and consolidation/computational 
 * paths through the Dimension (i&#46;e&#46;, a value associated with a child 
 * member is aggregated by one or more parents). For example, a Time Dimension 
 * with a base periodicity of days might have a Hierarchy
 * 
 * specifying the 
 * consolidation of days into weeks, weeks into months, months into quarters, 
 * and quarters into years.
 * 
 * 
 * 
 * A specific Hierarchy may be designated as the 
 * default Hierarchy for display purposes (e&#46;g&#46;, a user interface 
 * that displays the Dimension as a hierarchical tree of members).  CubeDimensionAssociation 
 * can also identify a particular Hierarchy as the default Hierarchy for consolidation 
 * calculations performed on the Cube.
 * 
 * 
 * 
 * MemberSelection models mechanisms 
 * capable of partitioning a Dimension?s collection of members. For example, 
 * consider a Geography Dimension with members representing cities, states, 
 * and regions. An OLAP client interested specifically in cities might define 
 * an instance of MemberSelection that extracts the city members.
 * 
 * 
 * 
 * CubeRegion 
 * models a sub-unit of a Cube that is of the same dimensionality as the Cube 
 * itself. Each "dimension" of a CubeRegion is represented by a MemberSelection 
 * of the corresponding Dimension  of the Cube. Each MemberSelection may define 
 * some subset of its Dimension?s members.
 * 
 * 
 * 
 * CubeRegions are used to implement 
 * Cubes. A Cube may be realized by a set of CubeRegions that map portions 
 * of the logical Cube to physical data sources. The MemberSelections defining 
 * CubeRegions can also be grouped together via MemberSelectionGroups, enabling 
 * the definition of CubeRegions with specific semantics. For example, one 
 * can specify a CubeRegion containing only the "input level" data cells of 
 * a Cube.
 * 
 * 
 * 
 * A CubeRegion may own any number of CubeDeployments. CubeDeployment 
 * is a metaclass that represents an implementation strategy for a multidimensional 
 * structure. The ordering of the CubeDeployment classes may optionally be 
 * given some implementation-specific meaning (e&#46;g&#46;, desired order 
 * of selection of several possible deployment strategies, based on optimization 
 * considerations).
 * 
 * 
 * 
 * The OLAP metamodel defines two special types of Dimension: 
 * Time and Measure. A Time Dimension provides a means of representing time-series 
 * data within a multidimensional structure. The members of a Time Dimension 
 * usually define some base periodicity (e&#46;g&#46;, days of the week). 
 * The implementation of a Time Dimension might provide support for advanced 
 * "time-intelligent" functionality, such as the ability to automatically 
 * convert between different periodicities and calendars.
 * 
 * 
 * 
 * The members of 
 * a Measure Dimension describe the meaning of the analytic values stored 
 * in each data cell of a multidimensional structure. For example, an OLAP 
 * application may define Sales, Quantity and Weight as its measures. In this 
 * case, each data cell within the Cube stores three values, with each value 
 * corresponding to one of the three measures. A measure may have an associated 
 * data type. For example, Sales might be of a monetary type, Quantity an 
 * integer, and Weight a real number.
 * 
 * 
 * 
 * The OLAP metamodel specifies two 
 * subclasses of Hierarchy: LevelBasedHierarchy and ValueBasedHierarchy.
 * 
 * 
 * 
 * LevelBasedHierarchy 
 * describes hierarchical relationships between specific levels of a Dimension. 
 * LevelBasedHierarchy is used to model both "pure level" hierarchies (e&#46;g&#46;, 
 * dimension-level tables) and "mixed" hierarchies (i&#46;e&#46;, levels 
 * plus linked nodes). Dimensional levels are modeled by the Level class, 
 * a subclass of MemberSelection that partitions a Dimension?s members into 
 * disjoint subsets, each representing a distinct level.
 * 
 * 
 * 
 * For example, the 
 * Geography Dimension cited earlier contains members representing cities, 
 * states, and regions, such as "Stamford", "Connecticut", and "NorthEast". 
 * It might also contain a single member called "USA" representing all regions 
 * of the United States. Therefore, the Geography Dimension could have four 
 * Levels named "City", "State", 'Region", and "ALL", respectively. Each Level 
 * specifies the subset of members belonging to it: All cities belong to the 
 * "City" Level, all states belong to the "State" Level, all regions belong 
 * to the "Region" Level, and the single "USA" member belongs to the "ALL" 
 * Level.
 * 
 * 
 * 
 * When used in the definition of a consolidation path, the meaning 
 * of "level" is quite clear: Members occupying a given Level consolidate 
 * into the next higher Level (e&#46;g&#46;, City rolls up into State, State 
 * into Region, and Region into ALL).
 * 
 * 
 * 
 * LevelBasedHierarchy contains an ordered 
 * collection of HierarchyLevelAssocations that defines the natural hierarchy 
 * of the Dimension. The ordering defines the hierarchical structure in top-down 
 * fashion (i&#46;e&#46;, the "first" HierarchyLevelAssociation in the ordered 
 * collection represents the upper-most level of the dimensional hierarchy).
 * 
 * 
 * 
 * A 
 * HierarchyLevelAssociation may own any number of DimensionDeployments. DimensionDeployment 
 * is a metaclass that represents an implementation strategy for hierarchical 
 * Dimensions. The ordering of the DimensionDeployment classes may optionally 
 * be given an implementation-specific meaning (e&#46;g&#46;, desired order 
 * of selection of several possible deployment strategies, based on optimization
 * 
 * considerations).
 * 
 * 
 * 
 * A 
 * ValueBasedHierarchy defines a hierarchical ordering of members in which 
 * the concept of level has little or no significance. Instead, the topological 
 * structure of the hierarchy conveys meaning. ValueBasedHierarchies are often 
 * used to model situations where members are classified or ranked according 
 * to their distance from a common root member (e&#46;g&#46;, an organizational 
 * chart of a corporation). In this case, each member of the hierarchy has 
 * some specific "metric" or "value" associated it with it. ValueBasedHierarchy 
 * can be used to model pure "linked node" hierarchies (e&#46;g&#46;,
 * 
 * asymmetric 
 * hierarchical graphs or parent-child tables). 
 * 
 * 
 * 
 * As with LevelBasedHierarchy, 
 * ValueBasedHierarchy also has an ordered collection of dimensionDeployments, 
 * where the ordering semantics are left to implementations to define.
 * 
 * 
 * 
 * Figure 
 * 14-3 illustrates how classes of the OLAP metamodel inherit from the CWM
 * 
 * Object 
 * Model. Two classes requiring further explanation are:
 * 
 * 
 * 
 *     Measure: A 
 * subclass of Attribute that describes the meaning of values stored in the 
 * data cells of a multidimensional structure. Different OLAP models often 
 * give different interpretations to the term "measure". In a relational Star 
 * Schema, individual measures might be represented by non-key columns of 
 * a Fact table (e&#46;g&#46;, "Sales" and "Quantity" columns). In this case, 
 * measure may be an attribute of a Cube or CubeRegion that models the Fact 
 * table. On the other hand, measures can
 * 
 * also be represented by members 
 * of a Measure Dimension. A Fact table supporting this representation has 
 * a single Measure column with column values consisting of the members "Sales" 
 * and "Quantity", and a single "value" column (i&#46;e&#46;, an implicit 
 * data dimension) storing the corresponding measure values. A similar notion 
 * of Measure Dimension is used in modeling pure hypercube representations 
 * of
 * 
 * multidimensional servers. Thus, the concept of measure can be represented 
 * either as a Dimenson or as an Attribute, depending on the type of OLAP 
 * system being modeled.
 * 
 * 
 * 
 *     Coded Level: A subclass of Level that assigns 
 * a unique encoding, or label, to each of its members. CodedLevel is not 
 * essential to the OLAP metamodel, but is provided as a helper class for 
 * certain applications that might benefit from the ability of OLAP systems 
 * to structure data hierarchically. For example, CodedLevel could be used 
 * to model systems of nomenclature or classification.
 * 
 * 
 * 
 * The CWM OLAP metamodel 
 * describes logical models of OLAP systems, but does not directly specify 
 * how an OLAP system is physically deployed. Modeling the deployment of an 
 * OLAP system requires mapping instances of OLAP metaclasses to instances 
 * of other CWM metaclasses representing physical resources (e&#46;g&#46;, 
 * mapping an OLAP Dimension to a Relational Table). This approach offers 
 * several advantages:
 * 
 * 
 * 
 *     The status of the OLAP metamodel as a conceptual 
 * model is preserved by this level of indirection. When using OLAP, a client 
 * may perceive to be working directly with OLAP objects, but the actual implementation 
 * of those objects is hidden from the client. For example, a client may view 
 * a member as a value of a Dimension, but whether that member value comes 
 * from a row of a relational table, or from a cell in a multidimensional 
 * database, is usually not obvious to the client. On the other hand, if a 
 * client needs to determine how a logical OLAP structure is physically realized, 
 * the metadata describing this mapping is fully available (assuming that 
 * the implementation allows the client to drill-down through the metadata).
 * 
 * 
 * 
 *  
 *    The possibility of defining mappings based on expressions means that 
 * the amount of metadata required to describe large models (e&#46;g&#46;, 
 * Dimensions containing large collections of members) can be kept within 
 * reasonable bounds. It is generally more efficient to provide expressions 
 * that specify where large metadata sets reside, how to connect to them, 
 * and how to map their contents, rather than representing them directly as 
 * part of the metadata content.
 * 
 * 
 * 
 * All of the OLAP metaclasses are potential 
 * candidates for such deployment mappings. In addition, some OLAP models 
 * may also define mappings between several OLAP metaclass instances, forming 
 * a natural hierarchy of logical objects (e&#46;g&#46;, Dimension Attributes 
 * are mapped to Level Attributes which, in turn, are mapped to Table Columns).
 * 
 * 
 * 
 * The 
 * CWM Transformation package is used as the primary means of describing these 
 * mappings. A modeler constructing an OLAP model based on CWM will generally 
 * define instances of the TransformationMap metaclass to link logical OLAP 
 * objects together, and to link those logical objects to other objects representing 
 * their physical data sources.
 * 
 * 
 * 
 * StructureMap is a subclass of TransformationMap 
 * that models structure-oriented transformation mappings (i&#46;e&#46;, 
 * member identity and hierarchical structure). This type of transformation 
 * mapping needs to be connected to the OLAP metamodel in a very specific 
 * way (according to Level and Hierarchy), so the StructureMap subclass is 
 * defined to make these associations explicit. Two specific usages of StructureMap 
 * are defined: ListOfValues, which maps attributes identifying members residing 
 * at a specific Level, or at a specific Level within a particular Hierarchy, 
 * and ImmediateParent, which maps attributes identifying the hierarchical 
 * parent(s) of the members.
 * 
 * 
 * 
 * On the other hand, relatively simple TransformationMaps 
 * can be defined within any OLAP model to represent attribute-oriented transformations 
 * (e&#46;g&#46;, mapping Dimension Attributes to Table Columns that store 
 * attribute values).
 * 
 * 
 * 
 * ContentMap is a subclass of TransformationMap that 
 * models content-oriented transformaton mappings (i&#46;e&#46;, cell data 
 * or measure values). For example, an instance of ContentMap might be used 
 * to map each of a CubeRegion?s Measures to Columns of an underlying Fact 
 * Table.
 * 
 * 
 * 
 * Note that, in either case (structural mapping or content mapping), 
 * the traversal patterns used by any CWM OLAP implementation are always the 
 * same, since both deployment mappings are based on the same usage of CWM 
 * TransformationMaps. In addition to representing structural mappings, instances 
 * of TransformationMap and its subclasses are also capable of storing implementation-dependent 
 * functions or procedures that yield the instance values associated with 
 * mapped model elements. For example, a "list of values" StructureMap might 
 * store an SQL statement such as "select memberName from Product where productFamily 
 * = ?consumerElectronics? ", as the value of its formula attribute.
 * 
 * 
 * 
 * Figure 
 * 14-4 illustrates the CWM metaclasses and associations that describe deployment 
 * mappings between logical OLAP models and physical resource models. Note 
 * that it is possible to combine both Cube (content) and Dimension (structure) 
 * deployments together within the context of a single OLAP Schema (via the 
 * DeploymentGroup metaclass). Thus, an OLAP Schema can have several possible 
 * deployments that users may select based on implementation-specific considerations 
 * (e&#46;g&#46;, physical optimizations).
 * 
 * 
 * 
 * OCL Representation of OLAP 
 * Constraints
 * 
 * 
 * 
 * [C-1] Ensure that the Dimensions defining a Cube are unique.
 * 
 * context 
 * Cube inv:
 * 
 * self.cubeDimensionAssociation->forAll( c1, c2 | c1 <> c2 implies
 * 
 * c1.dimension 
 * <> c2.dimension )
 * 
 * 
 * 
 * [C-2] A Cube without CubeRegions cannot be mapped 
 * to a deployment structure (i&#46;e&#46;, physical source of data).
 * 
 * context 
 * Cube inv:
 * 
 * self.cubeRegion->isEmpty implies self.isVirtual = true
 * 
 * 
 * 
 * [C-3] 
 * If a calcHierarchy is defined, it must be a Hierarchy owned by the Dimension 
 * referenced by the CubeDimensionAssociation.
 * 
 * context CubeDimensionAssociation 
 * inv:
 * 
 * self.calcHierarchy->notEmpty implies self.calcHierarchy.dimension 
 * = self.dimension
 * 
 * 
 * 
 * [C-4] A "fully realized" CubeRegion has no MemberSelectionGroups 
 * (and hence, no MemberSelections).
 * 
 * context CubeRegion inv:
 * 
 * self.isFullyRealized 
 * implies self.memberSelectionGroup->isEmpty
 * 
 * 
 * 
 * [C-5] A CubeRegion defined 
 * by MemberSelections must have, for each Dimension of its owning Cube, a 
 * corresponding MemberSelection within each of its
 * 
 * MemberSelectionGroups.
 * 
 * context 
 * CubeRegion inv:
 * 
 * self.memberSelectionGroup->notEmpty implies
 * 
 * self.cube.cubeDimensionAssociation->forAll( 
 * d |
 * 
 * self.memberSelectionGroup->forAll( g |
 * 
 * g.memberSelection->exists( 
 * m | m.dimension = d.dimension ) ) )
 * 
 * 
 * 
 * [C-6] A CubeRegion defined by MemberSelections 
 * must have, within each MemberSelectionGroup, a MemberSelection corresponding 
 * to each Dimension of its
 * 
 * owning Cube.
 * 
 * context CubeRegion inv:
 * 
 * self.memberSelectionGroup->notEmpty 
 * implies
 * 
 * self.memberSelectionGroup->forAll( g |
 * 
 * g.memberSelection->forAll( 
 * m |
 * 
 * self.cube.cubeDimensionAssociation->exists( d | d.dimension = m.dimension 
 * ) ) )
 * 
 * 
 * 
 * [C-7] A Dimension may be a Time Dimension, a Measure Dimension, 
 * or neither, but never both types at the same time.
 * 
 * context Dimension inv:
 * 
 * not 
 * ( self.isTime and self.isMeasure )
 * 
 * 
 * 
 * [C-8] The default display Hierarchy 
 * (if defined) must be one of the Hierarchies owned by the Dimension.
 * 
 * context 
 * Dimension inv:
 * 
 * self.displayDefault->notEmpty implies self.hierarchy->includes( 
 * self.displayDefault )
 * 
 * 
 * 
 * [C-9] An instance of DimensionDeployment must 
 * be referenced exclusively by either a HierarchyLevelAssociation or a ValueBasedHierarchy.
 * 
 * context 
 * DimensionDeployment inv:
 * 
 * self.hierarchyLevelAssociation->isEmpty xor self.valueBasedHierarchy->isEmpty
 * 
 * 
 * 
 * [C-10] 
 * Within a DimensionDeployment, an "immediate parent" StructureMap must always 
 * have an associated and distinct "list of values" StructureMap.
 * 
 * context 
 * DimensionDeployment inv:
 * 
 * self.immediateParent->notEmpty implies
 * 
 * ( self.listOfValues->notEmpty 
 * and self.listOfValues <> self.immediateParent )
 * 
 * 
 * 
 * [C-11] A StructureMap 
 * referenced as a "list of values" StructureMap must not reside outside of 
 * the DimensionDeployment?s collection of StructureMaps.
 * 
 * context DimensionDeployment 
 * inv:
 * 
 * self.listOfValues->notEmpty implies self.structureMap->includes( 
 * self.listOfValues )
 * 
 * 
 * 
 * [C-12] A StructureMap referenced as an "immediate 
 * parent" StructureMap must not reside outside of the DimensionDeployment?s 
 * collection of StructureMaps.
 * 
 * context DimensionDeployment inv:
 * 
 * self.immediateParent->notEmpty 
 * implies
 * 
 * self.structureMap->includes( self.immediateParent )
 * 
 * 
 * 
 * [C-13] 
 * The currentLevel of each HierarchyLevelAssociation must refer to a Level 
 * owned by the Dimension of the LevelBasedHierarchy containing the HierarchyLevelAssociation.
 * 
 * context 
 * LevelBasedHierarchy inv:
 * 
 * self.hierarchyLevelAssociation->notEmpty implies
 * 
 * self.hierarchyLevelAssociation->forAll( 
 * h |
 * 
 * self.dimension.memberSelection
 * 
 * ->select( oclType = Olap::Level )->includes( 
 * h.currentLevel ) )
 * 
 * 
 * 
 * [C-14] No two HierarchyLevelAssociations may designate 
 * the same Level instance as their "current level".
 * 
 * context LevelBasedHierarchy 
 * inv:
 * 
 * self.hierarchyLevelAssociation->forAll( h1, h2 | h1 <> h2 implies
 * 
 * h1.currentLevel 
 * <> h2.currentLevel )
 */
public interface OlapPackage extends javax.jmi.reflect.RefPackage  {
// each imported package where:
//   isClustered and
//   Import.visibility == public_vis and
//   importedNamespace.visibility == public_vis
public org.omg.cwm.objectmodel.core.CorePackage getCore();
public org.omg.cwm.foundation.expressions.ExpressionsPackage getExpressions();
public org.omg.cwm.analysis.transformation.TransformationPackage getTransformation();

// each contained package where visibility = public_vis

// each directly contained class with visibility = public_vis
public org.omg.cwm.analysis.olap.ContentMapClass getContentMap();
public org.omg.cwm.analysis.olap.CubeClass getCube();
public org.omg.cwm.analysis.olap.CubeDeploymentClass getCubeDeployment();
public org.omg.cwm.analysis.olap.CubeDimensionAssociationClass getCubeDimensionAssociation();
public org.omg.cwm.analysis.olap.CubeRegionClass getCubeRegion();
public org.omg.cwm.analysis.olap.DeploymentGroupClass getDeploymentGroup();
public org.omg.cwm.analysis.olap.DimensionClass getDimension();
public org.omg.cwm.analysis.olap.DimensionDeploymentClass getDimensionDeployment();
public org.omg.cwm.analysis.olap.HierarchyClass getHierarchy();
public org.omg.cwm.analysis.olap.HierarchyLevelAssociationClass getHierarchyLevelAssociation();
public org.omg.cwm.analysis.olap.LevelBasedHierarchyClass getLevelBasedHierarchy();
public org.omg.cwm.analysis.olap.MemberSelectionGroupClass getMemberSelectionGroup();
public org.omg.cwm.analysis.olap.MemberSelectionClass getMemberSelection();
public org.omg.cwm.analysis.olap.SchemaClass getSchema();
public org.omg.cwm.analysis.olap.ValueBasedHierarchyClass getValueBasedHierarchy();
public org.omg.cwm.analysis.olap.LevelClass getLevel();
public org.omg.cwm.analysis.olap.CodedLevelClass getCodedLevel();
public org.omg.cwm.analysis.olap.MeasureClass getMeasure();
public org.omg.cwm.analysis.olap.StructureMapClass getStructureMap();

// each directly contained association with visibility = public_vis
public org.omg.cwm.analysis.olap.LevelBasedHierarchyOwnsHierarchyLevelAssociations getLevelBasedHierarchyOwnsHierarchyLevelAssociations();
public org.omg.cwm.analysis.olap.HierarchyLevelAssocsReferenceLevel getHierarchyLevelAssocsReferenceLevel();
public org.omg.cwm.analysis.olap.DimensionOwnsMemberSelections getDimensionOwnsMemberSelections();
public org.omg.cwm.analysis.olap.CubeOwnsCubeDimensionAssociations getCubeOwnsCubeDimensionAssociations();
public org.omg.cwm.analysis.olap.CubeDimensionAssociationsReferenceDimension getCubeDimensionAssociationsReferenceDimension();
public org.omg.cwm.analysis.olap.DimensionOwnsHierarchies getDimensionOwnsHierarchies();
public org.omg.cwm.analysis.olap.DimensionHasDefaultHierarchy getDimensionHasDefaultHierarchy();
public org.omg.cwm.analysis.olap.CubeDimensionAssociationsReferenceCalcHierarchy getCubeDimensionAssociationsReferenceCalcHierarchy();
public org.omg.cwm.analysis.olap.MemberSelectionGroupReferencesMemberSelections getMemberSelectionGroupReferencesMemberSelections();
public org.omg.cwm.analysis.olap.SchemaOwnsCubes getSchemaOwnsCubes();
public org.omg.cwm.analysis.olap.SchemaOwnsDimensions getSchemaOwnsDimensions();
public org.omg.cwm.analysis.olap.HierarchyLevelAssociationOwnsDimensionDeployments getHierarchyLevelAssociationOwnsDimensionDeployments();
public org.omg.cwm.analysis.olap.ValueBasedHierarchyOwnsDimensionDeployments getValueBasedHierarchyOwnsDimensionDeployments();
public org.omg.cwm.analysis.olap.DimensionDeploymentOwnsStructureMaps getDimensionDeploymentOwnsStructureMaps();
public org.omg.cwm.analysis.olap.DimensionDeploymentHasListOfValues getDimensionDeploymentHasListOfValues();
public org.omg.cwm.analysis.olap.DimensionDeploymentHasImmediateParent getDimensionDeploymentHasImmediateParent();
public org.omg.cwm.analysis.olap.CubeOwnsCubeRegions getCubeOwnsCubeRegions();
public org.omg.cwm.analysis.olap.CubeRegionOwnsMemberSelectionGroups getCubeRegionOwnsMemberSelectionGroups();
public org.omg.cwm.analysis.olap.CubeRegionOwnsCubeDeployments getCubeRegionOwnsCubeDeployments();
public org.omg.cwm.analysis.olap.SchemaOwnsDeploymentGroups getSchemaOwnsDeploymentGroups();
public org.omg.cwm.analysis.olap.DeploymentGroupReferencesCubeDeployments getDeploymentGroupReferencesCubeDeployments();
public org.omg.cwm.analysis.olap.DeploymentGroupReferencesDimensionDeployments getDeploymentGroupReferencesDimensionDeployments();
public org.omg.cwm.analysis.olap.CubeDeploymentOwnsContentMaps getCubeDeploymentOwnsContentMaps();

// each directly contained StructType with visibility = public_vis

// each directly contained EnumType with visibility = public_vis


}
