/**
 * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1
 * GENERATED AT Tuesday, February 15, 2005 12:15:22 AM CET
 **/
package org.omg.cwm.analysis.businessnomenclature;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;

import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefFeatured;


import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IMMRAssociation;


/**
 * Business users of data warehouses need to have a good understanding of what 
 * information and tools exist in a data warehouse. They need to understand 
 * what the information means from a business perspective, how it is derived, 
 * from what data resources it is derived, and what analysis and reporting 
 * tools exist for manipulating and reporting the information. They may also 
 * need to subscribe to analysis and reporting tools, and have them run with 
 * results delivered to them on a regular basis.
 * 
 *  
 * 
 * The BusinessNomenclature 
 * package contains classes and associations that can be used to represent 
 * business metadata. Easy access to this business metadata enables business 
 * users to exploit the value of the information in a data warehouse. It can 
 * also aid technical users in certain tasks. An example is the use of common 
 * business terms and concepts for discussing information requirements with 
 * business users. Another example is accessing business intelligence tools 
 * for analyzing the impact of warehouse design changes.
 * 
 * 
 * 
 * The scope of the 
 * BusinessNomenclature package is restricted to the domain of data warehousing 
 * and business intelligence.
 * 
 * 
 * 
 * This section provides a description of the 
 * main features of the BusinessNomenclature package.
 * 
 * 
 * 
 * The BusinessNomenclature 
 * package provides two main constructs to represent business terms and concepts 
 * and related semantics:
 * 
 * 
 * 
 *     Taxonomy is a collection of concepts that 
 * provide the context for the meaning of a particular term.
 * 
 *     Glossary 
 * is a collection of terms and various related forms of the term.
 * 
 * 
 * 
 * A taxonomy 
 * is a collection of concepts. Concepts represent semantic information and 
 * relationships. Concepts are identified by terms, which in turn are manifested 
 * by a word or phrase. More than one term may describe the same concept and 
 * a given term may describe more than one concept.
 * 
 * A glossary is a collection 
 * of terms that are related through explicit or implicit relationships. Terms 
 * may be preferred (the term best representing its concept) and thus represent 
 * the vocabulary of a business domain or user. Terms may be synonyms and 
 * point at the preferred term. A preferred term and its synonyms represent 
 * the fact that several terms describe the same concept although with different 
 * shades of meaning.
 * 
 * 
 * 
 * Terms may be arranged into a hierarchy of more generic 
 * and more specific elements. This relationship allows substituting a narrower 
 * term, such as "USA", for a wider term, such as "country".
 * 
 * 
 * 
 * The BusinessNomenclature 
 * package depends on the following packages:
 * 
 * 
 * 
 *     omg.org::CWM::ObjectModel::Core
 * 
 * 
 * 
 * The 
 * metamodel diagram for the BusinessNomenclature package is split into two 
 * parts. The first diagram shows the BusinessNomenclature classes and associations, 
 * while the second shows the inheritance hierarchy.
 * 
 * 
 * 
 * OCL Representation 
 * of Business Nomenclature Constraints
 * 
 * [C-1] A Concept may not relate to 
 * itself.
 * 
 * context Concept
 * 
 * inv: self.relatedConcept->forAll ( p | p <> self 
 * )
 * 
 * 
 * 
 * [C-2] The parent of a Glossary must be a Glossary.
 * 
 * context Glossary
 * 
 * inv: 
 * self.parent.oclIsKindOf( Glossary )
 * 
 * 
 * 
 * [C-3] The child of a Glossary must 
 * be a Glossary.
 * 
 * context Glossary
 * 
 * inv: self.child->forAll( p | p.oclIsKindOf( 
 * Glossary ) )
 * 
 * 
 * 
 * [C-4] The parent of a Taxonomy must be a Taxonomy.
 * 
 * context 
 * Taxonomy
 * 
 * inv: self.parent.oclIsKindOf( Taxonomy )
 * 
 * 
 * 
 * [C-5] The child of 
 * a Taxonomy must be a Taxonomy.
 * 
 * context Taxonomy
 * 
 * inv: self.child->forAll( 
 * p | p.oclIsKindOf( Taxonomy ) )
 * 
 * 
 * 
 * [C-6] A Term may not relate to itself.
 * 
 * context 
 * Term
 * 
 * inv: self.relatedTerm->forAll ( p | p <> self )
 * 
 * 
 * 
 * [C-7] A VocabularyElement 
 * may not relate to itself.
 * 
 * context Vocabulary
 * 
 * inv: self.relatedElement->forAll 
 * ( p | p <> self )
 * 
 * 
 * 
 * [C-8] The RelatedConcepts association is derived from 
 * the RelatedVocabularyElements association. All ends of the RelatedConcepts 
 * association must be Concepts.
 * 
 * context RelatedConcepts
 * 
 * inv: RelatedVocabularyElements.allInstances.select( 
 * element.oclIsKindOf( Concept )
 * 
 * and relatedElement.oclIsKindOf( Concept 
 * ) )
 * 
 * 
 * 
 * [C-9] The RelatedTerms association is derived from the RelatedVocabularyElements 
 * association. All ends of the RelatedTerms association must beTerms.
 * 
 * context 
 * RelatedTerms
 * 
 * inv: RelatedVocabularyElements.allInstances.select( element.oclIsKindOf( 
 * Term ) and
 * 
 * relatedElement.oclIsKindOf( Term ) )
 */
public interface BusinessNomenclaturePackage extends javax.jmi.reflect.RefPackage  {
// each imported package where:
//   isClustered and
//   Import.visibility == public_vis and
//   importedNamespace.visibility == public_vis
public org.omg.cwm.objectmodel.core.CorePackage getCore();

// each contained package where visibility = public_vis

// each directly contained class with visibility = public_vis
public org.omg.cwm.analysis.businessnomenclature.VocabularyElementClass getVocabularyElement();
public org.omg.cwm.analysis.businessnomenclature.NomenclatureClass getNomenclature();
public org.omg.cwm.analysis.businessnomenclature.TaxonomyClass getTaxonomy();
public org.omg.cwm.analysis.businessnomenclature.GlossaryClass getGlossary();
public org.omg.cwm.analysis.businessnomenclature.BusinessDomainClass getBusinessDomain();
public org.omg.cwm.analysis.businessnomenclature.ConceptClass getConcept();
public org.omg.cwm.analysis.businessnomenclature.TermClass getTerm();

// each directly contained association with visibility = public_vis
public org.omg.cwm.analysis.businessnomenclature.GlossaryToTaxonomy getGlossaryToTaxonomy();
public org.omg.cwm.analysis.businessnomenclature.TermToConcept getTermToConcept();
public org.omg.cwm.analysis.businessnomenclature.RelatedVocabularyElements getRelatedVocabularyElements();
public org.omg.cwm.analysis.businessnomenclature.RelatedConcepts getRelatedConcepts();
public org.omg.cwm.analysis.businessnomenclature.RelatedTerms getRelatedTerms();
public org.omg.cwm.analysis.businessnomenclature.VocabularyElementToModelElement getVocabularyElementToModelElement();
public org.omg.cwm.analysis.businessnomenclature.SynonymToPreferredTerm getSynonymToPreferredTerm();
public org.omg.cwm.analysis.businessnomenclature.WiderToNarrowerTerm getWiderToNarrowerTerm();
public org.omg.cwm.analysis.businessnomenclature.NomenclatureHierarchy getNomenclatureHierarchy();

// each directly contained StructType with visibility = public_vis

// each directly contained EnumType with visibility = public_vis


}
