package com.sap.security.api.umap.system;

import java.util.Enumeration;

/**
 * 
 *  Serves as wrapper for a system landscape to be plugged into the UME.
 *  The concept knows to naming principles: unique keys and aliases. Unique keys
 *  are unique in the sense that two systems are distinct if and only if their
 *  unique keys are distinct. In contrast to this one system can have several
 *  aliases. So distinction is not possible based upon aliases.
 */
public interface ISystemLandscapeWrapper
{
    /**
     *  Returns all aliases for systems known to
     *  this landscape object wrapper.
     *  @return Enumeration of all aliases
     */
    public Enumeration getAllAliases ()
        throws ExceptionInImplementationException;
    
    /**
     *  Returns a unique key for a given alias
     *  @param alias Alias pointing to a system
     *  @return guid that corresponds to this alias or null if bad alias
     */
    public String    getUniqueKeyForAlias (String alias)
        throws ExceptionInImplementationException;
    
    /**
     *  Gets a list of all unique keys of system in the underlying
     *  system landscape
     *  @return Enumeration with all unique keys
     */
    public Enumeration getAllUniqueKeys ()
        throws ExceptionInImplementationException;
    
    /**
     *  Retrieves a system landscape object stored under this unique key or
     *  null if not found.
     *  @param unique_key unique key of a system
     *  @return ISystemLandscapeObject representing this system
     */
    public ISystemLandscapeObject getSystemByUniqueKey (String unique_key)
        throws ExceptionInImplementationException;
    
    /**
     *  Retrieves a system landscape object stored under this alias or null
     *  if not found
     *  @param alias
     *  @return
     *  @throws ExceptionInImplementationException
     */
    public ISystemLandscapeObject getSystemByAlias (String alias)
        throws ExceptionInImplementationException;
        
}
