package com.sap.security.api.umap.system;

import java.util.Enumeration;

/**
 *  Wrapper object of a system provided by a non-UME system landscape.
 */
public interface ISystemLandscapeObject
{
    /**
     *  Gets the unique identifier of this system. Together
     *  with the storage key prefix (see {@link #getStorageKeyPrefix()})
     *  the identifier for a system in the user mapping tables
     *  @return unique key as String
     */
    public String   getUniqueKey ();
    
    /**
     *  Returns one of the keys {@link ILoginConstants#SSO_JCO_LOGON_METHOD_UIDPW},
     *      {@link com.sap.security.api.logon.ILoginConstants#SSO_JCO_LOGON_METHOD_TICKET},
     *      {@link com.sap.security.api.logon.ILoginConstants#SSO_JCO_LOGON_METHOD_X509CERT}
     *  @return returns the logon method for this system or null if logon issues are
     *      not relevant for this system
     */
    public String   getLogonMethod ();
    
    /**
     *  Returns an attribute for this system
     *  @param key key for this attribute
     *  @return the attribute value as object
     */
    public Object   getAttribute (String key);
    
    /**
     *  Returns a plain text description for this system
     */
    public String   getSystemDescription ();
    
    /**
     *  Returns a printable name for this system (like for
     *  select lists).
     */
    public String   getPrintableName ();
    
    /**
     *  Returns the implementation of ISystemLandscapeWrapper in order
     *  to be able to distinguish system objects that come from different
     *  system landscapes.
     */
    public Class    getLandscapeClass ();
    
    /**
     *  Returns a prefix to make up the system key in the user mapping
     *  tables. This key will be &lt;prefix&gt;:&lt;unique key&gt;. The
     *  idea behind this is to be able to distinguish the entries for
     *  which system types they were created.
     *  @return the prefix
     */
    public String   getStorageKeyPrefix ();
    
    /**
     *  @return Returns an enumeration of all keys of
     *  available system attributes.
     */
    public Enumeration getAttributeNames ();
    
    /**
     *  @return gets the alias of this system object
     */
    public String getAlias ();
}
