package com.sap.security.api.umap;

/**
 *  This exception is thrown when an inverse search for user elements gives
 *  more than one hit. See {@link IUserMapping#getInverseMappingData(String,String,byte)}.
 */
public class MultipleHitException extends NoLogonDataAvailableException
{
    String [] _userids;
	/**
	 * Constructor for MultipleHitException.
	 */
	public MultipleHitException (String [] userids)
    {
		super();
        _userids = userids;
	}

	/**
	 * Constructor for MultipleHitException.
	 * @param msg Exception message
     * @param userids user ids of the user objects found
	 */
	public MultipleHitException(String msg, String [] userids)
    {
		super (msg);
        _userids = userids;
	}

    /**
     *  Returns the array of hits.
     *  @return a string arrays with uids of the users found that
     *          have maintained the same mapping.
     */ 
    public String [] getUserNames ()
    {
        return _userids;
    }
}
