package com.sap.security.api;

import  java.io.*;

/**
 * This is the superclass of all runtime exceptions employed in the user
 * management; it indicates error conditions that can occur during the normal
 * operation of the JVM.
 * @author <a href=mailto:lambert.boskamp@sap.com>Lambert Boskamp</a>
 * @version 1.0
 */
public class UMRuntimeException
    extends RuntimeException {
    private Throwable m_throwable;


    public UMRuntimeException (Throwable nestedException, String message) {
        super(message);
        m_throwable = nestedException;
    }


    public UMRuntimeException (Throwable nestedException) {
        super(nestedException.getMessage());
        m_throwable = nestedException;
    }


    public UMRuntimeException (String message) {
        super(message);
    }


    public UMRuntimeException () {
        super();
    }


    public Throwable getNestedException () {
        return m_throwable;
    }


    public void printStackTrace () {
        super.printStackTrace();
        if (m_throwable != null) {
            System.err.println("Nested Exception: ");
            m_throwable.printStackTrace();
        }
    }


    public void printStackTrace (PrintStream s) {
        super.printStackTrace(s);
        if (m_throwable != null) {
            s.println("Nested Exception: ");
            m_throwable.printStackTrace(s);
        }
    }


    public void printStackTrace (PrintWriter s) {
        super.printStackTrace(s);
        if (m_throwable != null) {
            s.println("Nested Exception: ");
            m_throwable.printStackTrace(s);
        }
    }
}
