package com.sap.security.api;

/**
 * This exception indicates an attempt to access a non-existing role object in the
 * object store.
 */
public class NoSuchRoleException extends NoSuchPrincipalException
{
	
/**
 * Constructs a new NoSuchRoleException with a descriptive <code>message</code>.
 */
   public NoSuchRoleException(String id)
   {
      super("Role with id=\"" + id + "\" does not exist.");
   }
   
   public NoSuchRoleException(Throwable reason)
   {
   		super(reason);
   }
}
