package com.sap.security.api;

import javax.servlet.http.*;


/**
 *  This class retrieves the user information of currently logged-in user.
 *  Please see also {@link com.sap.security.api.logon.ILogonAuthentication}
 *
 */

public interface IAuthentication extends IConfigurable
{
	/**
	 * Checks whether the user is currently logged in and returns an 
	 * implementation of IUser
	 * <p>
	 * If the user is not yet logged in, a respective logon page is written as
	 * ServletResponse. In that case (i.e. <code>null</code> is returned) the calling
	 * servlet can simply end their doGet or doPost method with return.
	 * <p>Example:
	 * <pre>
	 * IUser uid = forceLoggedInUser(req,res);
	 * if (uid == null) return;
	 * </pre>
	 *
	 * @param	req		HttpServletRequest
	 * @param	resp	HttpServletResponse
	 * @return	The currently logged in IUser object or <code>null</code> otherwise.
	 */
	public IUser forceLoggedInUser(HttpServletRequest req, HttpServletResponse resp);

	/**
	 * Checks whether the user is currently logged in and returns an 
	 * implementation of IUser
	 * If no user is currently logged in <code>null</code> is returned.
	 *
	 * @param	req		HttpServletRequest
	 * @param	resp	HttpServletResponse
	 * @return	The currently logged in IUser object or <code>null</code> otherwise.
	 */
	public IUser getLoggedInUser(HttpServletRequest req, HttpServletResponse resp);

	/**
	 * Logouts current user.
	 * <p>Some cookies will be deleted in the HttpServletResponse.
	 *
	 * @param	req		HttpServletRequest
	 * @param	resp	HttpServletResponse
	 */
	public void logout(HttpServletRequest req,HttpServletResponse resp);

	/**
	 * Logoff user by invalidate the user session and deleting the authentication
     * cookies.
	 * <p>
     * The user will also be sent to a logoff page which acknowledges that a logoff
     * has taken place with a link for the user to logon again.
	 * <p>Example:
	 * <pre>
	 * forceLogoffUser(req, res, returnURL);
	 * </pre>
	 *
	 * @param	req		HttpServletRequest
	 * @param	resp	HttpServletResponse
     * @param   returnURL url to use to logon again.
	 */
	public void forceLogoffUser(HttpServletRequest req, HttpServletResponse resp, String url);
}
