package com.sap.security.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/**
 *  Only for internal use.
 */
class GenericDummyImplFactory
{
    public static Object getDummyInstance (Class [] interfaces, ClassLoader cl)
    {
        return Proxy.newProxyInstance (cl, interfaces, new DummyInvocationHandler ());
    }
}

class DummyInvocationHandler implements InvocationHandler
{ 	
    /**
     * @see java.lang.reflect.InvocationHandler#invoke(Object, Method, Object[])
     */
    public Object invoke(Object obj, Method method, Object[] args)
        throws Throwable
    {
        String methodName = method.getName ();
        String margs = "(" + args[0].getClass().getName ();
        
        if (methodName.equals ("initialize")) {
            return null;
        }
         
        for (int i=1; i<args.length; i++) {
            margs += (", " + args[i]);
        }
        margs+=")";
        String exceptiontext = methodName + margs + " not supported in the " +
            "dummy implementation";
        
        
        throw new UnsupportedOperationException (exceptiontext);
    }

}

