/*
 * Copyright (c) 2003 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFC_Fault.java#1 $
 */
package com.sap.tc.webdynpro.modelimpl.dynamicrfc;

import com.sap.aii.proxy.framework.core.FactoryConstants;
import com.sap.tc.logging.Location;

/**
 * Title:        Web Dynpro Dynamic RFC Adapter Exception
 * Description:
 * Copyright:    Copyright (c) 2003
 * Company:      SAP AG
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFC_Fault.java#1 $
 */
public class WDDynamicRFC_Fault extends com.sap.tc.webdynpro.modelimpl.dynamicrfc.DynamicRFCModelClass implements java.io.Serializable   {

	private static final Location logger = Location.getLocation(WDDynamicRFC_Fault.class.getName());
	static {
		Location.getLocation("ID.com.sap.tc.webdynpro.modelimpl.dynamicrfc").infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFC_Fault.java#1 $");
	}

	protected Class _associatedModelClazz() { return null; }
	protected com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType _defaultScope(){ return null; }
  private static final long serialVersionUID = 1094208048L ;

  private static final com.sap.aii.proxy.framework.core.BaseTypeDescriptor staticDescriptor ;

  private static final com.sap.aii.proxy.framework.core.GenerationInfo staticGenerationInfo = new com.sap.aii.proxy.framework.core.GenerationInfo("2.0", 1057764384406L) ;

  static {
    com.sap.aii.proxy.framework.core.BaseTypeDescriptor descriptor = createNewBaseTypeDescriptor(com.sap.aii.proxy.framework.core.XsdlConstants.XSDL_COMPLEX_TYPE, "urn:sap-com:document:sap:rfc:functions", "WDDynamicRFC_Fault.Exception", 4, 0, WDDynamicRFC_Fault.class, com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_XML, "WDDynamicRFC_Fault", 0, -1, -1);
		descriptorSetElementProperties(descriptor, 0, "Name", null, null, "unqualified", "http://www.w3.org/2001/XMLSchema:string", "urn:sap-com:document:sap:rfc:functions", false, 1, 1, false, null, "Name", NameType.class, null, new java.lang.String[][]{}, null, 0, 0, 0, -1, -1, -1, -1, 0, null);
    descriptorSetElementProperties(descriptor, 1, "Text", null, null, "unqualified", "http://www.w3.org/2001/XMLSchema:string", "urn:sap-com:document:sap:rfc:functions", false, 0, 1, false, null, "Text", java.lang.String.class, null, new java.lang.String[][]{}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
    descriptorSetElementProperties(descriptor, 2, "Message", null, null, "unqualified", null, "urn:sap-com:document:sap:rfc:functions", false, 0, 1, false, null, "Message", MessageType.class, new MessageType(), new java.lang.String[][]{}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
    descriptorSetElementProperties(descriptor, 3, "Attributes", null, null, "unqualified", null, "urn:sap-com:document:sap:rfc:functions", false, 0, 1, false, null, "Attributes", AttributesType.class, new AttributesType(), new java.lang.String[][]{}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
    staticDescriptor = descriptor;
  }

  public WDDynamicRFC_Fault() {
		super(new Descriptor(staticDescriptor, "static Descriptor for: 'WDDynamicRFC_Fault'"),	staticGenerationInfo, FactoryConstants.CONNECTION_TYPE_XML);
        
  }

  /**  */
  public AttributesType getAttributes() {
    return (AttributesType)baseTypeData().getElementValue(3);
  }

  /** Value space = Xsdl string
  Restrictions:
  values = "AUSNAHME" */
	public void setName(NameType Name) {
			baseTypeData().setElementValue(0, Name);
	}

  /**  */
  public void setMessage(MessageType Message) {
    baseTypeData().setElementValue(2, Message);
  }

  /** Value space = Xsdl string */
  public java.lang.String getText() {
    return (java.lang.String)baseTypeData().getElementValueAsString(1);
  }

  /**  */
  public MessageType getMessage() {
    return (MessageType)baseTypeData().getElementValue(2);
  }

  /** Value space = Xsdl string */
	public NameType getName() {
			return (NameType)baseTypeData().getElementValue(0);
	}

  /**  */
  public void setAttributes(AttributesType Attributes) {
    baseTypeData().setElementValue(3, Attributes);
  }

  /** Value space = Xsdl string */
  public void setText(java.lang.String Text) {
    baseTypeData().setElementValue(1, Text);
  }

	public java.lang.String toString() {
		return getText();
  }

  /**
   * Helper class that represents the attributes (parameters) of an RFC
   * exception message. Required by the AII Proxy layer to fully describe exceptions.
   *
   * @SAPWebDynproPart 4
   */
	public static class AttributesType extends com.sap.tc.webdynpro.modelimpl.dynamicrfc.DynamicRFCModelClass implements java.io.Serializable   {

		protected Class _associatedModelClazz() { return null; }
		protected com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType _defaultScope(){ return null; }
    private static final long serialVersionUID = 1349121361L ;

    private static final com.sap.aii.proxy.framework.core.BaseTypeDescriptor staticDescriptor ;

    private static final com.sap.aii.proxy.framework.core.GenerationInfo staticGenerationInfo = new com.sap.aii.proxy.framework.core.GenerationInfo("2.0", 1057764384406L) ;

    static {
      com.sap.aii.proxy.framework.core.BaseTypeDescriptor descriptor = createNewBaseTypeDescriptor(com.sap.aii.proxy.framework.core.XsdlConstants.XSDL_COMPLEX_TYPE, "", null, 4, 0, AttributesType.class, com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_XML, null, -1, -1, -1, null);
      descriptorSetElementProperties(descriptor, 0, "V1", null, null, "unqualified", "http://www.w3.org/2001/XMLSchema:string", "urn:sap-com:document:sap:rfc:functions", false, 0, 1, false, null, "V1", java.lang.String.class, null, new java.lang.String[][]{{"maxLength", "50"}}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
      descriptorSetElementProperties(descriptor, 1, "V2", null, null, "unqualified", "http://www.w3.org/2001/XMLSchema:string", "urn:sap-com:document:sap:rfc:functions", false, 0, 1, false, null, "V2", java.lang.String.class, null, new java.lang.String[][]{{"maxLength", "50"}}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
      descriptorSetElementProperties(descriptor, 2, "V3", null, null, "unqualified", "http://www.w3.org/2001/XMLSchema:string", "urn:sap-com:document:sap:rfc:functions", false, 0, 1, false, null, "V3", java.lang.String.class, null, new java.lang.String[][]{{"maxLength", "50"}}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
      descriptorSetElementProperties(descriptor, 3, "V4", null, null, "unqualified", "http://www.w3.org/2001/XMLSchema:string", "urn:sap-com:document:sap:rfc:functions", false, 0, 1, false, null, "V4", java.lang.String.class, null, new java.lang.String[][]{{"maxLength", "50"}}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
      staticDescriptor = descriptor;
    }
    public AttributesType () {
      super(new Descriptor(staticDescriptor, "static Descriptor for: 'AttributesType'"), staticGenerationInfo, com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_XML);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 50 */
    public void setV3(java.lang.String V3) {
      baseTypeData().setElementValue(2, V3);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 50 */
    public void setV2(java.lang.String V2) {
      baseTypeData().setElementValue(1, V2);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 50 */
    public java.lang.String getV2() {
      return (java.lang.String)baseTypeData().getElementValueAsString(1);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 50 */
    public void setV1(java.lang.String V1) {
      baseTypeData().setElementValue(0, V1);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 50 */
    public void setV4(java.lang.String V4) {
      baseTypeData().setElementValue(3, V4);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 50 */
    public java.lang.String getV4() {
      return (java.lang.String)baseTypeData().getElementValueAsString(3);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 50 */
    public java.lang.String getV1() {
      return (java.lang.String)baseTypeData().getElementValueAsString(0);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 50 */
    public java.lang.String getV3() {
      return (java.lang.String)baseTypeData().getElementValueAsString(2);
    }
  }

  /**
   * Helper class that represents the message part of an RFC
   * exception message. Required by the AII Proxy layer to fully describe exceptions.
   *
   * @SAPWebDynproPart 4
   */
  public static class MessageType extends com.sap.tc.webdynpro.modelimpl.dynamicrfc.DynamicRFCModelClass implements java.io.Serializable   {

		protected Class _associatedModelClazz() { return null; }
		protected com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType _defaultScope(){ return null; }
    private static final long serialVersionUID = 794775489L ;

    private static final com.sap.aii.proxy.framework.core.BaseTypeDescriptor staticDescriptor ;

    private static final com.sap.aii.proxy.framework.core.GenerationInfo staticGenerationInfo = new com.sap.aii.proxy.framework.core.GenerationInfo("2.0", 1057764384406L) ;

    static {
      com.sap.aii.proxy.framework.core.BaseTypeDescriptor descriptor = createNewBaseTypeDescriptor(com.sap.aii.proxy.framework.core.XsdlConstants.XSDL_COMPLEX_TYPE, "", null, 2, 0, MessageType.class, com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_XML, null, -1, -1, -1, null);
      descriptorSetElementProperties(descriptor, 0, "ID", null, null, "unqualified", "http://www.w3.org/2001/XMLSchema:string", "urn:sap-com:document:sap:rfc:functions", false, 1, 1, false, null, "Id", java.lang.String.class, null, new java.lang.String[][]{{"maxLength", "20"}}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
      descriptorSetElementProperties(descriptor, 1, "Number", null, null, "unqualified", "http://www.w3.org/2001/XMLSchema:string", "urn:sap-com:document:sap:rfc:functions", false, 1, 1, false, null, "Number", java.lang.String.class, null, new java.lang.String[][]{{"pattern", "\\d+"}, {"maxLength", "3"}}, null, -1, -1, -1, -1, -1, -1, -1, 0, null);
      staticDescriptor = descriptor;
    }
    public MessageType () {
      super(new Descriptor(staticDescriptor, "static Descriptor for: 'MessageType'"), staticGenerationInfo, com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_XML);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 20 */
    public void setId(java.lang.String Id) {
      baseTypeData().setElementValue(0, Id);
    }

    /** Value space = Xsdl string
    Restrictions:
    pattern = "\\d+"
    , maxLength = 3 */
    public java.lang.String getNumber() {
      return (java.lang.String)baseTypeData().getElementValueAsString(1);
    }

    /** Value space = Xsdl string
    Restrictions:
    maxLength = 20 */
    public java.lang.String getId() {
      return (java.lang.String)baseTypeData().getElementValueAsString(0);
    }

    /** Value space = Xsdl string
    Restrictions:
    pattern = "\\d+"
    , maxLength = 3 */
    public void setNumber(java.lang.String Number) {
      baseTypeData().setElementValue(1, Number);
    }
  }

  /**
   * Helper class required by the AII Proxy layer to fully describe exceptions.
   *
   * @SAPWebDynproPart 4
   */
	public static class NameType extends com.sap.aii.proxy.framework.core.EnumerationType implements java.io.Serializable {
    
			private  static final long serialVersionUID = 1905239173L ;
    
			private  final java.lang.String name ;
    
			private  NameType (java.lang.String name) {
					this.name = name;
			}
    
			public java.lang.String getValue() {
					return name;
			}
    
			public static NameType fromString(java.lang.String name) {
					return new NameType(name);
			}
    
			public static NameType fromValue(java.lang.String name) {
				return new NameType(name);
			}
    
			public java.lang.String toString() {
					return java.lang.String.valueOf(name);
			}
    
	}

}
