/*
 * Copyright (c) 2003 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/IWDDynamicRFCModelClass.java#1 $
 */
package com.sap.tc.webdynpro.modelimpl.dynamicrfc;

import com.sap.tc.cmi.model.ICMIGenericModelClass;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.cmi.util.ICMIModificationCount;
import com.sap.tc.webdynpro.progmodel.model.api.IWDModelClassChangeTracking;
import com.sap.tc.webdynpro.progmodel.model.api.IWDModelClassRegistrable;
import com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType;

/**
 * Provides access to all generic functionality that an Adaptive RFC ModelClass
 * implements. </p>
 * 
 * Beside the functionality defined through the extended interfaces (originating 
 * from the Common Model Interface (CMI) and the Web Dynpro Model Interface), 
 * access to the Model identifying parameters <code>scope</code> and 
 * <code>instanceId</code> is provided. </p>
 * 
 * Application frameworks can cast from generated Adaptive RFC ModelClasses to 
 * this interface if they need to deal with the generated ModelClasses in a 
 * generic way (eg. when developing application frameworks). </p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/IWDDynamicRFCModelClass.java#1 $
 */
public interface IWDDynamicRFCModelClass extends ICMIGenericModelClass, ICMIModificationCount, IWDModelClassChangeTracking, IWDModelClassRegistrable
{
  /** 
   * Returns the <code>instanceId</code> representing the Model this ModelClass is associated with.
   */
  String modelInstanceId();

  /**
   * Returns the <code>scope</code>, which defines the maximal lifetime of this ModelClass instance.
   */
  WDModelScopeType scope();

}
