package com.sap.tests.propmetadata;

import java.util.ArrayList;
import java.util.List;

import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.km.ejb.svc.propmetadata.IPropMetaGroup;
import com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName;
import com.sap.caf.km.ejb.svc.propmetadata.IPropNamespace;
import com.sap.caf.km.ejb.svc.propmetadata.PropException;
import com.sap.caf.km.ejb.svc.propmetadata.PropMetadataLocal;
import com.sap.caf.km.ejb.svc.propmetadata.PropMetadataLocalHome;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class TestPropMetadata extends Test {
	protected InitialContext m_initContext;
	private static List m_params = new ArrayList();
	protected final static String JNDI_NAME_PARAM = "JNDI_PROPMETADATA_NAME";
	protected final static String JNDI_NAME_VALUE = "localejbs/sap.com/caf~com.sap.caf.runtime/PropMetadataBean";
	protected PropMetadataLocal m_ejb;
			 	 
	public static void adjustTestAttributes(IJverTestAttributes pAttribs) {
		// the fixture (prepare/cleanUp) is done for each method (true)
		// or for the whole class only (false)
		pAttribs.setFixtureForMethod(false);

		// instantiate a new object for each test method (true)
		// or execute all tests within one object (false)
		// only regarded if fixtureForMethod is set true.
		pAttribs.setInstantiationForMethod(false);

		// define parameters and its defaults for the test:
		// pAttribs.defineParameters (new String [] {"key=value"});
		addParameter(JNDI_NAME_PARAM+"="+JNDI_NAME_VALUE);
		
		pAttribs.defineParameters((String[])m_params.toArray(new String[m_params.size()]));
		pAttribs.setTestSet(new String[] {
				"testGetNamespaces",
				"testGetNamesByNamespace",
				"testGetNamesByGroupId",
				"testGetNamesByNamespaceAndGroupId",
				"testGetNames",
				"testGetGroups",
				"testGetGroupsByNamespace"
			});				
	}

	protected static void addParameter(String param) {
		m_params.add(param);
	}

	/**
	 * setup test environment 
	 * (init in constructor is discouraged)
	 **/
	public void prepare() throws Exception {
		/* creating of the Initial Context */
		m_initContext = new InitialContext();
	
		/* helper bean for getting of the transaction context*/
		PropMetadataLocalHome home = (PropMetadataLocalHome)m_initContext.lookup(getParameter(JNDI_NAME_PARAM));
		m_ejb = (PropMetadataLocal)home.create();
	}

	public void testGetNames() throws PropException {
		IPropMetaName[] names = m_ejb.getNames();
		verify(names!=null && names.length>0, "Meta names array is null or empty!");
	}

	public void testGetGroups() throws PropException {
		IPropMetaGroup[] groups = m_ejb.getGroups();
		verify(groups!=null && groups.length>0, "Meta groups array is null or empty!");
	}

	public void testGetGroupsByNamespace() throws PropException {
		IPropNamespace namespace = new IPropNamespace() {
			public String getAlias() {
				return "col";
			}
			public String getNamespace() {
				return "http://sapportals.com/xmlns/cm/collaboration";
			}
		};
		IPropMetaGroup[] groups = m_ejb.getGroups(namespace);
		verify(groups!=null && groups.length>0, "Meta groups array is null or empty!");
	}
	
	public void testGetNamesByGroupId() throws PropException {
		String groupId = "system";
		IPropMetaName[] names = m_ejb.getNames(groupId);
		verify(names!=null && names.length>0, "Could not get Meta Names by Group Id ["+groupId+"], meta names array is null or empty!");
	}

	public void testGetNamespaces() throws PropException {
		IPropNamespace[] namespaces = m_ejb.getNamespaces();
		verify(namespaces!=null && namespaces.length>0, "Could not get namespaces: either result array is null or empty!");
	}
	
	public void testGetNamesByNamespace() throws PropException {
		IPropNamespace[] namespaces = m_ejb.getNamespaces();
		verify(namespaces!=null && namespaces.length>0, "Could not get namespaces: either result array is null or empty!");
		IPropMetaName[] names = m_ejb.getNames(namespaces[0]);
		verify(names!=null && names.length>0, "Meta names array is null or empty!");
	}

	public void testGetNamesByNamespaceAndGroupId() throws PropException {
		IPropNamespace[] namespaces = m_ejb.getNamespaces();
		verify(namespaces!=null && namespaces.length>0, "Could not get namespaces: either result array is null or empty!");
		String groupId=namespaces[0].getAlias(); // use alias as group id it's true in the custom case 
		IPropMetaName[] names = m_ejb.getNames(namespaces[0], groupId);
		verify(names!=null && names.length>0, "Meta names array is null or empty!");
	}
	

}
