package com.sap.caf.km.ejb.svc.propmetadata;

import javax.naming.InitialContext;

import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.proxies.data.kmpropmetadata.KMPropMetadataSvc;
import com.sap.caf.km.proxies.data.kmpropmetadata.KMPropMetadataSvcService;
import com.sap.caf.km.proxies.data.kmpropmetadata.types.KMPropMetaGroup;
import com.sap.caf.km.proxies.data.kmpropmetadata.types.KMPropMetaName;
import com.sap.caf.km.proxies.data.kmpropmetadata.types.KMPropNamespace;

/**
 * @author viachaslau_kudzinau@epam.com
 */
class PropMetadataSvc implements IPropMetadataSvc, IPropMetadataResourceKeys{

	PropMetadataSvc() throws PropException {
		try {
			InitialContext context = new InitialContext();
			KMPropMetadataSvcService service = (KMPropMetadataSvcService) context.lookup(JNDI_NAME);
			m_proxy = (KMPropMetadataSvc)service.getLogicalPort(KMPropMetadataSvc.class);
			// substitute real host:port instead of template names
			String url = ProxyHelper.getActualUrl((String)m_proxy._getProperty(KMPropMetadataSvc.ENDPOINT_ADDRESS_PROPERTY));
			m_proxy._setProperty(KMPropMetadataSvc.ENDPOINT_ADDRESS_PROPERTY, url);
		} catch (Exception e) {
			throw new PropException(RES_CANT_CREATE_PROXY, e);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadataSvc#getNames()
	 */
	public IPropMetaName[] getNames() throws PropException {
		try {
			return createPropMetaNames(m_proxy.getNames());
		} catch (Exception e) {
			throw new PropException(RES_CANT_GET_META_NAMES, e);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadataSvc#getNames(com.sap.caf.km.ejb.svc.propmetadata.IPropNamespace)
	 */
	public IPropMetaName[] getNames(IPropNamespace namespace) throws PropException {
		try {
			return createPropMetaNames(m_proxy.getNames(getProxyNamespace(namespace)));
		} catch (Exception e) {
			throw new PropException(RES_CANT_GET_META_NAMES, e);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadataSvc#getNames(java.lang.String)
	 */
	public IPropMetaName[] getNames(String groupId) throws PropException {
		try {
			return createPropMetaNames(m_proxy.getNames(groupId));
		} catch (Exception e) {
			throw new PropException(RES_CANT_GET_META_NAMES, e);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadataSvc#getNames(com.sap.caf.km.ejb.svc.propmetadata.IPropNamespace, java.lang.String)
	 */
	public IPropMetaName[] getNames(IPropNamespace namespace, String groupId) throws PropException {
		try {
			return createPropMetaNames(m_proxy.getNames(getProxyNamespace(namespace), groupId));
		} catch (Exception e) {
			throw new PropException(RES_CANT_GET_META_NAMES, e);
		}
	}
	
	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadataSvc#getGroups()
	 */
	public IPropMetaGroup[] getGroups() throws PropException {
		return getGroups(null);
	}
	
	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadataSvc#getGroups(com.sap.caf.km.ejb.svc.propmetadata.IPropNamespace)
	 */
	public IPropMetaGroup[] getGroups(IPropNamespace namespace) throws PropException {
		try {
			KMPropMetaGroup[] proxyGroups = (namespace==null? 
					m_proxy.getGroups(): m_proxy.getGroups(getProxyNamespace(namespace)));
			if (proxyGroups==null || proxyGroups.length==0) {
				return null;
			}
			return createPropMetaGroups(proxyGroups);
		} catch (Exception e) {
			throw new PropException(RES_CANT_GET_META_GROUPS, e);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadataSvc#getNamespaces()
	 */
	public IPropNamespace[] getNamespaces() throws PropException {
		try {
			KMPropNamespace[] proxyNamespaces = m_proxy.getNamespaces();
			if (proxyNamespaces==null || proxyNamespaces.length==0) {
				return null;
			}
			IPropNamespace[] namespaces = new IPropNamespace[proxyNamespaces.length]; 
			for(int i=0; i<proxyNamespaces.length; i++) {
				namespaces[i] = new PropNamespace(proxyNamespaces[i]);
			}
			return namespaces;
		} catch (Exception e) {
			throw new PropException(RES_CANT_GET_NAMESPACES, e);
		}
	}
	
	protected IPropMetaName[] createPropMetaNames(KMPropMetaName[] proxyNames) {
		if (proxyNames==null || proxyNames.length==0) {
			return null;
		}
		IPropMetaName[] names = new IPropMetaName[proxyNames.length];
		for (int i=0; i<proxyNames.length; i++) {
			names[i] = new PropMetaName(proxyNames[i]);
		}
		return names; 
	}

	protected IPropMetaGroup[] createPropMetaGroups(KMPropMetaGroup[] proxyGroups) {
		if (proxyGroups==null || proxyGroups.length==0) {
			return null;
		}
		IPropMetaGroup[] groups = new IPropMetaGroup[proxyGroups.length];
		for(int i=0; i<proxyGroups.length; i++) {
			groups[i] = new PropMetaGroup(proxyGroups[i]);
		}
		return groups;
	}
	
	protected KMPropNamespace getProxyNamespace(IPropNamespace namespace) {	
		KMPropNamespace proxyNamespace;
		if (namespace instanceof PropNamespace) {
			proxyNamespace = ((PropNamespace)namespace).getProxy();
		}
		else {
			proxyNamespace = new KMPropNamespace();
			proxyNamespace.setAlias(namespace.getAlias());
			proxyNamespace.setNamespace(namespace.getNamespace());
		}
		return proxyNamespace;
	}
	
	protected KMPropMetadataSvc m_proxy;
	protected final static String JNDI_NAME = "wsclients/proxies/sap.com/caf~km.proxies/KMPropMetadataJNDI";
}
