package com.sap.caf.km.ejb.svc.propmetadata;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.tc.logging.Location;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class PropMetadataBean extends KMDataAccessBean implements IPropMetadata, IPropMetadataResourceKeys {
	private transient IPropMetadataSvc m_remoteSvc;
	private transient SessionContext m_sessionContext;
	
	private static final String APPLICATION = PropMetadataBean.class.getName();
	private static final String jARMReqPrefix = "CAF:RT:oal:"; 
	private static final String JARM_REQUEST =  jARMReqPrefix + APPLICATION;		
	private static final Location location = Location.getLocation(APPLICATION);

	public void ejbCreate() throws CreateException {
		final String method = JARM_REQUEST + ":ejbCreate()";
		enter(method, null);
		try {
			m_remoteSvc = PropMetadataFactory.getInstance().getService();
		}
		catch (Exception e) {
			PropException propEx = new PropException(RES_CANT_CREATE_EJB, e);
			log(propEx, method, null);
			throw new CreateException(propEx.getLocalizedMessage());
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadata#getNamespaces()
	 */
	public IPropNamespace[] getNamespaces() throws PropException {
		final String method = JARM_REQUEST + ":getNamespaces()";
		enter(method, null);
		try {
			return m_remoteSvc.getNamespaces();
		}
		catch (Exception e) {
			PropException propEx = new PropException(e);
			log(propEx, method, null);
			throw propEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadata#getNames()
	 */
	public IPropMetaName[] getNames() throws PropException {
		final String method = JARM_REQUEST + ":getNames()";
		enter(method, null);
		try {
			return m_remoteSvc.getNames();
		}
		catch (Exception e) {
			PropException propEx = new PropException(e);
			log(propEx, method, null);
			throw propEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadata#getNames(com.sap.caf.km.ejb.svc.propmetadata.IPropNamespace)
	 */
	public IPropMetaName[] getNames(IPropNamespace namespace) throws PropException {
		final String method = JARM_REQUEST + ":getNames(IPropNamespace)";
		enter(method, new Object[] { namespace });
		try {
			return m_remoteSvc.getNames(namespace);
		}
		catch (Exception e) {
			PropException propEx = new PropException(e);
			log(propEx, method, null);
			throw propEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadata#getNames(java.lang.String)
	 */
	public IPropMetaName[] getNames(String groupId) throws PropException {
		final String method = JARM_REQUEST + ":getNames(String)";
		enter(method, new Object[] { groupId });
		try {
			return m_remoteSvc.getNames(groupId);
		}
		catch (Exception e) {
			PropException propEx = new PropException(e);
			log(propEx, method, null);
			throw propEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadata#getNames(com.sap.caf.km.ejb.svc.propmetadata.IPropNamespace, java.lang.String)
	 */
	public IPropMetaName[] getNames(IPropNamespace namespace, String groupId) throws PropException {
		final String method = JARM_REQUEST + ":getNames(IPropNamespace, String)";
		enter(method, new Object[] { namespace, groupId });
		try {
			return m_remoteSvc.getNames(namespace, groupId);
		}
		catch (Exception e) {
			PropException propEx = new PropException(e);
			log(propEx, method, null);
			throw propEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadata#getGroups(com.sap.caf.km.ejb.svc.propmetadata.IPropNamespace)
	 */
	public IPropMetaGroup[] getGroups(IPropNamespace namespace) throws PropException {
		final String method = JARM_REQUEST + ":getGroups(IPropNamespace)";
		enter(method, new Object[] { namespace });
		try {
			return m_remoteSvc.getGroups(namespace);
		}
		catch (Exception e) {
			PropException propEx = new PropException(e);
			log(propEx, method, null);
			throw propEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetadata#getGroups()
	 */
	public IPropMetaGroup[] getGroups() throws PropException {
		final String method = JARM_REQUEST + ":getGroups()";
		enter(method, null);
		try {
			return m_remoteSvc.getGroups();
		}
		catch (Exception e) {
			PropException propEx = new PropException(e);
			log(propEx, method, null);
			throw propEx;
		}
		finally {
			exit(method, null);
		}
	}

	protected Location getLocation() {
		return location;
	}

	protected String getJARMRequest() {
		return JARM_REQUEST;
	}

}
