package com.sap.caf.km.ejb.svc.propmetadata;

import com.sap.caf.km.proxies.data.kmpropmetadata.types.KMPropMetaName;
import com.sap.caf.km.proxies.data.kmpropmetadata.types.KMPropMetaValue;

/**
 * @author viachaslau_kudzinau@epam.com
 */
class PropMetaName implements IPropMetaName {

	PropMetaName(KMPropMetaName proxyName) {
		m_proxy = proxyName;
		// eval allowed values
		KMPropMetaValue[] proxyValues = m_proxy.getAllowedValues();
		if (proxyValues!=null && proxyValues.length>0) {
			m_allowedValues = new IPropMetaValue[proxyValues.length];
			for(int i=0; i<proxyValues.length; i++) {
				m_allowedValues[i] = new PropMetaValue(proxyValues[i]);
			}
		}
		// eval default value
		KMPropMetaValue proxyValue = m_proxy.getDefaultValue();
		if (proxyValue!=null) {
			m_defaultValue = new PropMetaValue(proxyValue);
		}
		// eval names used to compose current name 
		KMPropMetaName[] proxyNames = m_proxy.getComposedOfMetaNames();
		if (proxyNames!=null && proxyNames.length>0) {
			m_composedOfNames = new PropMetaName[proxyNames.length];
			for(int i=0; i<proxyNames.length; i++) {
				m_composedOfNames[i] = new PropMetaName(proxyNames[i]);
			}
		}
	}
	
	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getId()
	 */
	public String getId() {
		return m_proxy.getId();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getFullId()
	 */
	public String getFullId() {
		return m_proxy.getFullId();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getName()
	 */
	public String getName() {
		return m_proxy.getName();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getNamespace()
	 */
	public String getNamespace() {
		return m_proxy.getNamespace();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getGroupId()
	 */
	public String getGroupId() {
		return m_proxy.getGroupId();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getDescription()
	 */
	public String getDescription() {
		return m_proxy.getDescription();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getAllowedValues()
	 */
	public IPropMetaValue[] getAllowedValues() {
		return m_allowedValues;
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#hasAllowedValues()
	 */
	public boolean hasAllowedValues() {
		return m_allowedValues!=null && m_allowedValues.length>0;
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getType()
	 */
	public String getType() {
		return m_proxy.getType();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#isMandatory()
	 */
	public boolean isMandatory() {
		return m_proxy.getMandatory();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#isIndexable()
	 */
	public boolean isIndexable() {
		return m_proxy.getIndexable();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#isHidden()
	 */
	public boolean isHidden() {
		return m_proxy.getHidden();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#isMaintainable()
	 */
	public boolean isMaintainable() {
		return m_proxy.getMaintainable();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#isVirtual()
	 */
	public boolean isVirtual() {
		return m_proxy.getVirtual();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#isReadonly()
	 */
	public boolean isReadonly() {
		return m_proxy.getReadonly();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getResourceTypes()
	 */
	public String[] getResourceTypes() {
		return m_proxy.getResourceTypes();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getMimeTypes()
	 */
	public String[] getMimeTypes() {
		return m_proxy.getMimeTypes();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getFolderPatterns()
	 */
	public String[] getFolderPatterns() {
		return m_proxy.getFolderPatterns();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getDocumentPatterns()
	 */
	public String[] getDocumentPatterns() {
		return m_proxy.getDocumentPatterns();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getAdditionalMetaTags()
	 */
	public String[] getAdditionalMetaTags() {
		return m_proxy.getAdditionalMetaTags();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getDefaultValue()
	 */
	public IPropMetaValue getDefaultValue() {
		return m_defaultValue;
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#isMultiValued()
	 */
	public boolean isMultiValued() {
		return m_proxy.getMultiValued();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#isModelled()
	 */
	public boolean isModelled() {
		return m_proxy.getModelled();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getDefaultSortmode()
	 */
	public int getDefaultSortmode() {
		return m_proxy.getDefaultSortmode();
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#getComposedOfMetaNames()
	 */
	public IPropMetaName[] getComposedOfMetaNames() {
		return m_composedOfNames;
	}

	/** @see com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName#hasDependencies()
	 */
	public boolean hasDependencies() {
		return false;
	}

	protected KMPropMetaName m_proxy;
	protected IPropMetaValue[] m_allowedValues;
	protected IPropMetaValue m_defaultValue;
	protected IPropMetaName[] m_composedOfNames;
}
