package com.sap.caf.km.ejb.svc.notifyqueue;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.ServiceException;

import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvc;
import com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvcService;
import com.sap.caf.km.proxies.svc.kmnotif.types.KMRecipient;
import com.sap.caf.km.proxies.svc.kmnotif.types.KMTemplate;
import com.sap.caf.km.proxies.svc.kmnotif.types.KMTemplateParam;
import com.sap.caf.rt.services.notify.notif.send.NotifMessage;
import com.sap.caf.rt.services.notify.notif.send.NotifRecipient;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Severity;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class NotifyQueueBean implements MessageDrivenBean, MessageListener, 
	IResourceKeys  
{
	private final static String PROP_PROXY_ENDPOINT = "javax.xml.rpc.service.endpoint.address";	

	private transient KMNotificationSvc m_proxy;

	private final static String JARM_REQUEST = "CAF:RT:oal:notifyqueue";

	private transient MessageDrivenContext m_msgContext;
	
	public void ejbCreate() {
		//TODO: Implement
	}
	
	/* (non-Javadoc)
	 * @see javax.ejb.MessageDrivenBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException {
		// TODO Auto-generated method stub

	}

	/**
	 * @see javax.ejb.MessageDrivenBean#setMessageDrivenContext(javax.ejb.MessageDrivenContext)
	 */
	public void setMessageDrivenContext(MessageDrivenContext context)	throws EJBException {
		m_msgContext = context;
	}

	/**
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 */
	public void onMessage(Message jmsMsg) {
		final String method = "onMessage(Message msg)";
		enter(method);
		try {
			NotifMessage notifMsg = (NotifMessage)((ObjectMessage)jmsMsg).getObject();
			KMNotificationSvc service = getNotifSvc();
			Calendar createdAt = Calendar.getInstance();
			createdAt.setTime(notifMsg.getCreatedAt()); 
			KMTemplate template = new KMTemplate();
			template.setId(notifMsg.getTemplateId());
			template.setParams(convertParams(notifMsg.getParameters()));
			template.setSubject(notifMsg.getSubject());
			service.notify(
					notifMsg.getOriginator(), 
					convertRecipients(notifMsg.getRecipients()), 
					template, 
					createdAt
				); 
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			NotifyQueueException ntfyEx = new NotifyQueueException(CANT_PROCESS_MSG, e); 
			log(ntfyEx, method);
		}
		finally {
			exit(method);
		}
	}

	private KMRecipient[] convertRecipients(Collection notifRecipients) {
		int size = notifRecipients.size();
		List recips = new ArrayList(size);
		NotifRecipient notifRecip;
		KMRecipient kmRecip;
		for(Iterator itr = notifRecipients.iterator(); itr.hasNext(); ) {
			notifRecip = (NotifRecipient)itr.next();
			kmRecip = new KMRecipient();
			kmRecip.setUserId(notifRecip.getUserId());
			kmRecip.setActionInboxEnabled(notifRecip.isActionInboxEnabled());
			recips.add(kmRecip);
		}
		return (KMRecipient[])recips.toArray(new KMRecipient[size]); 
	}

	private Collection resolveUniqUserIds(Collection userIds) throws UMException {
		IUserFactory userFactory = UMFactory.getUserFactory();
		List uniqIds = new ArrayList(userIds.size());
		String userId;
		IUser user;
		for(Iterator itr=userIds.iterator(); itr.hasNext(); ) {
			userId = (String)itr.next();
			
			try {
				user = userFactory.getUser(userId);
			} catch (UMException e) {
				user = userFactory.getUserByLogonID(userId);
			}
						
			uniqIds.add(user.getUniqueName());
		}
		return uniqIds;
	}

	/**
	 * @param params
	 * @return
	 */
	private KMTemplateParam[] convertParams(Map params) {
		List templParams = new ArrayList(params.size());
		if (params!=null && !params.isEmpty()) {
			Map.Entry entry;
			int i=0;
			Object key, value;
			KMTemplateParam templParam;
			for(Iterator itr=params.entrySet().iterator(); itr.hasNext(); i++) {
				entry = (Map.Entry)itr.next();
				key = entry.getKey();
				value = entry.getValue();
				if (!(key instanceof String && value instanceof String)) {
					continue;
				}
				templParam = new KMTemplateParam(); 
				templParam.setName((String)key);
				templParam.setValue((String)value);
				templParams.add(templParam);
			}
		}
		return (KMTemplateParam[])templParams.toArray(new KMTemplateParam[templParams.size()]);
	}

	private String[] convertUserIds(Collection userIds) {
		return (String[])userIds.toArray(new String[userIds.size()]);
	}

	private synchronized KMNotificationSvc getNotifSvc() throws NamingException, ServiceException {
		if (m_proxy==null) {
			Context context = new InitialContext();
			KMNotificationSvcService service = (KMNotificationSvcService)context.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMNotificationSvc");
			KMNotificationSvc proxy = (KMNotificationSvc) service.getLogicalPort(KMNotificationSvc.class);
			String url = ProxyHelper.getActualUrl((String)proxy._getProperty(PROP_PROXY_ENDPOINT));
			proxy._setProperty(PROP_PROXY_ENDPOINT, url);
			m_proxy = proxy;
		}
		return m_proxy;
	}
		
//	}
	
//	private methods

	private void exit(String method) {
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, CAFPublicLogger.LOC_CAF);
	}

	private void enter(String method) {
		CAFPublicLogger.entering(null, JARM_REQUEST, method, CAFPublicLogger.LOC_CAF);
	}

	private void log(NotifyQueueException e, String method) {
		CAFPublicLogger.logThrowable(Severity.ERROR, CAFPublicLogger.categoryCAF, method, e);
	}

}
