package com.sap.caf.km.ejb.svc.kmcoll.bean;


import java.util.Arrays;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;

import com.sap.caf.km.proxies.svc.kmcoll.KMCollaborationSvc;
import com.sap.caf.km.proxies.svc.kmcoll.KMCollaborationSvcService;
import com.sap.caf.km.proxies.svc.kmcoll.types.DiscussionItemHeader;
import com.sap.caf.km.proxies.svc.kmcoll.types.DiscussionRoomHeader;
import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.ejb.svc.kmcoll.DiscussionException;
import com.sap.caf.km.ejb.svc.kmcoll.DiscussionHeader;
import com.sap.caf.km.ejb.svc.kmcoll.ICollaborationResourceKeys;
import com.sap.caf.km.ejb.svc.kmcoll.RoomHeader;
import com.sap.caf.km.ejb.svc.kmcoll.TopicHeader;
import com.sap.tc.logging.Location;



/**
 * @ejbHome <{none}>
 * @ejbLocal <{com.sap.caf.km.ejb.svc.kmcoll.bean.CollaborationLocal}>
 * @ejbLocalHome <{com.sap.caf.km.ejb.svc.kmcoll.bean.CollaborationLocalHome}>
 * @ejbRemote <{none}>
 * @stateful
 *  
 */
public class CollaborationBean extends KMDataAccessBean implements ICollaborationResourceKeys {
	private transient Context m_initContext = null;
	private final static String JNDI_SERVICE_NAME = "wsclients/proxies/sap.com/caf~km.proxies/KMCollaborationJNDI";
	
	private transient KMCollaborationSvc m_wsColl = null;
	private transient KMCollaborationSvcService m_wsCollSvc = null;
	private transient InitialContext m_jndiContext = null;

	private static final String APPLICATION = CollaborationBean.class.getName();
	private static final String jARMReqPrefix = "CAF:RT:oal:"; 
	private static final String JARM_REQUEST =  jARMReqPrefix + APPLICATION;		
	private static final Location location = Location.getLocation(APPLICATION);
	
	/**
	 * Remove method
	 */
	public void ejbRemove() {
		m_initContext = null;
	}


	/**
	 * Create Method.   
	 */
	public void ejbCreate() throws CreateException {
		final String method = JARM_REQUEST + ":ejbCreate()";
		enter(method, null);
		if (m_jndiContext == null) {
			try {
				m_jndiContext = new InitialContext();
				m_wsCollSvc = (KMCollaborationSvcService) m_jndiContext.lookup(JNDI_SERVICE_NAME);
				m_wsColl = (KMCollaborationSvc) m_wsCollSvc.getLogicalPort(KMCollaborationSvc.class);
				String url = ProxyHelper.getActualUrl((String) m_wsColl._getProperty(KMCollaborationSvc.ENDPOINT_ADDRESS_PROPERTY));
				m_wsColl._setProperty(KMCollaborationSvc.ENDPOINT_ADDRESS_PROPERTY, url);
			}
			catch (Exception e) {
				DiscussionException discussEx = new DiscussionException(RES_CANT_CREATE_EJB, e);
				log(discussEx, method, null);
				throw new CreateException(discussEx.getLocalizedMessage());
			}
			finally {
				exit(method, null);
			}

		}
	}
	
	public String createDiscussion(String documentId, String parentFolder, String displayName) throws DiscussionException{
		final String method = JARM_REQUEST + ":createDiscussion(String, String, String)";
		enter(method, new Object[] {documentId, parentFolder, displayName});
		try {
			DiscussionItemHeader header = new DiscussionItemHeader();
			header.setId(documentId);
			header.setParentId(parentFolder);
			header.setName(displayName);
			return m_wsColl.createDiscussion(header);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void deleteDiscussion(String boID) throws DiscussionException{
		final String method = JARM_REQUEST + ":deleteDiscussion(String)";
		enter(method, new Object[] {boID});
		try{
			m_wsColl.deleteDiscussion(boID);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public DiscussionHeader findDiscussion(String rid) throws DiscussionException{
		final String method = JARM_REQUEST + ":findDiscussion(String)";
		enter(method, new Object[] {rid});
		try{
			return toDiscussion(m_wsColl.findDiscussion(rid));	
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public DiscussionHeader[] findByRoom(String roomId) throws DiscussionException{
		final String method = JARM_REQUEST + ":findByRoom(String)";
		enter(method, new Object[] {roomId});
		try{
			DiscussionHeader[] result = null;
			DiscussionItemHeader[] headers = m_wsColl.findRoomDiscussions(roomId);
			if 	(headers == null || headers.length < 1){
				return null;
			}
			result = new DiscussionHeader[headers.length];
			for (int i = 0; i < headers.length; i++){
				result[i] = toDiscussion(headers[i]);
			}
			return result;
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	
	public String addDiscussionTopic(String discussionRid, DiscussionItemHeader header) throws DiscussionException{
		final String method = JARM_REQUEST + ":addDiscussionTopic(String, DiscussionItemHeader)";
		enter(method, new Object[] {discussionRid, header});
		try{
			return m_wsColl.addTopic(discussionRid, header);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public String addChildTopic(String discussionRid, String topicRid, DiscussionItemHeader header) throws DiscussionException{
		final String method = JARM_REQUEST + ":addChildTopic(String, DiscussionItemHeader)";
		enter(method, new Object[] {discussionRid, header});
		try{
			return m_wsColl.addTopic(discussionRid, topicRid, header);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void removeDiscussionTopic(String discussionRid, String topicRid) throws DiscussionException{
		final String method = JARM_REQUEST + ":removeDiscussionTopic(String, String)";
		enter(method, new Object[] {discussionRid, topicRid});
		try{
			m_wsColl.removeTopic(discussionRid, topicRid);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void removeTopic(String discussionRid, String topicRid) throws DiscussionException{
		removeDiscussionTopic(discussionRid, topicRid);
	}

/* Discussion Topics*/
	public String createTopic(String discussionId, String parentFolder, String name, String subject, String text)
		throws DiscussionException{
			final String method = JARM_REQUEST + ":createTopic(String, String, String, String, String)";
			enter(method, new Object[] {discussionId, parentFolder, name, subject, text});
			try {	
		String result=null;	
		DiscussionItemHeader header = new DiscussionItemHeader();
		header.setDiscussion(discussionId);
		header.setParentId(parentFolder);
		header.setName(name);
		header.setSubject(subject);
		header.setText(text);
			return m_wsColl.createTopic(header);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
		
	public TopicHeader findTopic(String rid) throws DiscussionException{
		final String method = JARM_REQUEST + ":findTopic(String)";
		enter(method, new Object[] {rid});
		try{
			return toTopic(m_wsColl.findTopic(rid));
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	public TopicHeader[] findByDiscussion(String discussionId) throws DiscussionException{
		final String method = JARM_REQUEST + ":findByDiscussion(String)";
		enter(method, new Object[] {discussionId});
		try{
			TopicHeader[] result = null;
			DiscussionItemHeader[] header = m_wsColl.findDiscussionTopics(discussionId);
			if (header == null || header.length < 1){
				return null;
			}
			result = new TopicHeader[header.length];
			for (int i = 0; i < header.length; i ++){
				result[i] = toTopic(header[i]);
			}
			return result;		
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}

	
/* Discussion  ROOMS*/

	public RoomHeader createDiscussionRoom(String name, String description, Collection team, String relatedRid) throws DiscussionException{
		final String method = JARM_REQUEST + ":createDiscussionRoom(String, String, Collection)";
		enter(method, new Object[] {name, description, team});
		try{
			RoomHeader result = null;
			DiscussionRoomHeader header = new DiscussionRoomHeader();
			header.setTitle(name);
			header.setDescription(description);
			header.setRelatedRid(relatedRid);
			if (!team.isEmpty()){
				header.setTeam( (String[])team.toArray(new String[team.size()]) );
			} 
			DiscussionRoomHeader new_room = m_wsColl.createDiscussionRoom(header);
			return toRoom(new_room);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void deleteDiscussionRoom(String id) throws DiscussionException{
		final String method = JARM_REQUEST + ":deleteDiscussionRoom(String)";
		enter(method, new Object[] {id});
		try{
			m_wsColl.deleteDiscussionRoom(id);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public RoomHeader findDiscussionRoom(String id) throws DiscussionException{
		final String method = JARM_REQUEST + ":findDiscussionRoom(String)";
		enter(method, new Object[] {id});
		try{
			DiscussionRoomHeader header = null;
			header = m_wsColl.findDiscussionRoom(id);
			return toRoom(header);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public RoomHeader[] findByUser(String userId) throws DiscussionException{
		final String method = JARM_REQUEST + ":findByUser(String)";
		enter(method, new Object[] {userId});
		try{
			DiscussionRoomHeader[] ws_headers = null;
			ws_headers = m_wsColl.findRooms();
			if (ws_headers == null || ws_headers.length < 1){
				return null;
			} else {
				RoomHeader[] rooms = new RoomHeader[ws_headers.length];
				for (int i = 0; i < rooms.length; i++){
					rooms[i] = toRoom(ws_headers[i]);
				}				
				return rooms;
			}
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void assignUser(String roomId, String userId) throws DiscussionException{
		final String method = JARM_REQUEST + ":assignUser(String, String)";
		enter(method, new Object[] {roomId, userId});
		try{
			if (roomId != null && userId != null){
				m_wsColl.assignUser(roomId, userId);
			}
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void assignUsers(String roomId, Collection userIds) throws DiscussionException{
		final String method = JARM_REQUEST + ":assignUser(String, Collection)";
		enter(method, new Object[] {roomId, userIds});
		try{
			if (roomId != null && userIds != null){
				m_wsColl.assignUsers(roomId, (String[])userIds.toArray(new String[userIds.size()]));
			}
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void updateDiscussionRoom(String id, String title, String description, String relateObjectRid) throws DiscussionException {
		final String method = JARM_REQUEST + ":updateDiscussionRoom(String, String, String)";
		enter(method, new Object[] {id, title, description});
	  	DiscussionRoomHeader header = new DiscussionRoomHeader();
	  	header.setId(id);
	  	header.setTitle(title);
	  	header.setDescription(description);
		header.setRelatedRid(relateObjectRid);
		try {
		  	m_wsColl.updateDiscussionRoom(header);
		} catch (Exception e){
			DiscussionException discussEx = new DiscussionException(e); 
			log(discussEx, method, null);
			throw discussEx;
		}
	}
	
	public RoomHeader findRoomWithTodayPosts(String id) throws DiscussionException{
		final String method = JARM_REQUEST + ":findRoomWithTodayPosts(String)";
		enter(method, new Object[] {id});
		try {
			DiscussionRoomHeader header = null;
			header = m_wsColl.findRoomWithTodayPosts(id);
			return toRoom(header);
	  } catch (Exception e) {
		DiscussionException discussEx = new DiscussionException(e); 
		log(discussEx, method, null);
		throw discussEx;
	  }
	}
	
	private RoomHeader toRoom(DiscussionRoomHeader header){
		RoomHeader result = new RoomHeader();
		if (header.getCreatedAt() != null){
			result.setCreatedAt(header.getCreatedAt().getTime());
		}
		if (header.getLastChangedAt() != null){
			result.setLastChangedAt(header.getLastChangedAt().getTime());
		}
		result.setCreatedBy(header.getCreatedBy());
		result.setDescription(header.getDescription());
		result.setTitle(header.getTitle());
		result.setId(header.getId());
		result.setParentFolder("");
		result.setLastChangedBy(header.getLastChangedBy());
		result.setRelatedRid(header.getRelatedRid());
		
		if (header.getTeam() != null){
			result.setTeam(Arrays.asList(header.getTeam()));
		}
		if (header.getDiscussions() != null){
			result.setDiscussions(Arrays.asList(header.getDiscussions()));
		}
		result.setTodayPostsCount(header.getTodayPostsCount());
		return result;
	}
	
	private DiscussionHeader toDiscussion(DiscussionItemHeader header){
		DiscussionHeader result = new DiscussionHeader();
		if (header.getCreatedAt() != null){
			result.setCreatedAt(header.getCreatedAt().getTime());
		}
		
		if (header.getLastChangedAt() != null){
			result.setLastChangedAt(header.getLastChangedAt().getTime());
		}
				
		result.setCreatedBy(header.getCreatedBy());
		result.setSize(header.getSize());
		
		String id  = header.getId().substring(header.getId().lastIndexOf("/")+1); //without slash
		String parentFolder = header.getId().substring(0, header.getId().lastIndexOf("/"));
		result.setId(id);
		result.setParentFolder(parentFolder);
		result.setLastChangedBy(header.getLastChangedBy());
		if (header.getTopics() != null){
			result.setTopics(Arrays.asList(header.getTopics()));
		}
		return result;
		
	}

	private TopicHeader toTopic(DiscussionItemHeader header){
		TopicHeader result = new TopicHeader();
		if (header.getCreatedAt() != null){
			result.setCreatedAt(header.getCreatedAt().getTime());
		}
		if (header.getLastChangedAt() != null){
			result.setLastChangedAt(header.getLastChangedAt().getTime());
		}
		result.setCreatedBy(header.getCreatedBy());
		
		result.setLastChangedBy(header.getLastChangedBy());
		result.setName(header.getName());
		String id  = header.getId().substring(header.getId().lastIndexOf("/")+1); //without slash
		String parentFolder = header.getId().substring(0, header.getId().lastIndexOf("/"));

		result.setSize(header.getSize());
		result.setId(header.getId());
		result.setParentFolder(parentFolder);
		result.setDiscussion(header.getDiscussion());
		result.setSubject(header.getSubject());
		result.setText(header.getText());
		if (header.getTopics() != null){
			result.setTopics(Arrays.asList(header.getTopics()));			
		}
		return result;

		
	}
	
	protected Location getLocation() {
		return location;
	}

	protected String getJARMRequest() {
		return JARM_REQUEST;
	}
}
