/*
 * Created on Jul 4, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.util;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;

/**
 * @author viachaslau_kudzinau@epam.com
 * Implements cache for retrieving KM indexes list from EP side
 */
public class IndexCache implements IIndexCache, IConfigProps {

	/**
	 * Creates the new instance of IndexCache object
	 *  
	 * @param props instance of ConfigProps object to read properties 
	 */
	protected IndexCache(ConfigProps props) throws ConfigException {
		try {
			m_props = props;
			m_expireInterval = Integer.parseInt(m_props.getNotNullProperty(INDEX_CACHE_EXPIRE_INTERVAL)) * 60000;
			invalidate();
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			m_expireInterval = 30 * 60000;
		}
	}

	public static synchronized IndexCache getInstance() throws ConfigException {
		if (m_cache == null) {
			m_cache = new IndexCache(ConfigProps.getInstance());
		}
		return m_cache;
	}

	public boolean isValid() {
		return m_isValid && System.currentTimeMillis() < m_expireDate;
	}

	public void invalidate() {
		m_isValid = false;
	}

	public void setIndexes(IIndex[] indexes) {
		m_indexes = indexes;
		refresh();
	}

	public IIndex[] getIndexes() {
		return isValid() ? m_indexes : new IIndex[0];
	}

	protected void refresh() {
		m_expireDate = System.currentTimeMillis() + m_expireInterval;
		m_isValid = true;
	}

	protected static IndexCache m_cache;
	protected ConfigProps m_props;
	protected static long m_expireInterval;
	protected static long m_expireDate;
	protected static boolean m_isValid;
	protected static IIndex[] m_indexes;
}
