/*
 * Created on Jul 30, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.util;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class DbHelper {
	private static final com.sap.tc.logging.Location logger = com.sap.tc.logging.Location.getLocation(DbHelper.class);

	public DbHelper(ConnectionManager manager) {
		m_manager = manager;
	}

	protected BigDecimal getNextInSequence(Connection conn, int sequence) throws SQLException {
		synchronized (S_LOCK) {
			String method = "getNextInSequence(sequence)";
			logger.entering(method, new Object[] {String.valueOf(sequence)});
			try {
				ResultSet rs;
				BigDecimal nextVal;
				PreparedStatement pstmt;
				
				pstmt = conn.prepareStatement(IDbConst.INCREMENT_PK);
				try {
					pstmt.setInt(1, sequence);								
					pstmt.execute();
				} finally {
					pstmt.close();
				}
				pstmt = conn.prepareStatement(IDbConst.GET_PK);
				try {
					pstmt.setInt(1, sequence);
					rs = pstmt.executeQuery();
					nextVal = (rs.next()? rs.getBigDecimal(1): null);
				} finally {
					pstmt.close();
				} 
				if (nextVal==null) {
					pstmt = conn.prepareStatement(IDbConst.INIT_PK);
					try {
						pstmt.setInt(1, sequence);						
						pstmt.execute();
					}
					finally {
						pstmt.close();
					}
					pstmt = conn.prepareStatement(IDbConst.GET_PK);
					try {
						pstmt.setInt(1, sequence);
						rs = pstmt.executeQuery();
						nextVal = (rs.next()? rs.getBigDecimal(1): null);						
					}
					finally {
						pstmt.close();
					}
				}
				logger.debugT("Next sequence value:{0}", new Object[]{nextVal});
				return nextVal; 
			}
			finally {
				logger.exiting();
			}			
		}
	}
	
	protected ConnectionManager m_manager;
	private final static Object S_LOCK = new Object();
}
