/*
 * Created on Jun 27, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.util;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class ConnectionManager implements IConfigProps {

	protected ConnectionManager(ConfigProps props) {
		m_props = props;
	}
	public static synchronized ConnectionManager getInstance() throws ConfigException {
		if (s_manager==null) {
			s_manager = new ConnectionManager(ConfigProps.getInstance());
		}
		return s_manager;
	}

	protected synchronized DataSource getDataSource() throws SQLException {
		if (m_ds==null) {
			try {
				m_ds = (DataSource) m_props.getNotNullObject(JNDI_DATASOURCE);
			} catch (ConfigException e) {
				throw new SQLException("Could not get Data Source, cause:["+e.getMessage()+"]");
			}
		}
		return m_ds;
	}
	
	public Connection getConnection() throws SQLException {
		DataSource ds = getDataSource();
		Connection conn = ds.getConnection();
//		conn.setAutoCommit(false);
		return conn;
	}

	public Connection getAutoCommitedConnection() throws SQLException {
		DataSource ds = getDataSource();
		return ds.getConnection();
	}
	
	protected static ConnectionManager s_manager;
	protected ConfigProps m_props;
	protected DataSource m_ds;
}
