/*
 * Created on Jun 30, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.util;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;

import com.sap.caf.rt.bol.context.CAFProperties;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class ConfigProps implements IConfigProps {

	protected ConfigProps(Context context, Properties props) {
		m_props = props;
		m_context = context;
	}

	public synchronized static ConfigProps getInstance() throws ConfigException {
		if (s_config==null) {
			try {
				Context context = new InitialContext();
				CAFProperties cafProps = new CAFProperties();
				cafProps.loadApplicationProperties();
				Properties localProps = new Properties(cafProps);
				loadDefaults(localProps);
				s_config = new ConfigProps(context, localProps);
			} catch (Exception e) {
				throw new ConfigException("Could not create ConfigProps instance:["+e.getMessage()+"]");
			}
		}
		return s_config;
	}

	public String getNotNullProperty(String name) throws ConfigException {
		try {
			String value = m_props.getProperty(name);
			if (value==null) {
				throw new ConfigException("Property:["+name+"] is undefined!");
			}
			return value;
		} catch (ConfigException e) {
			throw e;
		} catch (Throwable e) {
			throw new ConfigException("Could not get property:["+name+"], cause:["+e.getMessage()+"]");
		}
	}
	
	public Object getNotNullObject(String name) throws ConfigException {
		try {
			Object value = m_context.lookup(name);
			if (value==null) {
				throw new ConfigException("Property:["+name+"] is undefined!");
			}
			return value;
		} catch (ConfigException e) {
			throw e;
		} catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			throw new ConfigException("Could not get property:["+name+"], cause:["+e.getMessage()+"]");
		}
	}
	
	protected static void loadDefaults(Properties props) {
		props.setProperty(SERVICE_CLASS_INDEX, "com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexSearchIndexSvc");
		props.setProperty(SERVICE_CLASS_CLASSIFY, "com.sap.caf.km.ejb.svc.idxsearch.classify.KMIndexSearchClassifySvc");
		props.setProperty(SERVICE_CLASS_SEARCH, "com.sap.caf.km.ejb.svc.idxsearch.search.KMIndexSearchSearchSvc");
		props.setProperty(SERVICE_LOOKUP_NAME, "wsclients/proxies/sap.com/caf~km.proxies/KMIndexSearchJNDI");
	}
	
	protected static ConfigProps s_config;
	protected Context m_context;
	protected Properties m_props;
}
