package com.sap.caf.km.ejb.svc.idxsearch.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.HashSet;
import java.util.Vector;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.bol.util.JDBCConnection;

/**
 * @author viachaslau_kudzinau
 */
public class KMSearchHelper {

	public KMSearchHelper() {
		// TODO Auto-generated constructor stub
	}

	public String[] getRelatedKMInstancesRids(String fullBOName)
		throws Exception {
		Collection col = getRelatedInstances(fullBOName);
		return (String[]) col.toArray(new String[col.size()]);
	}

	private Collection getRelatedInstances(String fullBOName)
		throws Exception {
		MetaModel mmr = new MetaModel();
		BusinessEntityInterface be = mmr.getDataObject(fullBOName).getBusinessEntityInterface();

		Collection attrCol = new HashSet();

		String sMasterTable =
			be.getBusinessEntity().getMasterTable().getTableName();

		List attrs = be.getBusinessEntity().getAttributes();
		Iterator itRelations = attrs.iterator();

		while(itRelations.hasNext()) {
			Attribute oap = (Attribute) itRelations.next();
			Object obj = oap.getReferencedObject();
			if (obj instanceof DataObject) {
				attrCol.add(oap);
			}
		}

		Iterator itAttr = attrCol.iterator();
		JDBCConnection conn = new JDBCConnection();
		ArrayList res = new ArrayList();
		try {
			while (itAttr.hasNext()) {
				Property attr = (Property) itAttr.next();
				Field field = (Field) attr.getField().iterator().next();
				String sTable = field.getTable().getTableName();
				String sql =
					"SELECT L.OBJECTKEY FROM "
						+ sTable
						+ " L, "
						+ sMasterTable
						+ " P WHERE P.OBJECTKEY = L.PARENTKEY";
				Collection rs = new Vector();
				rs = conn.selectColumn(sql, "OBJECTKEY");
				Object[] array = rs.toArray();
				for (int i = 0; i < array.length; i++) {
					sql =
						"SELECT PARENTFOLDER, DOCUMENTID FROM XAP_CAFCORE_DOC WHERE OBJECTKEY = '"
							+ array[i]+"'";
					Collection col = conn.selectColumn(sql, "PARENTFOLDER");
					if(col.iterator().hasNext()) {
						Collection c = conn.selectColumn(sql, "DOCUMENTID");
						if(c.iterator().hasNext()){
							res.add(col.iterator().next() + "/" + c.iterator().next());
						}
					}
				}
			}
		} finally {
			conn.close();
		}
		return res;
	}

	private static final int KM_BACKEND_TYPE = 3;
	private static final int KM_RELATED_MAX_LOOKUP_LEVEL = 0;
}
