package com.sap.caf.km.ejb.svc.idxsearch.search;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchSearchSvc;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.KMIndexSearchSvcProxyFactory;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;

public class KMIndexSearchSearchSvcFactory extends KMIndexSearchSvcProxyFactory implements IKMIndexSearchSearchSvcFactory {
	
	protected KMIndexSearchSearchSvcFactory(ConfigProps props) {
		super(props);
	}

	public static IKMIndexSearchSearchSvcFactory getInstance() throws ConfigException {
		return new KMIndexSearchSearchSvcFactory(ConfigProps.getInstance());
	}
	
	protected String getLookupName() throws ConfigException {
		return m_props.getNotNullProperty(IConfigProps.SERVICE_LOOKUP_NAME);
	}

	protected String getServiceClass() throws ConfigException {
		return m_props.getNotNullProperty(IConfigProps.SERVICE_CLASS_SEARCH);
	}

	public IIndexSearchSearchSvc getSearchService() throws ConfigException {
		return (IIndexSearchSearchSvc)getService();
	}

	public int getMaxSearchResults()  throws ConfigException {
		return Integer.parseInt(m_props.getNotNullProperty(IConfigProps.SEARCH_MAX_RESULTS_COUNT));
	}

}

