/*
 * Created on Jul 28, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.search;

import java.util.ArrayList;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchSearchSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchEntry;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchResult;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexSearchException;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchException;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.KMIndexSearchSvcProxy;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class KMIndexSearchSearchSvc extends KMIndexSearchSvcProxy implements IIndexSearchSearchSvc, IIndexSearchResourceKeys {

	public KMIndexSearchSearchSvc() throws IndexSearchException {
		super();
	}

	public ISearchResult[] searchForGlobalResource(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults)
		throws SearchException {
		try {
			return prepareResults(m_port.searchForGlobalResource(prepareEntries(queryEntryArray), indexIdArray, maxResults));
		}
		catch (Exception e) {
			throw new SearchException(ERR_SEARCH_GLOBAL, e);
		}
	}

	public ISearchResult[] searchForGlobalResource(
		ISearchEntry[] queryEntryArray,
		String[] indexIdArray,
		String searchStartFolder,
		int maxResults)
		throws SearchException {
		try {
			return prepareResults(
				m_port.searchForGlobalResource(prepareEntries(queryEntryArray), indexIdArray, searchStartFolder, maxResults));
		}
		catch (Exception e) {
			throw new SearchException(ERR_SEARCH_GLOBAL, e);
		}
	}

	public ISearchResult[] searchForBO(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults)
		throws SearchException {
		try {
			return prepareResults(m_port.searchForBO(prepareEntries(queryEntryArray), indexIdArray, maxResults));
		}
		catch (Exception e) {
			throw new SearchException(ERR_SEARCH_ALL_BO, e);
		}
	}

	public ISearchResult[] searchForSimilar(String resourceRid, String[] indexIdArray, int maxResults) throws SearchException {
		try {
			return prepareResults(m_port.searchForSimilar(resourceRid, indexIdArray, maxResults));
		}
		catch (Exception e) {
			throw new SearchException(ERR_SEARCH_SIMILAR, e);
		}
	}

	public ISearchResult[] searchForRelatedResource(
		ISearchEntry[] queryEntryArray,
		String[] indexIdArray,
		int resultType,
		int maxResults)
		throws SearchException {
		try {
			return prepareResults(
				m_port.searchForRelatedResource(prepareEntries(queryEntryArray), indexIdArray, resultType, maxResults));
		}
		catch (Exception e) {
			throw new SearchException(ERR_SEARCH_RELATED, e);
		}
	}

	public ISearchResult[] searchForBOInRelatedIndex(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults)
		throws SearchException {
		try {
			return prepareResults(m_port.searchForBOInRelatedIndex(prepareEntries(queryEntryArray), indexIdArray, maxResults));
		}
		catch (Exception e) {
			throw new SearchException(ERR_SEARCH_RELATED_BO, e);
		}
	}

	protected ISearchResult[] prepareResults(com.sap.caf.km.proxies.svc.idxsearch.types.IKMSearchResult[] source) {
		ArrayList results = new ArrayList();

		for (int i = 0; i < source.length; i++) {
			results.add(new KMSearchResultLocal(source[i]));
		}

		return (ISearchResult[]) results.toArray(new ISearchResult[results.size()]);
	}

	protected com.sap.caf.km.proxies.svc.idxsearch.types.IKMSearchEntry[] prepareEntries(ISearchEntry[] source) {
		ArrayList results = new ArrayList();

		com.sap.caf.km.proxies.svc.idxsearch.types.IKMSearchEntry entry;

		for (int i = 0; i < source.length; i++) {
			java.util.Calendar calendar = java.util.Calendar.getInstance();

			entry = new com.sap.caf.km.proxies.svc.idxsearch.types.IKMSearchEntry();

			entry.setTaxonomySearch(source[i].isTaxonomySearch());

			if (source[i].getValueAsString() != null) {
				entry.setValueAsString(source[i].getValueAsString());
			}

			entry.setValueAsInt(source[i].getValueAsInt());
			entry.setRangeValue1StAsInt(source[i].getRangeValue1stAsInt());
			entry.setRangeValue2NdAsInt(source[i].getRangeValue2ndAsInt());

			if (source[i].getValueAsDate() != null) {
				calendar.setTime(source[i].getValueAsDate());
				entry.setValueAsDate(calendar);
			}

			if (source[i].getRangeValue1stAsDate() != null) {
				calendar.setTime(source[i].getRangeValue1stAsDate());
				entry.setRangeValue1StAsDate(calendar);
			}

			if (source[i].getRangeValue2ndAsDate() != null) {
				calendar.setTime(source[i].getRangeValue2ndAsDate());
				entry.setRangeValue2NdAsDate(calendar);
			}

			if (source[i].getRowType() != null) {
				entry.setRowType(source[i].getRowType());
			}

			entry.setTermWeight(source[i].getTermWeight());
			entry.setTermAction(source[i].getTermAction());
			entry.setPropertyType(source[i].getPropertyType());

			if (source[i].getPropertyName() != null) {
				entry.setPropertyNamespace(source[i].getPropertyNamespace());
				entry.setPropertyName(source[i].getPropertyName());
				entry.setPropertyOperator(source[i].getPropertyOperator());
			}

			entry.setFuzziness(source[i].getFuzziness());
			entry.setValueType(source[i].getValueType());

			results.add(entry);
		}

		return (com.sap.caf.km.proxies.svc.idxsearch.types.IKMSearchEntry[]) results.toArray(
			new com.sap.caf.km.proxies.svc.idxsearch.types.IKMSearchEntry[results.size()]);
	}

}
