/*
 * Created on Jul 28, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.kmproxy;

import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public abstract class KMIndexSearchSvcProxyFactory implements IKMIndexSearchSvcProxyFactory {

	protected KMIndexSearchSvcProxyFactory(ConfigProps props) {
		m_props = props;
	}
	
	public synchronized IKMIndexSearchSvcProxy getService() throws ConfigException {
		if (m_service==null) {
			try {
				String sName = getLookupName();
				String sClass = getServiceClass();
				Class cl = Class.forName(sClass);
				m_service = (IKMIndexSearchSvcProxy) cl.newInstance();
				m_service.setLookupName(sName);
			} catch (ConfigException e) {
				throw e;
			} catch (Exception e) {
				throw new ConfigException("Could not create IKMIndexSearchSvcProxy instance, cause:["+e.toString()+"]");
			}
		}
		return m_service;
	}

	protected abstract String getLookupName() throws ConfigException;
	protected abstract String getServiceClass() throws ConfigException;
	 
	protected ConfigProps m_props;	
	protected IKMIndexSearchSvcProxy m_service;
}
