/*
 * Created on Jul 29, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.kmproxy;


import javax.naming.InitialContext;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexSearchException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.proxies.svc.idxsearch.KMIndexSearchSvcService;
import com.sap.caf.km.ejb.data.util.ProxyHelper;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class KMIndexSearchSvcProxy implements IKMIndexSearchSvcProxy, IIndexSearchResourceKeys {

	public KMIndexSearchSvcProxy() throws IndexSearchException {
		try {
			InitialContext context = new InitialContext();
			KMIndexSearchSvcService service = (KMIndexSearchSvcService) context.lookup(m_sJNDIName);
			m_port = (com.sap.caf.km.proxies.svc.idxsearch.KMIndexSearchSvc) 
				service.getLogicalPort(com.sap.caf.km.proxies.svc.idxsearch.KMIndexSearchSvc.class);
			// substitute real host:port instead of template names
			String url = ProxyHelper.getActualUrl((String)m_port._getProperty(com.sap.caf.km.proxies.svc.idxsearch.KMIndexSearchSvc.ENDPOINT_ADDRESS_PROPERTY));
			m_port._setProperty(com.sap.caf.km.proxies.svc.idxsearch.KMIndexSearchSvc.ENDPOINT_ADDRESS_PROPERTY, url);
		} catch (Exception e) { 
			throw new IndexSearchException(ERR_PROXY_GET_INSTANCE, e);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.kmproxy.IKMIndexSearchSvcProxy#setServiceUrl(java.lang.String)
	 */
	public void setLookupName(String name) throws ConfigException {
		m_sJNDIName = name;
	}

	protected com.sap.caf.km.proxies.svc.idxsearch.KMIndexSearchSvc m_port;
	protected String m_sJNDIName = "wsclients/proxies/sap.com/caf~km.proxies/KMIndexSearchJNDI";
}
