/*
 * Created on Jun 26, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.index;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessException;
import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessor;
import com.sap.caf.km.ejb.svc.idxsearch.util.*;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public final class KMIndexUtil implements IConfigProps {

	/**
	 * Gets ID of the index correcponding to CAF BO type name
	 * 
	 * @param BOName	CAF BO type name
	 * @return	Id of the index corresponding to CAF BO type  
	 */
	public static String getIndexId(String BOName) throws ConfigException, RemoteException, NamingException {
		synchronized (m_indexes) {
			String sId = (String) m_indexes.get(BOName);
			if (sId == null) {
				sId = generateIndexId(BOName, IDX_TYPE_PROPER);

				m_indexes.put(BOName, sId);
			}
			return sId;
		}
	}

	public static String getRelatedIndexId(String BOName) throws RemoteException, ConfigException, NamingException {
		synchronized (m_globalIndexes) {
			String sId = (String) m_globalIndexes.get(BOName);
			if (sId == null) {
				sId = generateIndexId(BOName, IDX_TYPE_RELATED);
				m_globalIndexes.put(BOName, sId);
			}
			return sId;
		}
	}

	private static String generateIndexId(String BOName, int idxType)
		throws ConfigException, RemoteException, NamingException {
		ConfigProps props = ConfigProps.getInstance();

		String prefix = props.getNotNullProperty(INDEX_PREFIX);
		String suffix = idxType == IDX_TYPE_PROPER ? props.getNotNullProperty(INDEX_SUFFIX) : props.getNotNullProperty(INDEX_SUFFIX_RELATED);
		String delimeter = props.getNotNullProperty(INDEX_DELIMETER);

		String id =
			new StringBuffer(prefix.length() + suffix.length() + BOName.length() +  delimeter.length() * 2)
				.append(prefix)
				.append(delimeter)
				.append(convertBONameForKM(BOName))
				.append(delimeter)
				.append(suffix)
				.toString();

		return id;
	}
	/**
	 * Gets Root folder RID for CAF BO type 
	 * @param BOName	CAF BO type name
	 * @return	Root folder RID for CAF BO type 
	 */
	public static String getFolderRID(String BOName) throws ConfigException, BOAccessException {
		synchronized (m_folders) {
			String sFolder = (String) m_folders.get(BOName);
			if (sFolder == null) {
				ConfigProps props = ConfigProps.getInstance();
				BOAccessor access = BOAccessor.getInstance();
				sFolder = props.getNotNullProperty(XAPPS_REPOSITORY_NAME) + "/" + access.getGUID(BOName);
				m_folders.put(BOName, sFolder);
			}
			return sFolder;
		}
	}

	public static String getBOGuid(String sBORid) {
		if (sBORid == null || sBORid.length() == 0) {
			return null;
		}
		int keyPos = sBORid.lastIndexOf('/');
		if (keyPos == -1) {
			return null;
		}
		keyPos += 2;
		if (sBORid.length() <= keyPos) {
			return null;
		}
		return sBORid.substring(keyPos);
	}

	public static Object getBOTypeGuid(String sBORid) {
		if (sBORid == null || sBORid.length() < 2) {
			return null;
		}
		int i = sBORid.indexOf('/', 1);
		if (i == -1) {
			return null;
		}
		int j = sBORid.indexOf('/', ++i);
		if (j == -1) {
			return null;
		}
		return sBORid.subSequence(i, j);
	}

	/**
	 * Replace BOName symbols not allowed by TREX for index name creation
	 * 
	 * @param sBOName
	 * @return
	 */
	protected static String convertBONameForKM(String sBOName) throws ConfigException {
		ConfigProps props = ConfigProps.getInstance();
		String sDelimeter = props.getNotNullProperty(INDEX_DELIMETER);

		char[] chars = sBOName.toCharArray();
		int len = FORBIDDEN_CHARS.length;
		for (int i = chars.length; --i >= 0;) {
			for (int j = len; --j >= 0;) {
				if (chars[i] == FORBIDDEN_CHARS[j]) {
					chars[i] = sDelimeter.charAt(0);
					break;
				}
			}
		}
		return new String(chars);
	}

	private static Properties s_props;
	protected static Map m_indexes = new HashMap();
	protected static Map m_globalIndexes = new HashMap();
	protected static Map m_folders = new HashMap();
	
	private static int IDX_TYPE_PROPER = 1;
	private static int IDX_TYPE_RELATED = 2;

	public static final char[] FORBIDDEN_CHARS = { '/', '.', ':', '\\', '"', '\'' };
}
