/*
 * Created on 25.06.2003
 * 
 */
package com.sap.caf.km.ejb.svc.idxsearch.index;

import java.util.ArrayList;
import java.util.Date; 

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchIndexSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexException;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.IKMIndexSearchSvcProxy;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;

/**
 * @author Vadzim_Karacharski@epam.com 
 */
public class KMIndexSearchIndexSvcStub implements IKMIndexSearchSvcProxy, IIndexSearchIndexSvc, IIndexSearchResourceKeys {


	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#existsIndex(java.lang.String) 
	 */
	public boolean existsIndex(String indexId) throws IndexException {
		try {
			KMIndexStub item = null;
			for (int i=0; i<m_indexes.size(); i++) {
				item = (KMIndexStub)m_indexes.get(i);
				if (indexId.equals(item.getName())) {
					return true;
				}
			}
			return false;	
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_CHECK, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#getIndex(java.lang.String)
	 */
	public IIndex getIndex(String indexId) throws IndexException {
		try {
			KMIndexStub item = null;
			for (int i=0; i<m_indexes.size(); i++) {
				item = (KMIndexStub)m_indexes.get(i);
				if (indexId.equals(item.getName())) {
					return item;
				}
			}
			throw new IndexException(ERR_IDX_NOT_EXISTS, new Object[] {indexId});
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_GET, new Object[] {indexId}, e);
		}
	}

	/** 
	 * @see com.sap.xapps.fw.km.IKMIndexSearchSvc#getIndex(java.lang.String)
	 */
	public void clearIndex(String indexId) throws IndexException {
	}

	/** 
	 * @see com.sap.xapps.fw.km.IKMIndexSearchSvc#getAllIndexes()
	 */
	public IIndex[] getAllIndexes() throws IndexException {
		try {
			return (IIndex[]) m_indexes.toArray(new IIndex[m_indexes.size()]);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_GET_ALL, null, e);
		}
	}


	/** 
	 * @see com.sap.xapps.fw.km.IKMIndexSearchSvc#createDocumentIndex(java.lang.String, java.lang.String[])
	 */
	public void createRelatedIndex(String indexId, String mofId) throws IndexException {
//		Commented out due to deprecation parseIndexId() method		
//		try {
//			if (existsIndex(indexId)) {
//				throw new IndexException("Specified index already exists ["+indexId+"]");
//			}
//			m_indexes.add(new KMIndexStub(indexId, new Date(), KMIndexUtil.parseIndexId(indexId), KMIndexStub.TYPE_CAF_BO_RELATED));
//		} catch (Exception e) {
//				throw new IndexException("Could not create related index", e);
//		}
	}

	
	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#createFolderIndex(java.lang.String, java.lang.String[])
	 */
	public void createFolderIndex(String indexId, String[] folderRids) throws IndexException {
// Commented out due to deprecation parseIndexId() method		
//		try {
//			if (existsIndex(indexId)) {
//				throw new IndexException("Specified index already exists ["+indexId+"]");
//			}
//			m_indexes.add(new KMIndexStub(indexId, new Date(), KMIndexUtil.parseIndexId(indexId), KMIndexStub.TYPE_CAF_BO_OWN));
//		} catch (Exception e) {
//				throw new IndexException("Could not create folder index", e);
//		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#deleteIndex(java.lang.String)
	 */
	public void deleteIndex(String indexId) throws IndexException {
		try {
			m_indexes.remove((KMIndexStub)getIndex(indexId));
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_DELETE, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#indexObjects(java.lang.String, java.lang.String[])
	 */
	public void indexObjects(String indexId, String[] objectsRids) throws IndexException {
//		Commented out due to deprecation parseIndexId() method		
//		try {
//			if (existsIndex(indexId)) {
//				throw new IndexException("Specified index already exists ["+indexId+"]");
//			}
//			m_indexes.add(new KMIndexStub(indexId, new Date(), KMIndexUtil.parseIndexId(indexId), KMIndexStub.TYPE_KM_BO_GLOBAL));
//		} catch (Exception e) {
//			throw new IndexException("Could not index objects", e);
//		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#deindexObjects(java.lang.String, java.lang.String[])
	 */
	public void deindexObjects(String indexId, String[] objectsRids) throws IndexException {
		try {
			reindex(indexId);		
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_OBJ_DELETE, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#reindex(java.lang.String)
	 */
	public void reindex(String indexId) throws IndexException {
		try {
			KMIndexStub index = (KMIndexStub)getIndex(indexId);
			index.setCreationDate(new Date());
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_REINDEX, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#reindexRelatedIndex(java.lang.String)
	 */
	public void reindexRelatedIndex(String indexId, String mofId) throws IndexException {
		try {
			KMIndexStub index = (KMIndexStub)getIndex(indexId);
			index.setCreationDate(new Date());
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_REINDEX, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#reindex(java.lang.String)
	 */
	public void reindexRelatedTasks(String indexId) throws IndexException {
		try {
			KMIndexStub index = (KMIndexStub)getIndex(indexId);
			index.setCreationDate(new Date());
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_REINDEX, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#reindex(java.lang.String)
	 */
	public void reindexRelatedDocuments(String indexId) throws IndexException {
		try {
			KMIndexStub index = (KMIndexStub)getIndex(indexId);
			index.setCreationDate(new Date());
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_REINDEX, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#deltaReindex(java.lang.String)
	 */
	public void deltaReindex(String indexId) throws IndexException {
		try {
			reindex(indexId);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_REINDEX, new Object[] {indexId}, e);
		}
	}
	 
	public IIndex[] getGlobalIndexesKMBO(String[] kmtypes) {
		return (IIndex[]) m_GlobalIndexes.toArray(new IIndex[2]);
	}
	
	/** @see com.sap.caf.km.ejb.svc.idxsearch.kmproxy.IKMIndexSearchSvcProxy#setServiceUrl(java.lang.String)
	 */
	public void setLookupName(String sUrl) throws ConfigException {
	}
	
	protected static ArrayList m_indexes = new ArrayList();
	protected static ArrayList m_GlobalIndexes = new ArrayList();
	
	static {
//	m_indexes.add(new KMIndexStub("CAF-Insight-index", new Date(), "Insight", KMIndexStub.TYPE_CAF_BO_OWN, KMIndexStub.STATE_IDLE));
//	m_indexes.add(new KMIndexStub("CAF-Insight-index-related", new Date(), "Insight", KMIndexStub.TYPE_CAF_BO_RELATED, KMIndexStub.STATE_IDLE));
	m_indexes.add(new KMIndexStub("Global-Task", new Date(), "", KMIndexStub.TYPE_KM_BO_GLOBAL, KMIndexStub.STATE_IDLE));
	m_indexes.add(new KMIndexStub("Free index 1", new Date(), "", KMIndexStub.TYPE_KM_BO_GLOBAL, KMIndexStub.STATE_IDLE));
	m_indexes.add(new KMIndexStub("Free index 2", new Date(), "", KMIndexStub.TYPE_KM_BO_GLOBAL, KMIndexStub.STATE_IDLE));
	m_indexes.add(new KMIndexStub("Free index 3", new Date(), "", KMIndexStub.TYPE_KM_BO_GLOBAL, KMIndexStub.STATE_IDLE));
	m_indexes.add(new KMIndexStub("Free index 4", new Date(), "", KMIndexStub.TYPE_KM_BO_GLOBAL, KMIndexStub.STATE_IDLE));
    
    
//	m_GlobalIndexes.add(new KMIndexStub("Global-Task", new Date(), "Task", KMIndexStub.TYPE_KM_BO_GLOBAL, KMIndexStub.STATE_IDLE));
	}
}
