/*
 * Created on Jun 25, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.index;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchIndexSvc;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.KMIndexSearchSvcProxyFactory;
import com.sap.caf.km.ejb.svc.idxsearch.util.*;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class KMIndexSearchIndexSvcFactory extends KMIndexSearchSvcProxyFactory implements IKMIndexSearchIndexSvcFactory {

	protected KMIndexSearchIndexSvcFactory(ConfigProps props) {
		super(props); 
	}
	
	public static IKMIndexSearchIndexSvcFactory getInstance() throws ConfigException {
		return new KMIndexSearchIndexSvcFactory(ConfigProps.getInstance());
	}
	
	public IIndexSearchIndexSvc getIndexService() throws ConfigException {
		return (IIndexSearchIndexSvc)getService();
	}

	protected String getLookupName() throws ConfigException {
		return m_props.getNotNullProperty(IConfigProps.SERVICE_LOOKUP_NAME);
	}

	protected String getServiceClass() throws ConfigException {
		return m_props.getNotNullProperty(IConfigProps.SERVICE_CLASS_INDEX);
	}

}
