/*
 * Created on Jun 25, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.index;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchIndexSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexException;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexSearchException;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.KMIndexSearchSvcProxy;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class KMIndexSearchIndexSvc extends KMIndexSearchSvcProxy implements IIndexSearchIndexSvc, IIndexSearchResourceKeys {

	public KMIndexSearchIndexSvc() throws IndexSearchException {
		super(); 
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#existsIndex(java.lang.String) 
	 */
	public boolean existsIndex(String indexId) throws IndexException {
		try {
			return m_port.existsIndex(indexId);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_CHECK, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#getIndex(java.lang.String)
	 */
	public IIndex getIndex(String indexId) throws IndexException {
		try {
			com.sap.caf.km.proxies.svc.idxsearch.types.IKMIndex index = m_port.getIndex(indexId);
			return new KMIndex(index.getName(), index.getState());
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_GET, new Object[] {indexId}, e);
		}
	}
	
	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#getIndex(java.lang.String)
	 */
	public void clearIndex(String indexId) throws IndexException {
		try {
			m_port.clearIndex(indexId);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_GET, new Object[] {indexId}, e);
		}
	}
	

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#getAllIndexes()
	 */
	public IIndex[] getAllIndexes() throws IndexException {
		try {
			com.sap.caf.km.proxies.svc.idxsearch.types.IKMIndex[] stubs =	m_port.getAllIndexes();
			IIndex[] locals = new IIndex[stubs.length];
			for(int i = 0; i < stubs.length; i++) {
				locals[i] = new KMIndex(stubs[i].getName(), stubs[i].getState()); 
			}
			return locals;
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_GET_ALL, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#createFolderIndex(java.lang.String, java.lang.String[])
	 */
	public void createFolderIndex(String indexId, String[] folderRids)
		throws IndexException {
			try {
				m_port.createFolderIndex(indexId, folderRids);
			} catch (Exception e) {
				throw new IndexException(ERR_IDX_CREATE, new Object[] {indexId}, e);
			}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#deleteIndex(java.lang.String)
	 */
	public void deleteIndex(String indexId) throws IndexException {
		try {
			m_port.deleteIndex(indexId);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_DELETE, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#indexObjects(java.lang.String, java.lang.String[])
	 */
	public void indexObjects(String indexId, String[] objectsRids)
		throws IndexException {
		try {
			m_port.indexObjects(indexId, objectsRids);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_OBJ_CREATE, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#deindexObjects(java.lang.String, java.lang.String[])
	 */
	public void deindexObjects(String indexId, String[] objectsRids)
		throws IndexException {
		try {
			m_port.deindexObjects(indexId, objectsRids);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_OBJ_DELETE, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#reindex(java.lang.String)
	 */
	public void reindex(String indexId) throws IndexException {
		try {
			m_port.reindex(indexId);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_REINDEX, new Object[] {indexId}, e);
		}
	}

	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#reindexRelatedIndex(java.lang.String)
	 */
	public void reindexRelatedIndex(String indexId, String mofId) throws IndexException {
		try {
			m_port.reindexRelatedIndex(indexId, mofId);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_REINDEX, new Object[] {indexId}, e);
		}
	}
	
	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#createRelatedIndex(java.lang.String)
	 */
	public void createRelatedIndex(String indexId, String mofId)
		throws IndexException {
			try {
				m_port.createRelatedIndex(indexId, mofId);
			} catch (Exception e) {
				throw new IndexException(ERR_IDX_CREATE, new Object[] {indexId}, e);
			}
	}


	/** @see com.sap.xapps.fw.km.IKMIndexSearchSvc#deltaReindex(java.lang.String)
	 */
	public void deltaReindex(String indexId) throws IndexException {
		try {
			m_port.deltaReindex(indexId);
		} catch (Exception e) {
			throw new IndexException(ERR_IDX_REINDEX, new Object[] {indexId}, e);
		}
	}
}
