package com.sap.caf.km.ejb.svc.idxsearch.common;

import java.io.Serializable;
import java.util.Date;

/**
 * The class presents KM classification taxonomy.
 * 
 * @author viachaslau_kudzinau@epam.com
 */
public class Taxonomy extends ClassifyFolder implements ITaxonomy, Serializable {

	/** 
	 * @param name	The taxonomy name
	 * @param rid	The taxonomy RID
	 * @param created	The taxonomy creation date
	 */
	public Taxonomy(String name, String rid, Date created) {
		super(name, created);
		setRID(rid);
	}

	/** 
	 * @param name	The taxonomy name
	 * @param rid	The taxonomy RID
	 * @param created	The taxonomy creation date
	 */
	public Taxonomy(String sTaxonomyRepositoryPrefix, String sIndexId, String sTaxonomyName) {
		StringBuffer sb = new StringBuffer(64);
		if (!sTaxonomyRepositoryPrefix.startsWith(String.valueOf(NAME_DELIMETER))) {
			sb.append(NAME_DELIMETER);	
		}
		sb.append(sTaxonomyRepositoryPrefix).append(NAME_DELIMETER)
			.append(sIndexId).append(NAME_DELIMETER)
			.append(sTaxonomyName).append(NAME_DELIMETER);
		setRID(sb.toString());
	}

	/**  
	 * @param sRid	 The classification folder RID
	 */
	public Taxonomy(String sRid) {
		super(sRid);
	}
		
	/** 
	 * @see com.sap.caf.km.idxsearch.IKMTaxonomy#getSpecialFolderRID(int)
	 */
	public String getSpecialFolderRID(int folderType) {
		return m_specialRids[folderType];
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMTaxonomy#setSpecialFolderRID(int, java.lang.String)
	 */
	public void setSpecialFolderRID(int folderType, String folderRid) {
		m_specialRids[folderType] = folderRid;
	}
	
	/**
	 * The special folders' RIDs
	 */
	protected String[] m_specialRids = new String[2];
}
