package com.sap.caf.km.ejb.svc.idxsearch.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import sun.security.action.GetLongAction;

import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Severity;

/** 
 * The interface defines operands, options and operations for search condition. <br>
 * Notes: <br> 
 * Two functions to define the taxonomy search are added to the methods of the 
 * KM interface IQueryEntry. The rest is identical except some unimportant methods
 *
 * @author aliaksandr_pranko@epam.com  
 */
public class SearchEntry implements ISearchEntry, Serializable {
	
	public static Collection createSearchEntry(QueryFilter filter, String boName) {
		String method ="createSearchEntry(QueryFilter filter, String boName)";
		Collection col = new ArrayList();
		ISearchEntry entry = new SearchEntry();
		
		if((filter.operation.equals(QueryFilter.OPERATION_ATTRIBUTE)) || 
					(filter.operation.equals(QueryFilter.OPERATION_CATEGORY))) {
			
			if(filter.operation.equals(QueryFilter.OPERATION_ATTRIBUTE)) {
				if(filter.attribute.equals("*")) {
					try {
						MetaModel model = new MetaModel();
						Iterator it = model.getAttributes(boName, String.class).iterator();
						
						col.addAll(SearchEntry.createSearchEntry(QueryFilter.createBracket(QueryFilter.OPERATION_BRACKET_OPEN),boName));
						
						while(it.hasNext()) {
							col.addAll(SearchEntry.createSearchEntry(QueryFilter.createStringFilter(
													filter.action, filter.valueLow, (String)it.next(), true), boName));
							
							if(it.hasNext()) {
								col.addAll(SearchEntry.createSearchEntry(QueryFilter.createBracket(QueryFilter.OPERATION_OR),boName));
							}								
						}						
						col.addAll(SearchEntry.createSearchEntry(QueryFilter.createBracket(QueryFilter.OPERATION_BRACKET_CLOSE),boName));
						
						return col;						
					}
					catch(Exception e) {
						CAFPublicLogger.logThrowable(Severity.ERROR, CAFPublicLogger.categoryCAF, method, e);
					}					
				}
				//some attributes are mapped to predefined properties in km
				else if(filter.attribute.equals("createdBy")) {
					entry.setPropertyNamespace("http://sapportals.com/xmlns/cm");
					entry.setPropertyName("createdby");
				}
				else if(filter.attribute.equals("createdAt")) {
					entry.setPropertyNamespace("http://sapportals.com/xmlns/cm");
					entry.setPropertyName("created");
				}
				else if(filter.attribute.equals("lastChangedBy")) {
					entry.setPropertyNamespace("http://sapportals.com/xmlns/cm");
					entry.setPropertyName("modifiedby");
				}
				else if(filter.attribute.equals("lastChangedAt")) {
					entry.setPropertyNamespace("http://sapportals.com/xmlns/cm");
					entry.setPropertyName("modified");
				}
				//the others get it own namespace
				else {
					entry.setPropertyNamespace("http://sap.com/caf/attributes");
					entry.setPropertyName(filter.attribute);
				}			
			}
			else {
				entry.setPropertyNamespace("http://sap.com/caf/categories");
				entry.setPropertyName(filter.attribute);
			}

			entry.setRowType(ISearchEntry.ROW_TYPE_ATTRIBUTE);		

			if(filter.datatype.equals(QueryFilter.DATATYPE_STRING))	{
				entry.setPropertyType(ISearchEntry.PROPERTY_TYPE_STRING);
				entry.setValueAsString(filter.valueLow);
				entry.setValueType(ISearchEntry.VALUE_TYPE_STRING);
			
			
				if(filter.action.equals(QueryFilter.ACTION_LINGUISTIC)) {
					entry.setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
				}
				else if(filter.action.equals(QueryFilter.ACTION_EXACT)) {
					entry.setTermAction(ISearchEntry.TERM_ACTION_EXACT);
				}
				entry.setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
				entry.setTermWeight(1.0F);
			}
			else if(filter.datatype.equals(QueryFilter.DATATYPE_INT)) {
				if(filter.condition.equals(QueryFilter.CONDITION_EQ))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_LT))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_LESS);
				if(filter.condition.equals(QueryFilter.CONDITION_GT))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_GREATER);
				if(filter.condition.equals(QueryFilter.CONDITION_GE))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_GREATER_OR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_LE))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_LESS_OR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_NOT))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_NOT);
					
				entry.setPropertyType(ISearchEntry.PROPERTY_TYPE_INTEGER);
				entry.setValueAsInt(filter.intValueLow);
				entry.setValueType(ISearchEntry.VALUE_TYPE_INT);				
			}
			else if(filter.datatype.equals(QueryFilter.DATATYPE_DATE)) {
				if(filter.condition.equals(QueryFilter.CONDITION_EQ))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_LT))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_LESS);
				if(filter.condition.equals(QueryFilter.CONDITION_GT))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_GREATER);
				if(filter.condition.equals(QueryFilter.CONDITION_GE))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_GREATER_OR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_LE))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_LESS_OR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_NOT))
					entry.setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_NOT);
				
				entry.setPropertyType(ISearchEntry.PROPERTY_TYPE_DATE);
				entry.setValueAsDate(filter.dateValueLow);
				entry.setValueType(ISearchEntry.VALUE_TYPE_DATE);							
			}
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_TERM)) {
			entry.setValueAsString(filter.valueLow);
			entry.setValueType(ISearchEntry.VALUE_TYPE_STRING);
			entry.setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
			entry.setTermWeight(1.0F);
			entry.setRowType(ISearchEntry.ROW_TYPE_TERM);			
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_BRACKET_OPEN)) {
			entry.setRowType(ISearchEntry.ROW_TYPE_BRACKET_OPEN);			
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_BRACKET_CLOSE)) {
			entry.setRowType(ISearchEntry.ROW_TYPE_BRACKET_CLOSE);			
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_AND)) {
			entry.setRowType(ISearchEntry.ROW_TYPE_OPERATOR);
			entry.setValueAsString(ISearchEntry.OPERATOR_AND);
			entry.setValueType(ISearchEntry.VALUE_TYPE_STRING);
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_OR)) {
			entry.setRowType(ISearchEntry.ROW_TYPE_OPERATOR);
			entry.setValueAsString(ISearchEntry.OPERATOR_OR);
			entry.setValueType(ISearchEntry.VALUE_TYPE_STRING);
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_NOT)) {
			entry.setRowType(ISearchEntry.ROW_TYPE_OPERATOR);
			entry.setValueAsString(ISearchEntry.OPERATOR_NOT);
			entry.setValueType(ISearchEntry.VALUE_TYPE_STRING);
		}	
		col.add(entry);
		
		return col;	
	}
	
	/*public SearchEntry(QueryFilter filter, String boName) {
		if((filter.operation.equals(QueryFilter.OPERATION_ATTRIBUTE)) || 
					(filter.operation.equals(QueryFilter.OPERATION_CATEGORY))) {
			
			if(filter.operation.equals(QueryFilter.OPERATION_ATTRIBUTE)) {
				if(filter.attribute.equals("*")) {
					try {
						MetaModel model = new MetaModel();
						ShareableObject so = model.getShareableObject(boName);
						if(so!=null) {
							Iterator it = so.getAttributes().iterator();
							while(it.hasNext()) {	
							}
						}							
					}
					catch(Exception e) {
						
					}					
				}
				//some attributes are mapped to predefined properties in km
				if(filter.attribute.equals("createdBy")) {
					setPropertyNamespace("http://sapportals.com/xmlns/cm");
					setPropertyName("createdby");
				}
				else if(filter.attribute.equals("createdAt")) {
					setPropertyNamespace("http://sapportals.com/xmlns/cm");
					setPropertyName("created");
				}
				else if(filter.attribute.equals("lastChangedBy")) {
					setPropertyNamespace("http://sapportals.com/xmlns/cm");
					setPropertyName("modifiedby");
				}
				else if(filter.attribute.equals("lastChangedAt")) {
					setPropertyNamespace("http://sapportals.com/xmlns/cm");
					setPropertyName("modified");
				}
				//the others get it own namespace
				else {
					setPropertyNamespace("http://sap.com/caf/attributes");
					setPropertyName(filter.attribute);
				}			
			}
			else {
				setPropertyNamespace("http://sap.com/caf/categories");
				setPropertyName(filter.attribute);
			}

			setRowType(ISearchEntry.ROW_TYPE_ATTRIBUTE);		

			if(filter.datatype.equals(QueryFilter.DATATYPE_STRING))	{
				setPropertyType(ISearchEntry.PROPERTY_TYPE_STRING);
				setValueAsString(filter.valueLow);
				setValueType(ISearchEntry.VALUE_TYPE_STRING);
			
			
				if(filter.action.equals(QueryFilter.ACTION_LINGUISTIC)) {
					setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
				}
				else if(filter.action.equals(QueryFilter.ACTION_EXACT)) {
					setTermAction(ISearchEntry.TERM_ACTION_EXACT);
				}
				setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
				setTermWeight(1.0F);
			}
			else if(filter.datatype.equals(QueryFilter.DATATYPE_INT)) {
				if(filter.condition.equals(QueryFilter.CONDITION_EQ))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_LT))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_LESS);
				if(filter.condition.equals(QueryFilter.CONDITION_GT))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_GREATER);
				if(filter.condition.equals(QueryFilter.CONDITION_GE))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_GREATER_OR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_LE))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_LESS_OR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_NOT))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_NOT);
					
				setPropertyType(ISearchEntry.PROPERTY_TYPE_INTEGER);
				setValueAsInt(filter.intValueLow);
				setValueType(ISearchEntry.VALUE_TYPE_INT);				
			}
			else if(filter.datatype.equals(QueryFilter.DATATYPE_DATE)) {
				if(filter.condition.equals(QueryFilter.CONDITION_EQ))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_LT))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_LESS);
				if(filter.condition.equals(QueryFilter.CONDITION_GT))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_GREATER);
				if(filter.condition.equals(QueryFilter.CONDITION_GE))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_GREATER_OR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_LE))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_LESS_OR_EQUAL);
				if(filter.condition.equals(QueryFilter.CONDITION_NOT))
					setPropertyOperator(ISearchEntry.PROPERTY_OPERATOR_NOT);
				
				setPropertyType(ISearchEntry.PROPERTY_TYPE_DATE);
				setValueAsDate(filter.dateValueLow);
				setValueType(ISearchEntry.VALUE_TYPE_DATE);							
			}
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_TERM)) {
			setValueAsString(filter.valueLow);
			setValueType(ISearchEntry.VALUE_TYPE_STRING);
			setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
			setTermWeight(1.0F);
			setRowType(ISearchEntry.ROW_TYPE_TERM);			
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_BRACKET_OPEN)) {
			setRowType(ISearchEntry.ROW_TYPE_BRACKET_OPEN);			
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_BRACKET_CLOSE)) {
			setRowType(ISearchEntry.ROW_TYPE_BRACKET_CLOSE);			
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_AND)) {
			setRowType(ISearchEntry.ROW_TYPE_OPERATOR);
			setValueAsString(ISearchEntry.OPERATOR_AND);
			setValueType(ISearchEntry.VALUE_TYPE_STRING);
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_OR)) {
			setRowType(ISearchEntry.ROW_TYPE_OPERATOR);
			setValueAsString(ISearchEntry.OPERATOR_OR);
			setValueType(ISearchEntry.VALUE_TYPE_STRING);
		}
		else if(filter.operation.equals(QueryFilter.OPERATION_NOT)) {
			setRowType(ISearchEntry.ROW_TYPE_OPERATOR);
			setValueAsString(ISearchEntry.OPERATOR_NOT);
			setValueType(ISearchEntry.VALUE_TYPE_STRING);
		}		
	}*/
	
	public SearchEntry() {
	}
	
	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setTaxonomySearch(boolean)
	 * @param taxSearch The value is <code>true<code> if the search must be done in the corresponding 
	 *  taxonomy folders
	 */
	public void setTaxonomySearch(boolean taxSearch) {
		m_bIsTaxonomySearch = taxSearch;
	}
	
	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#isTaxonomySearch()
	 * @return <code>true</code> if taxonomy search is enabled
	 */
	public boolean isTaxonomySearch() {
		return m_bIsTaxonomySearch;
	}
	
	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setFuzziness(int)
	 * @param fuzziness 	The value is between 0.0 and 1.0 where 1.0 is exact search
	 */	
	public void setFuzziness(float fuzziness){
		m_fFuzziness = fuzziness;
	}

	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getFuzziness()
	 * @return fuzziness
	 */
	public float getFuzziness() {
		return m_fFuzziness;
	}

	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setPropertyType(byte)  
	 * @param propertyType The value of Property Ttype, see static attributes PROPERTY_TYPE_xxx in KM API
	 */
	public void setPropertyType(byte propertyType) {
		m_iPropertyType = propertyType;	
	}

	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getPropertyType()  
	 *  @param propertyType The value of Property Ttype, see static attributes PROPERTY_TYPE_xxx in KM API
	 */	
	public byte getPropertyType() {
		return m_iPropertyType;
	}


	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setRowType(java.lang.String)
	 * @param rowType A value of Row Type, see static attributes ROW_TYPE_xxx in KM API
	 */	
	public void setRowType(String rowType) {
		m_sRowType = rowType;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getRowType()
	 * @return Row Type value as defined in KM API 
	 */
	public String getRowType() {
		return m_sRowType;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setTermWeight(float)
	 * @param weight The value of term weight in range <code>[0.0, 1.0]</code>
	 */	                
	public void setTermWeight(float weight) {
		 m_weight = weight;
	}
	
	
	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setTermWeight(float)
 	 * @return for possible return values, see static attribute TERM_ACTION_xxx  
	 */
	public float getTermWeight() {
		return m_weight;
	}


	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setTermAction(byte)
	 * @param termAction A value of Term Action, seee static attributes TERM_ACTION_xxx from KM API
	 */	                   
	public void setTermAction(byte termAction) {
		m_termAction = termAction;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getTermAction()
	 * @return the value as defined in static attributes TERM_ACTION_xxx in KM API
	 */
	public byte getTermAction() {
		return m_termAction;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setPropertyName(java.lang.String)
	 * @param propertyName The name of the property being searched
	 */	             
	public void setPropertyName(String propertyName) {
		m_sPropertyName = propertyName;		
	}
	
	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getPropertyName()
	 * @param propertyName The name of the property being searched
	 */	             
	public String getPropertyName() {
		return m_sPropertyName;	
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getPropertyNamespace()
	 * @return Property namespace
	 */	             
	public String getPropertyNamespace() {
		return m_sPropertyNamespace;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setPropertyNamespace(String)
	 * @param propertyNamespace Property namespace
	 */	             
	public void setPropertyNamespace(String propertyNamespace) {
		m_sPropertyNamespace = propertyNamespace;
	}

	/**  
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setPropertyOperator(byte)
	 * @param propertyOperator The value of the property operator
	 */	
	public void setPropertyOperator(byte propertyOperator) {
		m_propertyOperator = propertyOperator;
	}

	/**  
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getPropertyOperator()
	 * @param propertyOperator The value of the property operator
	 */		
	public byte getPropertyOperator() {
		return m_propertyOperator;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setValueAsString(java.lang.String)
	 * @param stringValue	The value to be set
	 */  
	public void setValueAsString(String stringValue) {
		m_sValue = stringValue;	
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getValueAsString()
	 * @param stringValue	The string value
	 */  	
	public String getValueAsString() {						
		return m_sValue;
	}
	
	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setValueAsInt(int)
	 * @param intValue	The value to be set
	 */  
	public void setValueAsInt(int intValue) {
		m_iValue1 = intValue;		
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getValueAsInt()
	 * @param intValue	The int value
	 */  	
	public int getValueAsInt(){
		return m_iValue1;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setValueAsDate(Date) 
	 * @param dateValue	The value to be set
	 */
	public void setValueAsDate(Date dateValue) {
		m_dValue1 = dateValue;
	} 
	
	/**
	 * The method returns entry's value type 
	 * @return entry's value type 
	 */
	public int getValueType() {
		return m_iValueType;
	}

	/**
	 * The method returns entry's value type 
	 * @return entry's value type 
	 */
	public void setValueType(int type) {
		m_iValueType = type;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getValueAsDate() 
	 * @param dateValue	The Date value
	 */	
	public Date getValueAsDate() {
		return m_dValue1;
	}

	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setRangeValue1stAsInt(int)  
	 * @param intValue1 Start range value
	 */	
	public void setRangeValue1stAsInt(int intValue) {
		m_iValue1 = intValue;		
	}
	
	
	public int getRangeValue1stAsInt() {
		return m_iValue1;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setRangeValue2ndAsInt(int)
	 * @param intValue2 End range value
	 */	
	public void setRangeValue2ndAsInt(int intValue) {
		m_iValue2 = intValue;
	}
	
	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getRangeValue2ndAsInt()
	 * @param intValue2 End range value 
	 */
	public int getRangeValue2ndAsInt() {
		return m_iValue2;
	}
	
	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setRangeValue1stAsDate(java.util.Date) 
	 * @param dateValue1 Start range value
	 */	
	public void setRangeValue1stAsDate(Date dateValue) {
		m_dValue1 = dateValue;
	}
	
	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#isTaxonomySearch() 
	 * @param dateValue1 Start range value 
	 */
	public Date getRangeValue1stAsDate() {
		return m_dValue1;
	}
	

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#setRangeValue2ndAsDate(java.util.Date) 
	 * @param dateValue1 Start range value
	 */	
	public void setRangeValue2ndAsDate(Date dateValue) {
		m_dValue2 = dateValue;		
	}
		
	/**
	 * @see com.sap.caf.km.idxsearch.IKMSearchEntry#getRangeValue2ndAsDate() 
	 * @return  
	 */
	public Date getRangeValue2ndAsDate() {
		return m_dValue2;	
	}
		
	private boolean m_bIsTaxonomySearch = false;
	private float m_fFuzziness = 1.0F;
	private byte m_iPropertyType = PROPERTY_TYPE_USE_META_MODEL;
	private String m_sRowType = ROW_TYPE_TERM;
	private float m_weight = 1.0F;
	private byte m_termAction = TERM_ACTION_LINGUISTIC;
	private String m_sPropertyName;
	
	private String m_sPropertyNamespace;
	
	private byte m_propertyOperator = PROPERTY_OPERATOR_EQUAL;
		
	private int m_iValueType = VALUE_TYPE_UNDEFINED;
		
	private String m_sValue;
	
	private int m_iValue1;
	private int m_iValue2;	

	private Date m_dValue1;
	private Date m_dValue2;		
}